/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Persistence {
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PeristenceProvider";
    protected static final Set<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
    private static final String SERVICE_NAME = "META-INF/services/" + PersistenceProvider.class.getName();
    private static final String PERSISTENCE_XML_NAME = "META-INF/persistence.xml";
    private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName) {
        return Persistence.createEntityManagerFactory(persistenceUnitName, null);
    }

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        EntityManagerFactory emf = null;
        Set<PersistenceProvider> providersFound = null;
        try {
            providersFound = Persistence.findAllProviders();
        }
        catch (IOException exc) {
            // empty catch block
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        HashSet<String> returnedNull = new HashSet<String>();
        for (PersistenceProvider provider : providersFound) {
            try {
                emf = provider.createEntityManagerFactory(persistenceUnitName, properties);
                if (emf != null) break;
                returnedNull.add(provider.getClass().getName());
            }
            catch (Throwable t) {
                errors.put(provider.getClass().getName(), Persistence.createErrorMessage(t));
            }
        }
        if (emf == null) {
            StringBuffer message = new StringBuffer("No Persistence provider for EntityManager named " + persistenceUnitName + ": ");
            if (!Persistence.exists(PERSISTENCE_XML_NAME)) {
                message.append(" No META-INF/persistence.xml was found in classpath.\n");
            } else {
                Map<String, String> reasons = Persistence.getReasons();
                for (Map.Entry<String, String> entry : reasons.entrySet()) {
                    message.append("Provider named ");
                    message.append((Object)entry.getKey());
                    message.append(" threw exception at initialization: ");
                    message.append(entry.getValue() + "\n");
                }
                for (Map.Entry<String, String> entry : errors.entrySet()) {
                    message.append("Provider named ");
                    message.append((Object)entry.getKey());
                    message.append(" threw unexpected exception at create EntityManagerFactory: \n");
                    message.append(entry.getValue() + "\n");
                }
                if (!returnedNull.isEmpty()) {
                    message.append(" The following providers:\n");
                    for (String string : returnedNull) {
                        message.append(string + "\n");
                    }
                    message.append("Returned null to createEntityManagerFactory.\n");
                }
            }
            throw new PersistenceException(message.toString());
        }
        return emf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<PersistenceProvider> findAllProviders() throws IOException {
        HashSet<PersistenceProvider> providersFound = new HashSet<PersistenceProvider>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> resources = loader.getResources(SERVICE_NAME);
        if (!resources.hasMoreElements()) {
            throw new PersistenceException("No resource files named " + SERVICE_NAME + " were found. Please make sure that the persistence provider jar file is in your classpath.");
        }
        HashSet<String> names = new HashSet<String>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            InputStream is = url.openStream();
            try {
                names.addAll(Persistence.providerNamesFromReader(new BufferedReader(new InputStreamReader(is))));
            }
            finally {
                is.close();
            }
        }
        if (names.isEmpty()) {
            throw new PersistenceException("No provider names were found in " + SERVICE_NAME);
        }
        for (String s : names) {
            try {
                providersFound.add((PersistenceProvider)loader.loadClass(s).newInstance());
            }
            catch (ClassNotFoundException exc) {
            }
            catch (InstantiationException exc) {
            }
            catch (IllegalAccessException exc) {}
        }
        return providersFound;
    }

    private static Set<String> providerNamesFromReader(BufferedReader reader) throws IOException {
        String line;
        HashSet<String> names = new HashSet<String>();
        while ((line = reader.readLine()) != null) {
            Matcher m = nonCommentPattern.matcher(line = line.trim());
            if (!m.find()) continue;
            names.add(m.group().trim());
        }
        return names;
    }

    private static boolean exists(String fileName) {
        Enumeration<URL> resources;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            resources = loader.getResources(fileName);
        }
        catch (IOException ex) {
            resources = null;
        }
        return resources == null ? false : resources.hasMoreElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getReasons() {
        HashMap<String, String> reasons = new HashMap<String, String>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        HashSet<String> names = new HashSet<String>();
        try {
            Enumeration<URL> resources = loader.getResources(SERVICE_NAME);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream is = url.openStream();
                try {
                    names.addAll(Persistence.providerNamesFromReader(new BufferedReader(new InputStreamReader(is))));
                }
                finally {
                    is.close();
                }
            }
        }
        catch (IOException exc) {
            // empty catch block
        }
        for (String s : names) {
            try {
                loader.loadClass(s).newInstance();
            }
            catch (ClassNotFoundException exc) {
                reasons.put(s, exc.getClass().getName() + " " + exc.getMessage());
            }
            catch (InstantiationException exc) {
                reasons.put(s, Persistence.createErrorMessage(exc));
            }
            catch (IllegalAccessException exc) {
                reasons.put(s, Persistence.createErrorMessage(exc));
            }
            catch (RuntimeException exc) {
                reasons.put(s, Persistence.createErrorMessage(exc));
            }
        }
        return reasons;
    }

    private static String createErrorMessage(Throwable t) {
        StringWriter errorMessage = new StringWriter();
        errorMessage.append(t.getClass().getName()).append("\r\n");
        t.printStackTrace(new PrintWriter(errorMessage));
        errorMessage.append("\r\n");
        return errorMessage.toString();
    }
}

