/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import com.sun.grizzly.util.net.ServerSocketFactory;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessControlException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.util.net.TcpConnectionHandler;
import org.apache.tomcat.util.net.TcpWorkerThread;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.ThreadPool;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

public class PoolTcpEndpoint {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.util.net.res");
    private static final int BACKLOG = 100;
    private static final int TIMEOUT = 1000;
    private final Object threadSync = new Object();
    private boolean isPool = true;
    private int backlog = 100;
    private int serverTimeout = 1000;
    TcpConnectionHandler handler;
    private InetAddress inet;
    private int port;
    private ServerSocketFactory factory;
    private ServerSocket serverSocket;
    ThreadPoolRunnable listener;
    private volatile boolean running = false;
    private boolean initialized = false;
    private boolean reinitializing = false;
    static final int debug = 0;
    ThreadPool tp;
    static Logger log = Logger.getLogger(PoolTcpEndpoint.class.getName());
    protected boolean tcpNoDelay = false;
    protected int linger = 100;
    protected int socketTimeout = -1;

    public PoolTcpEndpoint() {
        this.tp = new ThreadPool();
    }

    public PoolTcpEndpoint(ThreadPool tp) {
        this.tp = tp;
    }

    public void setPoolOn(boolean isPool) {
        this.isPool = isPool;
    }

    public boolean isPoolOn() {
        return this.isPool;
    }

    public void setMaxThreads(int maxThreads) {
        if (maxThreads > 0) {
            this.tp.setMaxThreads(maxThreads);
        }
    }

    public int getMaxThreads() {
        return this.tp.getMaxThreads();
    }

    public void setMaxSpareThreads(int maxThreads) {
        if (maxThreads > 0) {
            this.tp.setMaxSpareThreads(maxThreads);
        }
    }

    public int getMaxSpareThreads() {
        return this.tp.getMaxSpareThreads();
    }

    public void setMinSpareThreads(int minThreads) {
        if (minThreads > 0) {
            this.tp.setMinSpareThreads(minThreads);
        }
    }

    public int getMinSpareThreads() {
        return this.tp.getMinSpareThreads();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.inet;
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public void setServerSocket(ServerSocket ss) {
        this.serverSocket = ss;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    ServerSocketFactory getServerSocketFactory() {
        return this.factory;
    }

    public void setConnectionHandler(TcpConnectionHandler handler) {
        this.handler = handler;
    }

    public TcpConnectionHandler getConnectionHandler() {
        return this.handler;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setServerTimeout(int timeout) {
        this.serverTimeout = timeout;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean b) {
        this.tcpNoDelay = b;
    }

    public int getSoLinger() {
        return this.linger;
    }

    public void setSoLinger(int i) {
        this.linger = i;
    }

    public int getSoTimeout() {
        return this.socketTimeout;
    }

    public void setSoTimeout(int i) {
        this.socketTimeout = i;
    }

    public int getServerSoTimeout() {
        return this.serverTimeout;
    }

    public void setServerSoTimeout(int i) {
        this.serverTimeout = i;
    }

    public void initEndpoint() throws IOException, InstantiationException {
        try {
            if (this.factory == null) {
                this.factory = ServerSocketFactory.getDefault();
            }
            if (this.serverSocket == null) {
                try {
                    this.serverSocket = this.inet == null ? this.factory.createSocket(this.port, this.backlog) : this.factory.createSocket(this.port, this.backlog, this.inet);
                }
                catch (BindException be) {
                    throw new BindException(be.getMessage() + ":" + this.port);
                }
            }
            if (this.serverTimeout >= 0) {
                this.serverSocket.setSoTimeout(this.serverTimeout);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (InstantiationException ex1) {
            throw ex1;
        }
        this.initialized = true;
    }

    public void startEndpoint() throws IOException, InstantiationException {
        if (!this.initialized) {
            this.initEndpoint();
        }
        if (this.isPool) {
            this.tp.start();
        }
        this.running = true;
        if (this.isPool) {
            this.listener = new TcpWorkerThread(this);
            this.tp.runIt(this.listener);
        } else {
            log.severe("XXX Error - need pool !");
        }
    }

    public void stopEndpoint() {
        if (this.running) {
            this.tp.shutdown();
            this.running = false;
            if (this.serverSocket != null) {
                this.closeServerSocket();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeServerSocket() {
        Socket s = null;
        try {
            if (this.inet == null) {
                s = new Socket("127.0.0.1", this.port);
            } else {
                s = new Socket(this.inet, this.port);
                s.setSoLinger(true, 0);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Caught exception trying to unlock accept on " + this.port, e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception e) {}
            }
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Caught exception trying to close socket.", e);
        }
        this.serverSocket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Socket acceptSocket() {
        if (!this.running || this.serverSocket == null) {
            return null;
        }
        Socket accepted = null;
        try {
            accepted = this.factory == null ? this.serverSocket.accept() : this.factory.acceptSocket(this.serverSocket);
            if (null == accepted) {
                log.warning("Null socket returned by accept");
            } else if (!this.running) {
                accepted.close();
                accepted = null;
            } else if (this.factory != null) {
                this.factory.initSocket(accepted);
            }
        }
        catch (InterruptedIOException iioe) {
        }
        catch (AccessControlException ace) {
            String msg = this.sm.getString("endpoint.warn.security", this.serverSocket, ace);
            log.warning(msg);
        }
        catch (IOException e) {
            String msg = null;
            if (this.running) {
                msg = this.sm.getString("endpoint.err.nonfatal", this.serverSocket, e);
                log.log(Level.SEVERE, msg, e);
            }
            if (accepted != null) {
                try {
                    accepted.close();
                }
                catch (Throwable ex) {
                    msg = this.sm.getString("endpoint.err.nonfatal", accepted, ex);
                    log.log(Level.WARNING, msg, ex);
                }
                accepted = null;
            }
            if (!this.running) {
                return null;
            }
            this.reinitializing = true;
            Object object = this.threadSync;
            synchronized (object) {
                if (this.reinitializing) {
                    this.reinitializing = false;
                    this.closeServerSocket();
                    this.initialized = false;
                    try {
                        msg = this.sm.getString("endpoint.warn.reinit");
                        log.warning(msg);
                        this.initEndpoint();
                    }
                    catch (Throwable t) {
                        msg = this.sm.getString("endpoint.err.nonfatal", this.serverSocket, t);
                        log.log(Level.SEVERE, msg, t);
                    }
                    if (!this.initialized) {
                        msg = this.sm.getString("endpoint.warn.restart");
                        log.warning(msg);
                        try {
                            this.stopEndpoint();
                            this.initEndpoint();
                            this.startEndpoint();
                        }
                        catch (Throwable t) {
                            msg = this.sm.getString("endpoint.err.fatal", this.serverSocket, t);
                            log.log(Level.SEVERE, msg, t);
                        }
                        finally {
                            throw new ThreadDeath();
                        }
                    }
                }
            }
        }
        return accepted;
    }

    public void log(String msg) {
        log.info(msg);
    }

    public void log(String msg, Throwable t) {
        log.log(Level.SEVERE, msg, t);
    }

    public void log(String msg, int level) {
        log.info(msg);
    }

    public void log(String msg, Throwable t, int level) {
        log.log(Level.SEVERE, msg, t);
    }

    void setSocketOptions(Socket socket) throws SocketException {
        if (this.linger >= 0) {
            socket.setSoLinger(true, this.linger);
        }
        if (this.tcpNoDelay) {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        if (this.socketTimeout > 0) {
            socket.setSoTimeout(this.socketTimeout);
        }
    }
}

