/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;

public class EmbeddableAccessor
extends ClassAccessor {
    public EmbeddableAccessor() {
        super("<embeddable>");
    }

    public EmbeddableAccessor(Annotation annotation, Class cls, MetadataProject project) {
        super(annotation, cls, project);
    }

    protected void processEmbeddable() {
        if (this.getAccess() != null) {
            this.getDescriptor().setXMLAccess(this.getAccess());
        }
        if (this.getMetadataComplete() != null) {
            this.getDescriptor().setIgnoreAnnotations(this.isMetadataComplete());
        }
        if (this.getExcludeDefaultMappings() != null) {
            this.getDescriptor().setIgnoreDefaultMappings(this.excludeDefaultMappings());
        }
    }

    public void process() {
        this.processEmbeddable();
        if (this.isAnnotationPresent(Cache.class)) {
            throw ValidationException.cacheNotSupportedWithEmbeddable(this.getJavaClass());
        }
        this.processCustomizer();
        this.processConverters();
        this.processCopyPolicy();
        this.processChangeTracking();
        this.processProperties();
        this.processAccessors();
    }
}

