/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMultipart;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.ByteArrayDataSource;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLMarshaller;

public class XMLBinaryDataHelper {
    protected static XMLBinaryDataHelper binaryDataHelper;
    public Class DATA_HANDLER;
    public Class IMAGE;
    public Class SOURCE;
    public Class MULTIPART;

    public XMLBinaryDataHelper() {
        if (this.DATA_HANDLER == null) {
            this.initializeDataTypes();
        }
    }

    public static XMLBinaryDataHelper getXMLBinaryDataHelper() {
        if (binaryDataHelper == null) {
            XMLBinaryDataHelper.setXMLBinaryDataHelper(new XMLBinaryDataHelper());
        }
        return binaryDataHelper;
    }

    public static void setXMLBinaryDataHelper(XMLBinaryDataHelper helper) {
        binaryDataHelper = helper;
    }

    public void initializeDataTypes() {
        this.DATA_HANDLER = DataHandler.class;
        this.IMAGE = Image.class;
        this.SOURCE = Source.class;
        this.MULTIPART = MimeMultipart.class;
    }

    public Object convertObject(Object obj, Class classification, AbstractSession session) {
        if (classification == this.DATA_HANDLER) {
            return this.convertObjectToDataHandler(obj, session);
        }
        if (classification == this.IMAGE) {
            return this.convertObjectToImage(obj);
        }
        if (classification == this.SOURCE) {
            return this.convertObjectToSource(obj);
        }
        if (classification == this.MULTIPART) {
            return this.convertObjectToMultipart(obj);
        }
        return session.getDatasourcePlatform().getConversionManager().convertObject(obj, classification);
    }

    public EncodedData getBytesFromDataHandler(DataHandler handler) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            handler.writeTo(output);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new EncodedData(output.toByteArray(), handler.getContentType());
    }

    public EncodedData getBytesForBinaryValue(Object attributeValue, XMLMarshaller marshaller, String mimeType) {
        if (attributeValue instanceof DataHandler) {
            return this.getBytesFromDataHandler((DataHandler)attributeValue);
        }
        if (attributeValue instanceof Image) {
            return this.getBytesFromImage((Image)attributeValue, mimeType);
        }
        if (attributeValue instanceof Source) {
            return this.getBytesFromSource((Source)attributeValue, marshaller, mimeType);
        }
        if (attributeValue instanceof MimeMultipart) {
            return this.getBytesFromMultipart((MimeMultipart)attributeValue, marshaller);
        }
        if (attributeValue.getClass() == ClassConstants.APBYTE) {
            return new EncodedData((byte[])attributeValue, mimeType);
        }
        if (attributeValue.getClass() == ClassConstants.ABYTE) {
            return this.getBytesFromByteObjectArray((Byte[])attributeValue, mimeType);
        }
        return new EncodedData(new byte[0], null);
    }

    public EncodedData getBytesFromMultipart(MimeMultipart value, XMLMarshaller marshaller) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            ContentType contentType = new ContentType(value.getContentType());
            String boundary = contentType.getParameter("boundary");
            output.write(Helper.cr().getBytes());
            output.write(("Content-Type: " + contentType.getBaseType() + "; boundary=\"" + boundary + "\"\n").getBytes());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            value.writeTo(output);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return new EncodedData(output.toByteArray(), value.getContentType());
    }

    public EncodedData getBytesFromSource(Source source, XMLMarshaller marshaller, String mimeType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        marshaller.getTransformer().transform(source, (Result)result);
        if (mimeType == null) {
            mimeType = "application/xml";
        }
        return new EncodedData(out.toByteArray(), mimeType);
    }

    public EncodedData getBytesFromByteObjectArray(Byte[] bytes, String mimeType) {
        byte[] data = new byte[bytes.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = bytes[i];
        }
        return new EncodedData(data, mimeType);
    }

    public EncodedData getBytesFromImage(Image image, String mimeType) {
        if (mimeType == null || mimeType.startsWith("image/*")) {
            mimeType = "image/png";
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Iterator<ImageWriter> itr = ImageIO.getImageWritersByMIMEType(mimeType);
            if (!itr.hasNext()) {
                throw XMLMarshalException.noEncoderForMimeType(mimeType);
            }
            ImageWriter w = itr.next();
            w.setOutput(ImageIO.createImageOutputStream(outputStream));
            w.write(this.convertToBufferedImage(image));
            w.dispose();
            return new EncodedData(outputStream.toByteArray(), mimeType);
        }
        catch (Exception ex) {
            return new EncodedData(new byte[0], null);
        }
    }

    private BufferedImage convertToBufferedImage(Image image) throws IOException {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        MediaTracker tracker = new MediaTracker(new Component(){});
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
        BufferedImage bufImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bufImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        return bufImage;
    }

    public Object convertObjectToMultipart(Object obj) {
        if (obj instanceof MimeMultipart) {
            return obj;
        }
        if (obj instanceof DataHandler) {
            try {
                if (((DataHandler)obj).getContent() instanceof MimeMultipart) {
                    MimeMultipart multipart = (MimeMultipart)((DataHandler)obj).getContent();
                    return multipart;
                }
                return new MimeMultipart(((DataHandler)obj).getDataSource());
            }
            catch (Exception ex) {}
        } else {
            if (obj instanceof byte[]) {
                try {
                    byte[] bytes = (byte[])obj;
                    InputStreamReader in = new InputStreamReader(new ByteArrayInputStream(bytes));
                    int i = 0;
                    while (i != -1) {
                        i = in.read();
                    }
                    return new MimeMultipart(new ByteArrayDataSource((byte[])obj, "multipart/mixed"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            if (obj instanceof Byte[]) {
                Byte[] objectBytes = (Byte[])obj;
                byte[] bytes = new byte[objectBytes.length];
                for (int i = 0; i < objectBytes.length; ++i) {
                    bytes[i] = objectBytes[i];
                }
                try {
                    return new MimeMultipart(new ByteArrayDataSource(bytes, "multipart/mixed"));
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        return null;
    }

    public Object convertObjectToImage(Object obj) {
        if (obj instanceof Image) {
            return obj;
        }
        if (obj instanceof DataHandler) {
            try {
                if (((DataHandler)obj).getContent() instanceof Image) {
                    Image image = (Image)((DataHandler)obj).getContent();
                    return image;
                }
                return ImageIO.read(((DataHandler)obj).getInputStream());
            }
            catch (Exception ex) {}
        } else {
            if (obj instanceof byte[]) {
                ByteArrayInputStream stream = new ByteArrayInputStream((byte[])obj);
                try {
                    return ImageIO.read(stream);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            if (obj instanceof Byte[]) {
                Byte[] objectBytes = (Byte[])obj;
                byte[] bytes = new byte[objectBytes.length];
                for (int i = 0; i < objectBytes.length; ++i) {
                    bytes[i] = objectBytes[i];
                }
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                try {
                    return ImageIO.read(stream);
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        return null;
    }

    public String stringFromDataHandler(DataHandler source, QName schemaTypeQName, AbstractSession session) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            source.writeTo(output);
            return (String)((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(output.toByteArray(), String.class, schemaTypeQName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String stringFromDataHandler(Object source, QName schemaTypeQName, AbstractSession session) {
        return this.stringFromDataHandler((DataHandler)source, schemaTypeQName, session);
    }

    public String stringFromImage(Image image, QName schemaTypeQName, AbstractSession session) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Iterator<ImageWriter> itr;
            String mimeType = null;
            if (mimeType == null || mimeType.startsWith("image/*")) {
                mimeType = "image/png";
            }
            if (!(itr = ImageIO.getImageWritersByMIMEType(mimeType)).hasNext()) {
                throw new RuntimeException("no encoder for MIME type " + mimeType);
            }
            ImageWriter w = itr.next();
            w.setOutput(ImageIO.createImageOutputStream(outputStream));
            w.write(this.convertToBufferedImage(image));
            w.dispose();
            return ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).buildBase64StringFromBytes(outputStream.toByteArray());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String stringFromSource(Source source, QName schemaTypeQName, AbstractSession session) {
        DataHandler handler = new DataHandler(source, "text/xml");
        return this.stringFromDataHandler(handler, schemaTypeQName, session);
    }

    public String stringFromMultipart(MimeMultipart multipart, QName schemaTypeQName, AbstractSession session) {
        DataHandler handler = new DataHandler(multipart, multipart.getContentType());
        return this.stringFromDataHandler(handler, schemaTypeQName, session);
    }

    public DataHandler convertObjectToDataHandler(Object sourceObject, AbstractSession session) {
        byte[] bytes;
        DataHandler handler = null;
        if (sourceObject instanceof DataHandler) {
            return (DataHandler)sourceObject;
        }
        if (sourceObject instanceof byte[]) {
            bytes = (byte[])sourceObject;
            handler = new DataHandler(new ByteArrayDataSource(bytes, "application/octet-stream"));
        } else if (sourceObject instanceof Byte[]) {
            bytes = (byte[])session.getDatasourcePlatform().getConversionManager().convertObject(sourceObject, ClassConstants.APBYTE);
            handler = new DataHandler(new ByteArrayDataSource(bytes, "application/octet-stream"));
        }
        if (sourceObject instanceof String) {
            bytes = ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertSchemaBase64ToByteArray(sourceObject);
            handler = new DataHandler(new ByteArrayDataSource(bytes, "application/octet-stream"));
        } else if (sourceObject instanceof Image) {
            handler = new DataHandler(sourceObject, "image/jpeg");
        } else if (sourceObject instanceof Source) {
            handler = new DataHandler(sourceObject, "text/xml");
        } else if (sourceObject instanceof MimeMultipart) {
            handler = new DataHandler(sourceObject, ((MimeMultipart)sourceObject).getContentType());
        }
        return handler;
    }

    public Object convertObjectToSource(Object obj) {
        if (obj instanceof Source) {
            return obj;
        }
        if (obj instanceof DataHandler) {
            try {
                Source source = (Source)((DataHandler)obj).getContent();
                return source;
            }
            catch (Exception ex) {}
        } else {
            if (obj instanceof byte[]) {
                ByteArrayInputStream stream = new ByteArrayInputStream((byte[])obj);
                return new StreamSource(stream);
            }
            if (obj instanceof Byte[]) {
                Byte[] objectBytes = (Byte[])obj;
                byte[] bytes = new byte[objectBytes.length];
                for (int i = 0; i < objectBytes.length; ++i) {
                    bytes[i] = objectBytes[i];
                }
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                return new StreamSource(stream);
            }
        }
        return null;
    }

    public class EncodedData {
        private byte[] data;
        private String mimeType;

        public EncodedData(byte[] bytes, String contentType) {
            this.data = bytes;
            this.mimeType = contentType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setMimeType(String type) {
            this.mimeType = type;
        }

        public void setData(byte[] bytes) {
            this.data = bytes;
        }
    }
}

