/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.net.URI;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.XMLConversionException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DateFormatThreadLocal;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.TimeZoneHolder;
import org.eclipse.persistence.internal.oxm.conversion.Base64;
import org.eclipse.persistence.oxm.XMLConstants;

public class XMLConversionManager
extends ConversionManager
implements TimeZoneHolder {
    protected static final String GMT_ID = "GMT";
    protected static final String GMT_SUFFIX = "Z";
    protected static XMLConversionManager defaultXMLManager;
    protected static HashMap defaultXMLTypes;
    protected static HashMap defaultJavaTypes;
    protected static final String XSD_DATE_FORMAT_STR = "yyyy-MM-dd";
    protected DateFormatThreadLocal dateFormatter;
    protected static final String XSD_TIME_FORMAT_STR = "HH:mm:ss";
    protected DateFormatThreadLocal timeFormatter;
    protected static final String XSD_DATE_TIME_FORMAT_STR = "yyyy-MM-dd'T'HH:mm:ss";
    protected DateFormatThreadLocal dateTimeFormatter;
    protected static final String XSD_GDAY_FORMAT_STR = "----dd";
    protected DateFormatThreadLocal gDayFormatter;
    protected static final String XSD_GMONTH_FORMAT_STR = "--MM--";
    protected DateFormatThreadLocal gMonthFormatter;
    protected static final String XSD_GMONTH_DAY_FORMAT_STR = "--MM-dd";
    protected DateFormatThreadLocal gMonthDayFormatter;
    protected static final String XSD_GYEAR_FORMAT_STR = "yyyy";
    protected DateFormatThreadLocal gYearFormatter;
    protected static final String XSD_GYEAR_MONTH_FORMAT_STR = "yyyy-MM";
    protected DateFormatThreadLocal gYearMonthFormatter;
    protected boolean timeZoneQualified;
    protected TimeZone timeZone;

    public XMLConversionManager() {
        XMLConversionManager.buildFormatters(this);
        this.timeZoneQualified = false;
    }

    protected static void buildFormatters(XMLConversionManager xmlConversionManager) {
        xmlConversionManager.dateFormatter = new DateFormatThreadLocal(XSD_DATE_FORMAT_STR, null);
        xmlConversionManager.timeFormatter = new DateFormatThreadLocal(XSD_TIME_FORMAT_STR, xmlConversionManager);
        xmlConversionManager.dateTimeFormatter = new DateFormatThreadLocal(XSD_DATE_TIME_FORMAT_STR, xmlConversionManager);
        xmlConversionManager.gDayFormatter = new DateFormatThreadLocal(XSD_GDAY_FORMAT_STR, null);
        xmlConversionManager.gMonthFormatter = new DateFormatThreadLocal(XSD_GMONTH_FORMAT_STR, null);
        xmlConversionManager.gMonthDayFormatter = new DateFormatThreadLocal(XSD_GMONTH_DAY_FORMAT_STR, null);
        xmlConversionManager.gYearFormatter = new DateFormatThreadLocal(XSD_GYEAR_FORMAT_STR, null);
        xmlConversionManager.gYearMonthFormatter = new DateFormatThreadLocal(XSD_GYEAR_MONTH_FORMAT_STR, null);
    }

    public static XMLConversionManager getDefaultXMLManager() {
        if (defaultXMLManager == null) {
            defaultXMLManager = new XMLConversionManager();
        }
        return defaultXMLManager;
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            return TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean isTimeZoneQualified() {
        return this.timeZoneQualified;
    }

    public void setTimeZoneQualified(boolean timeZoneQualified) {
        this.timeZoneQualified = timeZoneQualified;
    }

    public Object convertObject(Object sourceObject, Class javaClass) throws ConversionException {
        if (sourceObject == null) {
            return super.convertObject(sourceObject, javaClass);
        }
        if (javaClass == XMLConstants.QNAME_CLASS && sourceObject != null) {
            return this.convertObjectToQName(sourceObject);
        }
        if (javaClass == ClassConstants.List_Class && sourceObject instanceof String) {
            return this.convertStringToList(sourceObject);
        }
        if (javaClass == ClassConstants.STRING && sourceObject instanceof List) {
            return this.convertListToString(sourceObject);
        }
        if (javaClass == ClassConstants.CALENDAR) {
            return this.convertObjectToCalendar(sourceObject);
        }
        if (javaClass == ClassConstants.UTILDATE) {
            return this.convertObjectToUtilDate(sourceObject, XMLConstants.DATE_TIME_QNAME);
        }
        if (javaClass == ClassConstants.SQLDATE) {
            return this.convertObjectToSQLDate(sourceObject, XMLConstants.DATE_QNAME);
        }
        if (javaClass == ClassConstants.TIME) {
            return this.convertObjectToSQLTime(sourceObject, XMLConstants.TIME_QNAME);
        }
        if (javaClass == ClassConstants.TIMESTAMP) {
            return this.convertObjectToTimestamp(sourceObject, XMLConstants.DATE_TIME_QNAME);
        }
        if (javaClass == URI.class) {
            return this.convertObjectToURI(sourceObject);
        }
        try {
            return super.convertObject(sourceObject, javaClass);
        }
        catch (ConversionException ex) {
            if (sourceObject.getClass() == ClassConstants.STRING) {
                return super.convertObject(((String)sourceObject).trim(), javaClass);
            }
            throw ex;
        }
    }

    public Object convertObject(Object sourceObject, Class javaClass, QName schemaTypeQName) throws ConversionException {
        if (schemaTypeQName == null) {
            return this.convertObject(sourceObject, javaClass);
        }
        if (sourceObject == null) {
            return super.convertObject(sourceObject, javaClass);
        }
        if (javaClass == ClassConstants.CALENDAR || javaClass == ClassConstants.GREGORIAN_CALENDAR) {
            return this.convertObjectToCalendar(sourceObject, schemaTypeQName);
        }
        if (javaClass == ClassConstants.ABYTE) {
            if (schemaTypeQName.getLocalPart().equalsIgnoreCase("hexBinary")) {
                return super.convertObjectToByteObjectArray(sourceObject);
            }
            if (schemaTypeQName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                return this.convertSchemaBase64ToByteObjectArray(sourceObject);
            }
        } else if (javaClass == ClassConstants.APBYTE) {
            if (schemaTypeQName.getLocalPart().equalsIgnoreCase("hexBinary")) {
                return super.convertObjectToByteArray(sourceObject);
            }
            if (schemaTypeQName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                return this.convertSchemaBase64ToByteArray(sourceObject);
            }
        } else {
            if (javaClass == ClassConstants.List_Class && sourceObject instanceof String) {
                return this.convertStringToList(sourceObject);
            }
            if (javaClass == ClassConstants.STRING && sourceObject instanceof List) {
                return this.convertListToString(sourceObject);
            }
            if (sourceObject instanceof byte[]) {
                if (schemaTypeQName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                    return this.buildBase64StringFromBytes((byte[])sourceObject);
                }
                return Helper.buildHexStringFromBytes((byte[])sourceObject);
            }
            if (sourceObject instanceof Byte[]) {
                if (schemaTypeQName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                    return this.buildBase64StringFromObjectBytes((Byte[])sourceObject);
                }
                return this.buildHexStringFromObjectBytes((Byte[])sourceObject);
            }
            if (javaClass == ClassConstants.UTILDATE) {
                return this.convertObjectToUtilDate(sourceObject, schemaTypeQName);
            }
            if (javaClass == ClassConstants.SQLDATE) {
                return this.convertObjectToSQLDate(sourceObject, schemaTypeQName);
            }
            if (javaClass == ClassConstants.TIME) {
                return this.convertObjectToSQLTime(sourceObject, schemaTypeQName);
            }
            if (javaClass == ClassConstants.TIMESTAMP) {
                return this.convertObjectToTimestamp(sourceObject, schemaTypeQName);
            }
            if (javaClass == XMLConstants.QNAME_CLASS && sourceObject != null) {
                return this.convertObjectToQName(sourceObject);
            }
            if (javaClass == ClassConstants.STRING) {
                return this.convertObjectToString(sourceObject, schemaTypeQName);
            }
            if (javaClass == URI.class) {
                return this.convertObjectToURI(sourceObject);
            }
            try {
                return super.convertObject(sourceObject, javaClass);
            }
            catch (ConversionException ex) {
                if (sourceObject.getClass() == ClassConstants.STRING) {
                    return super.convertObject(((String)sourceObject).trim(), javaClass);
                }
                throw ex;
            }
        }
        throw ConversionException.couldNotBeConverted(sourceObject, javaClass);
    }

    protected URI convertObjectToURI(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            try {
                return new URI((String)sourceObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw ConversionException.couldNotBeConverted(sourceObject, URI.class);
    }

    protected QName convertObjectToQName(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof QName) {
            return (QName)sourceObject;
        }
        if (sourceObject instanceof String) {
            return this.qnameFromString((String)sourceObject);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, XMLConstants.QNAME_CLASS);
    }

    protected Calendar convertObjectToCalendar(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            String sourceString = (String)sourceObject;
            if (sourceString.lastIndexOf(84) != -1) {
                return this.convertStringToCalendar((String)sourceObject, XMLConstants.DATE_TIME_QNAME);
            }
            if (sourceString.lastIndexOf(58) != -1) {
                return this.convertStringToCalendar((String)sourceObject, XMLConstants.TIME_QNAME);
            }
            return this.convertStringToCalendar((String)sourceObject, XMLConstants.DATE_QNAME);
        }
        return super.convertObjectToCalendar(sourceObject);
    }

    protected String convertObjectToString(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof Calendar) {
            return this.stringFromCalendar((Calendar)sourceObject);
        }
        if (sourceObject instanceof QName) {
            return this.stringFromQName((QName)sourceObject);
        }
        if (sourceObject instanceof Date) {
            return this.stringFromSQLDate((Date)sourceObject);
        }
        if (sourceObject instanceof Time) {
            return this.stringFromSQLTime((Time)sourceObject);
        }
        if (sourceObject instanceof Timestamp) {
            return this.stringFromTimestamp((Timestamp)sourceObject);
        }
        if (sourceObject instanceof java.util.Date) {
            return this.stringFromDate((java.util.Date)sourceObject);
        }
        return super.convertObjectToString(sourceObject);
    }

    protected String convertObjectToString(Object sourceObject, QName schemaTypeQName) throws ConversionException {
        if (sourceObject instanceof Calendar) {
            return this.stringFromCalendar((Calendar)sourceObject, schemaTypeQName);
        }
        if (sourceObject instanceof QName) {
            return this.stringFromQName((QName)sourceObject);
        }
        if (sourceObject instanceof Date) {
            return this.stringFromSQLDate((Date)sourceObject, schemaTypeQName);
        }
        if (sourceObject instanceof Time) {
            return this.stringFromSQLTime((Time)sourceObject, schemaTypeQName);
        }
        if (sourceObject instanceof Timestamp) {
            return this.stringFromTimestamp((Timestamp)sourceObject, schemaTypeQName);
        }
        if (sourceObject instanceof java.util.Date) {
            return this.stringFromDate((java.util.Date)sourceObject, schemaTypeQName);
        }
        return super.convertObjectToString(sourceObject);
    }

    private Calendar convertObjectToCalendar(Object sourceObject, QName schemaTypeQName) {
        if (sourceObject instanceof String) {
            return this.convertStringToCalendar((String)sourceObject, schemaTypeQName);
        }
        return super.convertObjectToCalendar(sourceObject);
    }

    public Calendar convertStringToCalendar(String sourceString, QName schemaTypeQName) {
        java.util.Date date = this.convertStringToDate(sourceString, schemaTypeQName);
        this.applyTimeZone(date, sourceString);
        return Helper.calendarFromUtilDate(date);
    }

    private java.util.Date convertObjectToUtilDate(Object sourceObject, QName schemaTypeQName) {
        if (sourceObject instanceof String) {
            return this.convertStringToDate((String)sourceObject, schemaTypeQName);
        }
        return super.convertObjectToUtilDate(sourceObject);
    }

    protected Date convertObjectToSQLDate(Object sourceObject, QName schemaTypeQName) {
        if (sourceObject instanceof String) {
            java.util.Date date = this.convertStringToDate((String)sourceObject, schemaTypeQName);
            return new Date(date.getTime() / 1000L * 1000L);
        }
        return super.convertObjectToDate(sourceObject);
    }

    protected Time convertObjectToSQLTime(Object sourceObject, QName schemaTypeQName) {
        if (sourceObject instanceof String) {
            java.util.Date date = this.convertStringToDate((String)sourceObject, schemaTypeQName);
            return new Time(date.getTime() / 1000L * 1000L);
        }
        return super.convertObjectToTime(sourceObject);
    }

    protected Timestamp convertStringToTimestamp(String sourceObject) {
        return this.convertStringToTimestamp(sourceObject, XMLConstants.DATE_TIME_QNAME);
    }

    protected Timestamp convertObjectToTimestamp(Object sourceObject, QName schemaTypeQName) {
        if (sourceObject instanceof String) {
            return this.convertStringToTimestamp((String)sourceObject, schemaTypeQName);
        }
        return super.convertObjectToTimestamp(sourceObject);
    }

    public Timestamp convertStringToTimestamp(String sourceString, QName schemaType) {
        java.util.Date date;
        if (XMLConstants.DATE_QNAME.equals(schemaType)) {
            try {
                date = this.dateFormatter.get().parse(sourceString);
            }
            catch (ParseException e) {
                throw ConversionException.incorrectDateFormat(sourceString);
            }
        } else {
            if (XMLConstants.TIME_QNAME.equals(schemaType)) {
                try {
                    return this.convertStringToTimestamp(sourceString, this.timeFormatter.get());
                }
                catch (ParseException e) {
                    throw XMLConversionException.incorrectTimestampTimeFormat(sourceString);
                }
                catch (NumberFormatException e) {
                    throw XMLConversionException.incorrectTimestampTimeFormat(sourceString);
                }
            }
            if (XMLConstants.G_DAY_QNAME.equals(schemaType)) {
                try {
                    date = this.gDayFormatter.get().parse(sourceString);
                }
                catch (ParseException e) {
                    throw XMLConversionException.incorrectGDayFormat(sourceString);
                }
            } else if (XMLConstants.G_MONTH_QNAME.equals(schemaType)) {
                try {
                    date = this.gMonthFormatter.get().parse(sourceString);
                }
                catch (ParseException e) {
                    throw XMLConversionException.incorrectGMonthFormat(sourceString);
                }
            } else {
                if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaType)) {
                    try {
                        return Helper.timestampFromDate(this.gMonthDayFormatter.get().parse(sourceString));
                    }
                    catch (ParseException e) {
                        throw XMLConversionException.incorrectGMonthDayFormat(sourceString);
                    }
                }
                if (XMLConstants.G_YEAR_QNAME.equals(schemaType)) {
                    try {
                        date = this.gYearFormatter.get().parse(sourceString);
                    }
                    catch (ParseException e) {
                        throw XMLConversionException.incorrectGYearFormat(sourceString);
                    }
                } else if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaType)) {
                    try {
                        date = this.gYearMonthFormatter.get().parse(sourceString);
                    }
                    catch (ParseException e) {
                        throw XMLConversionException.incorrectGYearMonthFormat(sourceString);
                    }
                } else {
                    if (XMLConstants.DURATION_QNAME.equals(schemaType)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        return this.convertStringToTimestamp(sourceString, this.dateTimeFormatter.get());
                    }
                    catch (ParseException e) {
                        throw XMLConversionException.incorrectTimestampDateTimeFormat(sourceString);
                    }
                    catch (NumberFormatException e) {
                        throw XMLConversionException.incorrectTimestampDateTimeFormat(sourceString);
                    }
                }
            }
        }
        this.applyTimeZone(date, sourceString);
        return Helper.timestampFromDate(date);
    }

    private Timestamp convertStringToTimestamp(String string, DateFormat dateFormat) throws ParseException {
        int decimalIndex = string.lastIndexOf(46);
        if (-1 == decimalIndex) {
            java.util.Date date = dateFormat.parse(string);
            this.applyTimeZone(date, string);
            return Helper.timestampFromDate(date);
        }
        java.util.Date date = dateFormat.parse(string.substring(0, decimalIndex));
        this.applyTimeZone(date, string);
        Timestamp timestamp = Helper.timestampFromDate(date);
        int timeZoneIndex = string.lastIndexOf(GMT_SUFFIX);
        if (-1 == timeZoneIndex) {
            timeZoneIndex = string.lastIndexOf(45);
            if (timeZoneIndex < decimalIndex) {
                timeZoneIndex = -1;
            }
            if (-1 == timeZoneIndex) {
                timeZoneIndex = string.lastIndexOf(43);
            }
        }
        String nsString = -1 == timeZoneIndex ? string.substring(decimalIndex + 1) : string.substring(decimalIndex + 1, timeZoneIndex);
        double ns = Long.valueOf(nsString).doubleValue();
        timestamp.setNanos((int)(ns *= Math.pow(10.0, 9 - nsString.length())));
        return timestamp;
    }

    public String stringFromCalendar(Calendar sourceCalendar, QName schemaTypeQName) {
        return this.stringFromDate(sourceCalendar.getTime(), schemaTypeQName);
    }

    private String stringFromCalendar(Calendar sourceCalendar) {
        if (!(sourceCalendar.isSet(10) || sourceCalendar.isSet(12) || sourceCalendar.isSet(13) || sourceCalendar.isSet(14))) {
            return this.dateFormatter.get().format(sourceCalendar.getTime());
        }
        if (!(sourceCalendar.isSet(1) || sourceCalendar.isSet(2) || sourceCalendar.isSet(5))) {
            String string = this.timeFormatter.get().format(sourceCalendar.getTime());
            int ms = (int)(sourceCalendar.getTimeInMillis() % 1000L);
            string = 0 == ms ? string + ".0" : string + '.' + Helper.buildZeroPrefixAndTruncTrailZeros(ms, 3);
            return this.appendTimeZone(string);
        }
        return this.stringFromDate(sourceCalendar.getTime());
    }

    private String stringFromDate(java.util.Date sourceDate) {
        String string = this.dateTimeFormatter.get().format(sourceDate);
        int ms = (int)(sourceDate.getTime() % 1000L);
        string = 0 == ms ? string + ".0" : string + '.' + Helper.buildZeroPrefixAndTruncTrailZeros(ms, 3);
        return this.appendTimeZone(string);
    }

    public java.util.Date convertStringToDate(String sourceString, QName schemaType) {
        java.util.Date date;
        if (XMLConstants.DATE_QNAME.equals(schemaType)) {
            try {
                date = this.dateFormatter.get().parse(sourceString);
            }
            catch (ParseException e) {
                throw ConversionException.incorrectDateFormat(sourceString);
            }
        } else {
            if (XMLConstants.TIME_QNAME.equals(schemaType)) {
                try {
                    return this.convertStringToDate(sourceString, this.timeFormatter.get());
                }
                catch (ParseException e) {
                    throw ConversionException.incorrectTimeFormat(sourceString);
                }
                catch (NumberFormatException e) {
                    throw ConversionException.incorrectTimeFormat(sourceString);
                }
            }
            if (XMLConstants.G_DAY_QNAME.equals(schemaType)) {
                try {
                    date = this.gDayFormatter.get().parse(sourceString);
                }
                catch (ParseException e) {
                    throw XMLConversionException.incorrectGDayFormat(sourceString);
                }
            } else if (XMLConstants.G_MONTH_QNAME.equals(schemaType)) {
                try {
                    date = this.gMonthFormatter.get().parse(sourceString);
                }
                catch (ParseException e) {
                    throw XMLConversionException.incorrectGMonthFormat(sourceString);
                }
            } else if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaType)) {
                try {
                    date = this.gMonthDayFormatter.get().parse(sourceString);
                }
                catch (ParseException e) {
                    throw XMLConversionException.incorrectGMonthDayFormat(sourceString);
                }
            } else if (XMLConstants.G_YEAR_QNAME.equals(schemaType)) {
                try {
                    date = this.gYearFormatter.get().parse(sourceString);
                }
                catch (ParseException e) {
                    throw XMLConversionException.incorrectGYearFormat(sourceString);
                }
            } else if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaType)) {
                try {
                    date = this.gYearMonthFormatter.get().parse(sourceString);
                }
                catch (ParseException e) {
                    throw XMLConversionException.incorrectGYearMonthFormat(sourceString);
                }
            } else {
                if (XMLConstants.DURATION_QNAME.equals(schemaType)) {
                    throw new IllegalArgumentException();
                }
                try {
                    return this.convertStringToDate(sourceString, this.dateTimeFormatter.get());
                }
                catch (ParseException e) {
                    throw ConversionException.incorrectDateTimeFormat(sourceString);
                }
                catch (NumberFormatException e) {
                    throw ConversionException.incorrectDateTimeFormat(sourceString);
                }
            }
        }
        this.applyTimeZone(date, sourceString);
        return date;
    }

    private java.util.Date convertStringToDate(String string, DateFormat dateFormat) throws ParseException {
        int decimalIndex = string.lastIndexOf(46);
        if (-1 == decimalIndex) {
            java.util.Date date = dateFormat.parse(string);
            this.applyTimeZone(date, string);
            return date;
        }
        java.util.Date date = dateFormat.parse(string.substring(0, decimalIndex));
        int timeZoneIndex = string.lastIndexOf(GMT_SUFFIX);
        if (-1 == timeZoneIndex) {
            timeZoneIndex = string.lastIndexOf(45);
            if (timeZoneIndex < decimalIndex) {
                timeZoneIndex = -1;
            }
            if (-1 == timeZoneIndex) {
                timeZoneIndex = string.lastIndexOf(43);
            }
        }
        String msString = -1 == timeZoneIndex ? string.substring(decimalIndex + 1) : string.substring(decimalIndex + 1, timeZoneIndex);
        double ms = Long.valueOf(msString).doubleValue();
        date.setTime(date.getTime() + (long)(ms *= Math.pow(10.0, 3 - msString.length())));
        this.applyTimeZone(date, string);
        return date;
    }

    public String stringFromDate(java.util.Date sourceDate, QName schemaType) {
        if (XMLConstants.DATE_QNAME.equals(schemaType)) {
            return this.dateFormatter.get().format(sourceDate);
        }
        if (XMLConstants.TIME_QNAME.equals(schemaType)) {
            String string = this.timeFormatter.get().format(sourceDate);
            int ms = (int)(sourceDate.getTime() % 1000L);
            string = 0 == ms ? string + ".0" : string + '.' + Helper.buildZeroPrefixAndTruncTrailZeros(ms, 3);
            return this.appendTimeZone(string);
        }
        if (XMLConstants.G_DAY_QNAME.equals(schemaType)) {
            return this.gDayFormatter.get().format(sourceDate);
        }
        if (XMLConstants.G_MONTH_QNAME.equals(schemaType)) {
            return this.gMonthFormatter.get().format(sourceDate);
        }
        if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaType)) {
            return this.gMonthDayFormatter.get().format(sourceDate);
        }
        if (XMLConstants.G_YEAR_QNAME.equals(schemaType)) {
            return this.gYearFormatter.get().format(sourceDate);
        }
        if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaType)) {
            return this.gYearMonthFormatter.get().format(sourceDate);
        }
        if (XMLConstants.DURATION_QNAME.equals(schemaType)) {
            throw new IllegalArgumentException();
        }
        return this.stringFromDate(sourceDate);
    }

    private String stringFromSQLDate(Date sourceDate) {
        return this.dateFormatter.get().format(sourceDate);
    }

    private String stringFromSQLDate(Date sourceDate, QName schemaType) {
        if (XMLConstants.DATE_TIME_QNAME.equals(schemaType)) {
            return this.dateTimeFormatter.get().format(sourceDate);
        }
        if (XMLConstants.TIME_QNAME.equals(schemaType)) {
            String string = this.timeFormatter.get().format(sourceDate);
            return this.appendTimeZone(string);
        }
        if (XMLConstants.G_DAY_QNAME.equals(schemaType)) {
            return this.gDayFormatter.get().format(sourceDate);
        }
        if (XMLConstants.G_MONTH_QNAME.equals(schemaType)) {
            return this.gMonthFormatter.get().format(sourceDate);
        }
        if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaType)) {
            return this.gMonthDayFormatter.get().format(sourceDate);
        }
        if (XMLConstants.G_YEAR_QNAME.equals(schemaType)) {
            return this.gYearFormatter.get().format(sourceDate);
        }
        if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaType)) {
            return this.gYearMonthFormatter.get().format(sourceDate);
        }
        if (XMLConstants.DURATION_QNAME.equals(schemaType)) {
            throw new IllegalArgumentException();
        }
        return this.stringFromSQLDate(sourceDate);
    }

    private String stringFromSQLTime(Time sourceTime) {
        String string = this.timeFormatter.get().format(sourceTime);
        return this.appendTimeZone(string);
    }

    private String stringFromSQLTime(Time sourceTime, QName schemaType) {
        if (XMLConstants.DATE_TIME_QNAME.equals(schemaType)) {
            String string = this.dateTimeFormatter.get().format(sourceTime);
            return this.appendTimeZone(string);
        }
        if (XMLConstants.DATE_QNAME.equals(schemaType)) {
            return this.dateFormatter.get().format(sourceTime);
        }
        if (XMLConstants.G_DAY_QNAME.equals(schemaType)) {
            return this.gDayFormatter.get().format(sourceTime);
        }
        if (XMLConstants.G_MONTH_QNAME.equals(schemaType)) {
            return this.gMonthFormatter.get().format(sourceTime);
        }
        if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaType)) {
            return this.gMonthDayFormatter.get().format(sourceTime);
        }
        if (XMLConstants.G_YEAR_QNAME.equals(schemaType)) {
            return this.gYearFormatter.get().format(sourceTime);
        }
        if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaType)) {
            return this.gYearMonthFormatter.get().format(sourceTime);
        }
        if (XMLConstants.DURATION_QNAME.equals(schemaType)) {
            throw new IllegalArgumentException();
        }
        return this.stringFromSQLTime(sourceTime);
    }

    private String stringFromTimestamp(Timestamp sourceDate) {
        String string = this.dateTimeFormatter.get().format(sourceDate);
        int ns = sourceDate.getNanos();
        string = 0 == ns ? string + ".0" : string + '.' + Helper.buildZeroPrefixAndTruncTrailZeros(ns, 9);
        return this.appendTimeZone(string);
    }

    private String stringFromTimestamp(Timestamp sourceDate, QName schemaType) {
        if (XMLConstants.DATE_TIME_QNAME.equals(schemaType)) {
            String string = this.dateTimeFormatter.get().format(sourceDate);
            int ns = sourceDate.getNanos();
            string = 0 == ns ? string + ".0" : string + '.' + Helper.buildZeroPrefixAndTruncTrailZeros(ns, 9);
            return this.appendTimeZone(string);
        }
        if (XMLConstants.DATE_QNAME.equals(schemaType)) {
            return this.dateFormatter.get().format(sourceDate);
        }
        if (XMLConstants.TIME_QNAME.equals(schemaType)) {
            String string = this.timeFormatter.get().format(sourceDate);
            int ns = sourceDate.getNanos();
            string = 0 == ns ? string + ".0" : string + '.' + Helper.buildZeroPrefixAndTruncTrailZeros(ns, 9);
            return this.appendTimeZone(string);
        }
        if (XMLConstants.G_DAY_QNAME.equals(schemaType)) {
            return this.gDayFormatter.get().format(sourceDate);
        }
        if (XMLConstants.G_MONTH_QNAME.equals(schemaType)) {
            return this.gMonthFormatter.get().format(sourceDate);
        }
        if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaType)) {
            return this.gMonthDayFormatter.get().format(sourceDate);
        }
        if (XMLConstants.G_YEAR_QNAME.equals(schemaType)) {
            return this.gYearFormatter.get().format(sourceDate);
        }
        if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaType)) {
            return this.gYearMonthFormatter.get().format(sourceDate);
        }
        if (XMLConstants.DURATION_QNAME.equals(schemaType)) {
            throw new IllegalArgumentException();
        }
        return this.stringFromTimestamp(sourceDate);
    }

    private String stringFromQName(QName sourceQName) {
        return sourceQName.toString();
    }

    private QName qnameFromString(String sourceString) {
        if (sourceString.indexOf(123) != -1) {
            String uri = sourceString.substring(sourceString.indexOf(123) + 1, sourceString.indexOf(125));
            String localpart = sourceString.substring(sourceString.indexOf(125) + 1);
            return new QName(uri, localpart);
        }
        return new QName(sourceString);
    }

    public byte[] convertSchemaBase64ToByteArray(Object sourceObject) throws ConversionException {
        if (!(sourceObject instanceof String)) {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.APBYTE);
        }
        byte[] bytes = Base64.base64Decode(((String)sourceObject).getBytes());
        return bytes;
    }

    protected Byte[] convertSchemaBase64ToByteObjectArray(Object sourceObject) throws ConversionException {
        byte[] bytes = this.convertSchemaBase64ToByteArray(sourceObject);
        Byte[] objectBytes = new Byte[bytes.length];
        for (int index = 0; index < bytes.length; ++index) {
            objectBytes[index] = new Byte(bytes[index]);
        }
        return objectBytes;
    }

    public String buildBase64StringFromBytes(byte[] bytes) {
        byte[] convertedBytes = Base64.base64Encode(bytes);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < convertedBytes.length; ++i) {
            buffer.append((char)convertedBytes[i]);
        }
        return buffer.toString();
    }

    public String buildBase64StringFromObjectBytes(Byte[] bytes) {
        byte[] primitiveBytes = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            primitiveBytes[i] = bytes[i];
        }
        return this.buildBase64StringFromBytes(primitiveBytes);
    }

    protected String buildHexStringFromObjectBytes(Byte[] bytes) {
        byte[] primitiveBytes = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            primitiveBytes[i] = bytes[i];
        }
        return Helper.buildHexStringFromBytes(primitiveBytes);
    }

    protected List convertStringToList(Object sourceObject) throws ConversionException {
        ArrayList<String> list = new ArrayList<String>();
        if (sourceObject instanceof String) {
            StringTokenizer tokenizer = new StringTokenizer((String)sourceObject, " ");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                list.add(token);
            }
        }
        return list;
    }

    protected String convertListToString(Object sourceObject) throws ConversionException {
        String returnString = new String();
        if (sourceObject instanceof List) {
            List list = (List)sourceObject;
            for (int i = 0; i < list.size(); ++i) {
                Object next = list.get(i);
                if (!(next instanceof String)) continue;
                if (i > 0) {
                    returnString = returnString + " ";
                }
                returnString = returnString + next;
            }
        }
        return returnString;
    }

    private TimeZone convertStringToTimeZone(String string) {
        if (GMT_SUFFIX.equals(string)) {
            return TimeZone.getTimeZone(GMT_ID);
        }
        return TimeZone.getTimeZone(GMT_ID + string);
    }

    public static HashMap getDefaultXMLTypes() {
        if (defaultXMLTypes == null) {
            defaultXMLTypes = XMLConversionManager.buildXMLTypes();
        }
        return defaultXMLTypes;
    }

    public static HashMap getDefaultJavaTypes() {
        if (defaultJavaTypes == null) {
            defaultJavaTypes = XMLConversionManager.buildJavaTypes();
        }
        return defaultJavaTypes;
    }

    private static HashMap buildXMLTypes() {
        HashMap<QName, Class> XMLTypes = new HashMap<QName, Class>();
        XMLTypes.put(XMLConstants.BASE_64_BINARY_QNAME, ClassConstants.APBYTE);
        XMLTypes.put(XMLConstants.BOOLEAN_QNAME, ClassConstants.PBOOLEAN);
        XMLTypes.put(XMLConstants.BYTE_QNAME, ClassConstants.PBYTE);
        XMLTypes.put(XMLConstants.DATE_QNAME, ClassConstants.CALENDAR);
        XMLTypes.put(XMLConstants.DATE_TIME_QNAME, ClassConstants.CALENDAR);
        XMLTypes.put(XMLConstants.DECIMAL_QNAME, ClassConstants.BIGDECIMAL);
        XMLTypes.put(XMLConstants.DOUBLE_QNAME, ClassConstants.PDOUBLE);
        XMLTypes.put(XMLConstants.FLOAT_QNAME, ClassConstants.PFLOAT);
        XMLTypes.put(XMLConstants.HEX_BINARY_QNAME, ClassConstants.APBYTE);
        XMLTypes.put(XMLConstants.INT_QNAME, ClassConstants.PINT);
        XMLTypes.put(XMLConstants.INTEGER_QNAME, ClassConstants.BIGINTEGER);
        XMLTypes.put(XMLConstants.LONG_QNAME, ClassConstants.PLONG);
        XMLTypes.put(XMLConstants.QNAME_QNAME, XMLConstants.QNAME_CLASS);
        XMLTypes.put(XMLConstants.SHORT_QNAME, ClassConstants.PSHORT);
        XMLTypes.put(XMLConstants.STRING_QNAME, ClassConstants.STRING);
        XMLTypes.put(XMLConstants.TIME_QNAME, ClassConstants.CALENDAR);
        XMLTypes.put(XMLConstants.UNSIGNED_BYTE_QNAME, ClassConstants.PSHORT);
        XMLTypes.put(XMLConstants.UNSIGNED_INT_QNAME, ClassConstants.PLONG);
        XMLTypes.put(XMLConstants.UNSIGNED_SHORT_QNAME, ClassConstants.PINT);
        XMLTypes.put(XMLConstants.ANY_SIMPLE_TYPE_QNAME, ClassConstants.STRING);
        return XMLTypes;
    }

    private static HashMap buildJavaTypes() {
        HashMap<Class, QName> javaTypes = new HashMap<Class, QName>();
        javaTypes.put(ClassConstants.APBYTE, XMLConstants.HEX_BINARY_QNAME);
        javaTypes.put(ClassConstants.BIGDECIMAL, XMLConstants.DECIMAL_QNAME);
        javaTypes.put(ClassConstants.BIGINTEGER, XMLConstants.INTEGER_QNAME);
        javaTypes.put(ClassConstants.PBOOLEAN, XMLConstants.BOOLEAN_QNAME);
        javaTypes.put(ClassConstants.PBYTE, XMLConstants.BYTE_QNAME);
        javaTypes.put(ClassConstants.CALENDAR, XMLConstants.DATE_TIME_QNAME);
        javaTypes.put(ClassConstants.PDOUBLE, XMLConstants.DOUBLE_QNAME);
        javaTypes.put(ClassConstants.PFLOAT, XMLConstants.FLOAT_QNAME);
        javaTypes.put(ClassConstants.PINT, XMLConstants.INT_QNAME);
        javaTypes.put(ClassConstants.PLONG, XMLConstants.LONG_QNAME);
        javaTypes.put(ClassConstants.PSHORT, XMLConstants.SHORT_QNAME);
        javaTypes.put(XMLConstants.QNAME_CLASS, XMLConstants.QNAME_QNAME);
        javaTypes.put(ClassConstants.STRING, XMLConstants.STRING_QNAME);
        javaTypes.put(ClassConstants.ABYTE, XMLConstants.HEX_BINARY_QNAME);
        javaTypes.put(ClassConstants.BOOLEAN, XMLConstants.BOOLEAN_QNAME);
        javaTypes.put(ClassConstants.BYTE, XMLConstants.BYTE_QNAME);
        javaTypes.put(ClassConstants.GREGORIAN_CALENDAR, XMLConstants.DATE_TIME_QNAME);
        javaTypes.put(ClassConstants.DOUBLE, XMLConstants.DOUBLE_QNAME);
        javaTypes.put(ClassConstants.FLOAT, XMLConstants.FLOAT_QNAME);
        javaTypes.put(ClassConstants.INTEGER, XMLConstants.INT_QNAME);
        javaTypes.put(ClassConstants.LONG, XMLConstants.LONG_QNAME);
        javaTypes.put(ClassConstants.SHORT, XMLConstants.SHORT_QNAME);
        javaTypes.put(ClassConstants.UTILDATE, XMLConstants.DATE_TIME_QNAME);
        return javaTypes;
    }

    private String appendTimeZone(String string) {
        if (!this.timeZoneQualified) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        int rawMinuteOffset = this.getTimeZone().getRawOffset() / 60000;
        if (0 == rawMinuteOffset) {
            stringBuilder.append(GMT_SUFFIX);
            return stringBuilder.toString();
        }
        if (rawMinuteOffset < 0) {
            stringBuilder.append('-');
            rawMinuteOffset = Math.abs(rawMinuteOffset);
        } else {
            stringBuilder.append('+');
        }
        int hourOffset = rawMinuteOffset / 60;
        if (hourOffset < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(hourOffset);
        stringBuilder.append(':');
        int minuteOffset = rawMinuteOffset % 60;
        if (minuteOffset < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(minuteOffset);
        return stringBuilder.toString();
    }

    private void applyTimeZone(java.util.Date date, String string) {
        int stringTimeZoneRawOffset;
        if (null == string) {
            return;
        }
        if (string.charAt(string.length() - 1) == 'Z') {
            stringTimeZoneRawOffset = 0;
        } else {
            int timeZoneIndex = string.lastIndexOf(43);
            if (-1 == timeZoneIndex) {
                timeZoneIndex = string.lastIndexOf(45);
                if (-1 == timeZoneIndex) {
                    return;
                }
                int lastColonIndex = string.lastIndexOf(58);
                if (lastColonIndex - timeZoneIndex != 3) {
                    return;
                }
            }
            TimeZone stringTimeZone = this.convertStringToTimeZone(string.substring(timeZoneIndex));
            stringTimeZoneRawOffset = stringTimeZone.getRawOffset();
        }
        int formatTimeZoneRawOffset = this.getTimeZone().getRawOffset();
        int timeZoneAdjustment = formatTimeZoneRawOffset - stringTimeZoneRawOffset;
        date.setTime(date.getTime() + (long)timeZoneAdjustment);
    }

    public Object clone() {
        XMLConversionManager clone = (XMLConversionManager)super.clone();
        XMLConversionManager.buildFormatters(clone);
        return clone;
    }
}

