/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.coordination.broadcast;

import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.broadcast.BroadcastTransportManager;

public abstract class BroadcastRemoteConnection
extends RemoteConnection {
    protected RemoteCommandManager rcm;
    protected String topicName;
    public static final String STATE_ACTIVE = "ACTIVE";
    public static final String STATE_CLOSING = "CLOSING";
    public static final String STATE_CLOSED = "CLOSED";
    protected String state = "ACTIVE";
    protected String displayString;
    protected Object[] info;
    protected Object[] infoExt;

    public BroadcastRemoteConnection(RemoteCommandManager rcm) {
        this.serviceId = rcm.getServiceId();
        this.rcm = rcm;
        this.topicName = ((BroadcastTransportManager)rcm.getTransportManager()).getTopicName();
    }

    public Object executeCommand(Command command) throws CommunicationException {
        if (this.isActive()) {
            try {
                return this.executeCommandInternal(command);
            }
            catch (Exception exception) {
                throw CommunicationException.errorSendingMessage(this.getServiceId().getId(), exception);
            }
        }
        this.rcm.logWarning("broadcast_ignored_command_while_closing_connection", this.getInfo());
        return null;
    }

    protected abstract Object executeCommandInternal(Command var1) throws Exception;

    protected Object[] logDebugBeforePublish(String messageId) {
        Object[] debugInfo = null;
        debugInfo = messageId == null ? this.getInfoExt() : new Object[]{this.toString(), messageId};
        this.rcm.logDebugWithoutLevelCheck("broadcast_sending_message", debugInfo);
        return debugInfo;
    }

    protected void logDebugAfterPublish(Object[] debugInfo, String messageId) {
        if (messageId != null) {
            if (debugInfo == this.getInfoExt()) {
                debugInfo = new Object[]{this.toString(), messageId};
            } else {
                debugInfo[3] = messageId;
            }
        }
        this.rcm.logDebugWithoutLevelCheck("broadcast_sent_message", debugInfo);
    }

    protected void logDebugOnReceiveMessage(String messageId) {
        Object[] debugInfo = null;
        debugInfo = messageId == null ? this.getInfoExt() : new Object[]{this.toString(), messageId};
        this.rcm.logDebugWithoutLevelCheck("broadcast_retreived_message", debugInfo);
    }

    protected void processReceivedObject(Object object, String messageId) {
        Command remoteCommand = null;
        if (object instanceof Command) {
            remoteCommand = (Command)object;
            try {
                if (this.shouldCheckServiceId() && remoteCommand.getServiceId().getId().equals(this.serviceId.getId())) {
                    return;
                }
                if (remoteCommand.getServiceId().getChannel().equals(this.serviceId.getChannel())) {
                    if (this.rcm.shouldLogDebugMessage()) {
                        Object[] args = new Object[]{this.toString(), messageId, remoteCommand.getServiceId().toString(), Helper.getShortClassName(remoteCommand)};
                        this.rcm.logDebugWithoutLevelCheck("broadcast_processing_remote_command", args);
                    }
                    this.rcm.processCommandFromRemoteConnection(remoteCommand);
                } else if (this.rcm.shouldLogWarningMessage()) {
                    Object[] args = new Object[]{this.toString(), messageId, remoteCommand.getServiceId().toString(), Helper.getShortClassName(remoteCommand)};
                    this.rcm.logWarningWithoutLevelCheck("broadcast_ignore_remote_command_from_different_channel", args);
                }
            }
            catch (RuntimeException e) {
                try {
                    this.rcm.handleException(RemoteCommandManagerException.errorProcessingRemoteCommand(this.toString(), messageId, remoteCommand.getServiceId().toString(), Helper.getShortClassName(remoteCommand), e));
                }
                catch (RuntimeException ex) {}
            }
        } else if (object == null) {
            Object[] args = new Object[]{this.toString(), messageId};
            this.rcm.logWarning("broadcast_remote_command_is_null", args);
        } else if (this.rcm.shouldLogWarningMessage()) {
            String className = object.getClass().getName();
            Object[] args = new Object[]{this.toString(), messageId, className};
            this.rcm.logWarningWithoutLevelCheck("broadcast_remote_command_wrong_type", args);
        }
    }

    protected void failDeserializeMessage(String messageId, Exception exception) {
        try {
            this.rcm.handleException(RemoteCommandManagerException.errorDeserializeRemoteCommand(this.toString(), messageId, exception));
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        BroadcastRemoteConnection broadcastRemoteConnection = this;
        synchronized (broadcastRemoteConnection) {
            if (this.isClosing()) {
                this.rcm.logWarning("broadcast_connection_already_closing", this.getInfo());
                return;
            }
            if (this.isClosed()) {
                this.rcm.logWarning("broadcast_connection_already_closed", this.getInfo());
                return;
            }
            this.state = STATE_CLOSING;
        }
        try {
            this.rcm.logDebug("broadcast_closing_connection", this.getInfo());
            this.closeInternal();
        }
        catch (Exception exception) {
            Object[] args = new Object[]{this.toString(), exception};
            this.rcm.logWarning("broadcast_exception_thrown_when_attempting_to_close_connection", args);
        }
        finally {
            if (this.areAllResourcesFreedOnClose()) {
                this.rcm.logDebug("broadcast_connection_closed", this.getInfo());
                this.state = STATE_CLOSED;
            }
        }
    }

    public String getState() {
        return this.state;
    }

    public boolean isActive() {
        return this.state == STATE_ACTIVE;
    }

    public boolean isClosing() {
        return this.state == STATE_CLOSING;
    }

    public boolean isClosed() {
        return this.state == STATE_CLOSED;
    }

    protected abstract void closeInternal() throws Exception;

    public String getTopicName() {
        return this.topicName;
    }

    protected Object[] getInfo() {
        if (this.info == null) {
            this.info = new Object[]{this.toString()};
        }
        return this.info;
    }

    protected Object[] getInfoExt() {
        if (this.infoExt == null) {
            this.infoExt = new Object[]{this.toString(), ""};
        }
        return this.infoExt;
    }

    protected boolean areAllResourcesFreedOnClose() {
        return true;
    }

    public String toString() {
        if (this.displayString == null) {
            this.createDisplayString();
        }
        return this.displayString;
    }

    protected void createDisplayString() {
        this.displayString = Helper.getShortClassName(this) + "[" + this.serviceId.toString() + ", topic " + this.topicName + "]";
    }

    protected boolean shouldCheckServiceId() {
        return false;
    }
}

