/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.documentpreservation.XMLBinderPolicy;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshaller;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLBinder {
    SAXUnmarshaller saxUnmarshaller;
    XMLContext context;
    XMLUnmarshaller unmarshaller;
    DocumentPreservationPolicy documentPreservationPolicy;
    DOMReader reader;

    public XMLBinder(XMLContext context) {
        this.unmarshaller = context.createUnmarshaller();
        this.saxUnmarshaller = new SAXUnmarshaller(this.unmarshaller);
        this.context = context;
        this.documentPreservationPolicy = new XMLBinderPolicy();
        this.reader = new DOMReader();
    }

    public Object unmarshal(Node node) {
        this.reader.setDocPresPolicy(this.documentPreservationPolicy);
        Object toReturn = this.saxUnmarshaller.unmarshal(this.reader, node);
        return toReturn;
    }

    public XMLRoot unmarshal(Node node, Class javaClass) {
        XMLRoot root = null;
        this.reader.setDocPresPolicy(this.documentPreservationPolicy);
        root = (XMLRoot)this.saxUnmarshaller.unmarshal(this.reader, node, javaClass);
        return root;
    }

    public void updateXML(Object obj) {
        Node associatedNode;
        if (obj instanceof XMLRoot) {
            obj = ((XMLRoot)obj).getObject();
        }
        if ((associatedNode = this.documentPreservationPolicy.getNodeForObject(obj)) == null) {
            return;
        }
        this.updateXML(obj, associatedNode);
    }

    public void updateXML(Object obj, Node associatedNode) {
        if (obj instanceof XMLRoot) {
            obj = ((XMLRoot)obj).getObject();
        }
        AbstractSession session = this.context.getSession(obj);
        DOMRecord root = new DOMRecord((Element)associatedNode);
        root.setDocPresPolicy(this.documentPreservationPolicy);
        XMLDescriptor rootDescriptor = (XMLDescriptor)session.getDescriptor(obj);
        ((XMLObjectBuilder)rootDescriptor.getObjectBuilder()).buildIntoNestedRow(root, obj, session);
    }

    public Node getXMLNode(Object object) {
        return this.documentPreservationPolicy.getNodeForObject(object);
    }

    public Object getObject(Node node) {
        return this.documentPreservationPolicy.getObjectForNode(node);
    }

    public void updateObject(Node node) {
        Object cachedObject = this.documentPreservationPolicy.getObjectForNode(node);
        if (cachedObject != null) {
            this.unmarshal(node);
        }
    }

    public DocumentPreservationPolicy getDocumentPreservationPolicy() {
        return this.documentPreservationPolicy;
    }
}

