/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.cmd;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.amx.cmd.AMXCommandBase;
import org.glassfish.admin.amx.loader.AMXStartupService;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Service;

@Service(name="amx", metadata="mode=debug")
@I18n(value="amx.command")
public final class AMXCommand
extends AMXCommandBase
implements AdminCommand {
    protected final String getCmdName() {
        return this.getLocalString("amx.command");
    }

    public final synchronized void _execute(AdminCommandContext context) {
        DomainRoot domainRoot = ProxyFactory.getInstance(this.getMBeanServer()).getDomainRoot();
        ActionReport report = this.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.getTopMessagePart().addChild().setMessage(JMXUtil.getMBeanServerDelegateInfo(this.getMBeanServer()));
        JMXServiceURL[] serviceURLs = AMXStartupService.getAMXStartupServiceMBeanProxy(this.getMBeanServer()).getJMXServiceURLs();
        report.getTopMessagePart().addChild().setMessage("JMXServiceURLs[] ===> " + StringUtil.toString(", ", new Object[]{serviceURLs}));
        ObjectName amxPattern = JMXUtil.newObjectName("amx:*");
        Set<ObjectName> mbeans = JMXUtil.queryNames(this.getMBeanServer(), amxPattern, null);
        List<String> mbeanList = JMXUtil.objectNamesToStrings(mbeans);
        Collections.sort(mbeanList);
        String msg = "AMX initialized and ready for use." + StringUtil.NEWLINE();
        report.setMessage(msg);
        for (String on : mbeanList) {
            report.getTopMessagePart().addChild().setMessage(on);
        }
    }
}

