/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.cmd;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.AMXBooter;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Date;
import javax.management.MBeanServer;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;

abstract class AMXCommandBase
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AMXCommandBase.class);
    @Inject
    private MBeanServer mMBeanServer;
    private volatile AdminCommandContext mAdminCommandContext;

    protected final MBeanServer getMBeanServer() {
        return this.mMBeanServer;
    }

    protected static void debug(String s) {
        System.out.println(s);
    }

    protected ActionReport getActionReport() {
        return this.mAdminCommandContext.getActionReport();
    }

    protected final String getLocalString(String key, String def) {
        return localStrings.getLocalString(key, def);
    }

    protected final String getLocalString(String key) {
        return this.getLocalString(key, key);
    }

    protected abstract String getCmdName();

    protected final String getCmdDescription() {
        return this.getLocalString(this.getCmdName() + ".description");
    }

    protected void preExecute(AdminCommandContext context) {
        this.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
        AMXBooter.bootAMX(this.mMBeanServer);
    }

    protected DomainRoot getDomainRoot() {
        return ProxyFactory.getInstance(this.getMBeanServer()).getDomainRoot();
    }

    protected abstract void _execute(AdminCommandContext var1);

    protected void postExecute(AdminCommandContext context, boolean success) {
        String cmdName = this.getCmdName();
        ActionReport report = this.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart().addChild();
        if (success) {
            part.setMessage("AMXCommand \"" + cmdName + "\" executed successfully at: " + new Date());
        } else {
            part.setMessage("AMXCommand " + cmdName + " FAILED: ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(AdminCommandContext context) {
        this.mAdminCommandContext = context;
        boolean success = false;
        try {
            this.preExecute(context);
            this._execute(context);
            success = true;
        }
        finally {
            this.postExecute(context, success);
        }
    }
}

