/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.j2ee;

import com.sun.appserv.management.util.misc.ExceptionUtil;
import javax.management.AttributeNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.admin.amx.j2ee.J2EEServerImpl;
import org.glassfish.admin.amx.mbean.DummyDelegate;
import org.glassfish.admin.amx.util.Issues;

public class DASJ2EEServerImpl
extends J2EEServerImpl
implements NotificationListener {
    static final String DAS_SERVER_NAME = "server";

    public DASJ2EEServerImpl(ObjectName parentObjectName) {
        super("J2EEDomain", parentObjectName, DummyDelegate.INSTANCE);
        Issues.getAMXIssues().notDone("DASJ2EEServer needs to account for DAS/non-DAS");
    }

    private boolean remoteServerIsRunning() {
        return 1 == this.getstate();
    }

    private boolean remoteServerIsStartable() {
        int cState = this.getstate();
        return 3 == cState || 4 == cState;
    }

    private boolean remoteServerIsStoppable() {
        int cState = this.getstate();
        return 0 == cState || 1 == cState || 4 == cState;
    }

    public void handleNotification(Notification notif, Object ignore) {
        String notifType = notif.getType();
    }

    private synchronized void setDelegate() {
    }

    public void preRegisterDone() throws Exception {
        super.preRegisterDone();
        this.setstartTime(0L);
        this.setDelegate();
    }

    protected String getServerName() {
        return this.getSelfName();
    }

    public boolean isstateManageable() {
        return true;
    }

    public int getstate() {
        int state = 3;
        try {
            Issues.getAMXIssues().notDone("DASJ2EEServerImpl.getRuntimeStatus: getRuntimeStatus");
            state = 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    public void start() {
        if (!this.remoteServerIsStartable()) {
            throw new RuntimeException("server is not in a startable state");
        }
        this.startRemoteServer();
    }

    public void startRecursive() {
        this.start();
    }

    private boolean isDASJ2EEServer() {
        return DAS_SERVER_NAME.equals(this.getName());
    }

    public void stop() {
        if (this.isDASJ2EEServer()) {
            this.getDelegate().invoke("stop", null, null);
        } else if (this.remoteServerIsStoppable()) {
            this.stopRemoteServer();
        } else {
            throw new RuntimeException("server is not in a stoppable state");
        }
    }

    private void startRemoteServer() {
        Issues.getAMXIssues().notDone("DASJ2EEServerImpl.startRemoteServer");
    }

    private void stopRemoteServer() {
        Issues.getAMXIssues().notDone("DASJ2EEServerImpl.stopRemoteServer");
    }

    public boolean getRestartRequired() {
        if (this.getDelegate() == null || this.getDelegate() == DummyDelegate.INSTANCE) {
            this.setDelegate();
        }
        boolean required = true;
        int state = this.getstate();
        if (state == 3 || state == 4 || state == 2) {
            required = true;
        } else {
            try {
                Object result = this.getDelegate().getAttribute("restartRequired");
                required = Boolean.valueOf("" + result);
            }
            catch (AttributeNotFoundException e) {
                this.logWarning(ExceptionUtil.toString(e));
                required = true;
            }
        }
        return required;
    }
}

