/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.base.SystemInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServer;
import org.glassfish.admin.amx.mbean.AMXNonConfigImplBase;
import org.glassfish.admin.amx.util.ObjectNames;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemInfoImpl
extends AMXNonConfigImplBase
implements SystemInfo {
    private final MBeanServer mServer;
    private final ConcurrentMap<String, Boolean> mFeatures;
    private static long LAST_REFRESH = 0L;

    public SystemInfoImpl(MBeanServer server) {
        super("X-SystemInfo", "X-SystemInfo", ObjectNames.getInstance().getDomainRootObjectName(), SystemInfo.class, null);
        this.mServer = server;
        this.mFeatures = new ConcurrentHashMap<String, Boolean>();
    }

    public void addFeature(String featureName, boolean available) {
        if (featureName == null || featureName.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.mFeatures.put(featureName, available);
    }

    @Override
    public final String getGroup() {
        return "utility";
    }

    @Override
    public String[] getFeatureNames() {
        ArrayList nameList = new ArrayList(this.mFeatures.keySet());
        String[] names = new String[nameList.size()];
        nameList.toArray(names);
        return names;
    }

    @Override
    public boolean supportsFeature(String key) {
        boolean supports = false;
        Boolean result = (Boolean)this.mFeatures.get(key);
        if (result == null) {
            result = Boolean.FALSE;
        }
        return result;
    }

    @Override
    public Map<String, Long> getPerformanceMillis() {
        return new HashMap<String, Long>();
    }

    private void _refresh() {
    }

    private synchronized void refresh() {
        long REFRESH_MILLIS = 5000L;
        long elapsed = System.currentTimeMillis() - LAST_REFRESH;
        if (elapsed > 5000L) {
            this._refresh();
        }
    }
}

