/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-resource-refs")
@Scoped(value=PerLookup.class)
@I18n(value="list.resource.refs")
public class ListResourceRefs
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListResourceRefs.class);
    @Param(optional=true, primary=true)
    String target = "server";
    @Inject
    Server[] servers;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            for (Server server : this.servers) {
                if (!server.getName().equals(this.target)) continue;
                List<ResourceRef> resourceRefs = server.getResourceRef();
                if (resourceRefs.isEmpty()) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(localStrings.getLocalString("NothingToList", "Nothing to List."));
                    continue;
                }
                for (ResourceRef ref : resourceRefs) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(ref.getRef());
                }
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.resource.refs.failed", "list-resource-refs failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

