/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.connector.rmi;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.ServerSocket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.glassfish.admin.connector.rmi.JmxServiceUrlFactory;
import org.glassfish.admin.connector.rmi.RemoteJmxProtocol;
import org.glassfish.admin.connector.rmi.RmiStubRegistryHandler;

public class JmxConnectorServerDriver {
    private final Map env = new HashMap();
    private JMXServiceURL url;
    private JMXServiceURL jconsoleurl;
    private int port;
    private RemoteJmxProtocol protocol = RemoteJmxProtocol.RMIJRMP;
    private boolean secureRegistry = false;
    private boolean ssl = false;
    private RMIServerSocketFactory rmissf;
    private RMIClientSocketFactory rmicsf;
    private boolean auth = false;
    private JMXAuthenticator authenticator = null;
    private Logger logger;
    private MBeanServer mbs;

    private static void debug(String s) {
        System.out.println("### " + s);
    }

    public static void main(String[] args) {
        int port = 8686;
        String protocol = RemoteJmxProtocol.RMIJRMP.toString();
        if (args.length >= 1) {
            port = Integer.parseInt(args[0]);
        }
        if (args.length >= 2) {
            protocol = args[1];
        }
        JmxConnectorServerDriver.debug("JmxConnectorServerDriver.main(): port: " + port + ", protocol: " + protocol);
        JmxConnectorServerDriver.testStart(port, protocol);
    }

    public static void testStart(int port, String protocol) {
        try {
            JmxConnectorServerDriver dr = new JmxConnectorServerDriver();
            dr.setMBeanServer(ManagementFactory.getPlatformMBeanServer());
            dr.setProtocol(RemoteJmxProtocol.instance(protocol));
            dr.setPort(port);
            dr.setSsl(false);
            dr.setAuthentication(false);
            dr.setRmiRegistrySecureFlag(false);
            JMXConnectorServer server = dr.startConnectorServer();
            JmxConnectorServerDriver.debug("testStartRMI: created RMI connector @ " + server.getAddress());
            if (RemoteJmxProtocol.instance(protocol) == RemoteJmxProtocol.RMIJRMP) {
                JMXConnectorServer server2 = dr.startJconsoleConnectorServer();
                JmxConnectorServerDriver.debug("testStartRMI: created RMI connector @ " + server2.getAddress());
            }
            JMXConnector conn = server.toJMXConnector(null);
            conn.connect();
            MBeanServerConnection mbsc = conn.getMBeanServerConnection();
            JmxConnectorServerDriver.debug("testStartRMI: connected client over RMI connector @ " + server.getAddress());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JmxConnectorServerDriver() {
        this.port = JmxConnectorServerDriver.getFreePort();
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public void setProtocol(RemoteJmxProtocol protocol) {
        this.protocol = protocol;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setRmiServerSocketFactory(RMIServerSocketFactory f) {
        if (this.ssl && f == null) {
            throw new IllegalArgumentException("Internal: null server socket factory passed with ssl ON");
        }
        this.rmissf = f;
    }

    public void setRmiClientSocketFactory(RMIClientSocketFactory f) {
        if (this.ssl && f == null) {
            throw new IllegalArgumentException("Internal: null client socket factory passed with ssl ON");
        }
        this.rmicsf = f;
    }

    public void setAuthentication(boolean auth) {
        this.auth = auth;
    }

    public void setLogger(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Internal: null logger");
        }
        this.logger = logger;
    }

    public void setAuthenticator(JMXAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setRmiRegistrySecureFlag(boolean secure) {
        this.secureRegistry = secure;
    }

    public void setMBeanServer(MBeanServer mbs) {
        if (mbs == null) {
            throw new IllegalArgumentException("null mbs");
        }
        this.mbs = mbs;
    }

    public JMXConnectorServer startConnectorServer() throws IOException {
        this.prepare();
        this.formJmxServiceUrl();
        this.createEnvironment();
        JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(this.url, this.env, this.mbs);
        cs.start();
        this.logger.info("Started JMXConnectorServer @ " + this.url);
        return cs;
    }

    public JMXConnectorServer startJconsoleConnectorServer() throws IOException {
        SslRMIClientSocketFactory cf = new SslRMIClientSocketFactory();
        HashMap<String, SslRMIClientSocketFactory> jconsoleenv = new HashMap<String, SslRMIClientSocketFactory>(this.env);
        if (this.ssl) {
            jconsoleenv.put("jmx.remote.rmi.client.socket.factory", cf);
        }
        JMXConnectorServer jconsolecs = JMXConnectorServerFactory.newJMXConnectorServer(this.jconsoleurl, jconsoleenv, this.mbs);
        jconsolecs.start();
        this.logger.info("Started JMXConnectorServer @ " + this.jconsoleurl);
        return jconsolecs;
    }

    public void stopConnectorServer(JMXConnectorServer cs) throws IOException {
        String cad = cs.getAddress().toString();
        if (cs.isActive()) {
            this.logger.log(Level.FINE, "rjmx.lc.stopping", cad);
            cs.stop();
        } else {
            String msg = "JMX Connector Server: " + cad + " is not active";
            this.logger.fine(msg);
        }
    }

    private void formJmxServiceUrl() {
        if (this.protocol == RemoteJmxProtocol.RMIJRMP) {
            this.url = JmxServiceUrlFactory.forRmiWithJndiInAppserver(JmxServiceUrlFactory.localhost(), this.port);
            this.jconsoleurl = JmxServiceUrlFactory.forJconsoleOverRmiWithJndiInAppserver(JmxServiceUrlFactory.localhost(), this.port);
        } else if (this.protocol == RemoteJmxProtocol.JMXMP) {
            this.url = JmxServiceUrlFactory.forJmxmp(this.port);
        }
    }

    private void prepare() {
        if (this.protocol.equals(RemoteJmxProtocol.RMIJRMP)) {
            new RmiStubRegistryHandler(this.port, this.secureRegistry, this.logger);
        }
    }

    private void createEnvironment() {
        this.env.clear();
        this.handleSsl();
        this.handleAuth();
    }

    private void handleSsl() {
        if (this.protocol == RemoteJmxProtocol.RMIJRMP) {
            this.env.put("jmx.remote.rmi.server.socket.factory", this.rmissf);
        }
        if (this.ssl) {
            this.env.put("jmx.remote.rmi.client.socket.factory", this.rmicsf);
        }
    }

    private void handleAuth() {
        if ((this.protocol == RemoteJmxProtocol.RMIJRMP || this.protocol == RemoteJmxProtocol.RMIIIOP) && this.auth) {
            if (this.authenticator == null) {
                String msg = "Internal: The authentication is on, but the authenticator is null";
                throw new IllegalArgumentException("msg");
            }
            this.env.put("jmx.remote.authenticator", this.authenticator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFreePort() {
        int freePort = 0;
        boolean portFound = false;
        ServerSocket serverSocket = null;
        Class<JmxConnectorServerDriver> clazz = JmxConnectorServerDriver.class;
        synchronized (JmxConnectorServerDriver.class) {
            try {
                serverSocket = new ServerSocket(0);
                freePort = serverSocket.getLocalPort();
                portFound = true;
            }
            catch (Exception e) {
            }
            finally {
                if (!portFound) {
                    freePort = 0;
                }
                try {
                    if (serverSocket != null) {
                        serverSocket.close();
                        if (!serverSocket.isClosed()) {
                            throw new Exception("local exception ...");
                        }
                    }
                }
                catch (Exception e) {
                    freePort = 0;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return freePort;
        }
    }
}

