/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.logging.LogDomains;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Async;
import org.glassfish.api.Startup;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoDeploymentException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
@Async
public class AutoDeployService
implements Startup,
PostConstruct,
PreDestroy {
    @Inject
    DasConfig activeDasConfig;
    @Inject
    Habitat habitat;
    private AutoDeployer autoDeployer;
    private Timer autoDeployerTimer;
    private TimerTask autoDeployerTimerTask;
    private String target;
    private static final String DAS_TARGET = "server";
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    private static final String DEFAULT_POLLING_INTERVAL_IN_SECONDS = "2";
    private static final String DEFAULT_AUTO_DEPLOY_ENABLED = "true";

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void postConstruct() {
        this.target = this.getTarget();
        try {
            this.autoDeployer = new AutoDeployer(this.target, this.activeDasConfig.getAutodeployDir(), this.getDefaultVirtualServer(), Boolean.parseBoolean(this.activeDasConfig.getAutodeployJspPrecompilationEnabled()), Boolean.parseBoolean(this.activeDasConfig.getAutodeployVerifierEnabled()), true, true, true, this.habitat);
            this.autoDeployerTimer = new Timer("AutoDeployer", true);
            this.autoDeployerTimerTask = new TimerTask(){

                public void run() {
                    try {
                        AutoDeployService.this.autoDeployer.run();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            };
            if (this.isAutoDeployEnabled()) {
                this.startAutoDeployer();
            }
            logger.fine("[AutoDeployer] Service start-up complete");
        }
        catch (AutoDeploymentException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public void preDestroy() {
        this.stopAutoDeployer();
    }

    static String getValue(String value, String defaultValue) {
        return value == null || value.equals("") ? defaultValue : value;
    }

    private String getTarget() {
        return DAS_TARGET;
    }

    private String getDefaultVirtualServer() {
        return null;
    }

    private boolean isAutoDeployEnabled() {
        return Boolean.parseBoolean(AutoDeployService.getValue(this.activeDasConfig.getAutodeployEnabled(), DEFAULT_AUTO_DEPLOY_ENABLED));
    }

    private long getPollingIntervalInSeconds() {
        return Integer.parseInt(AutoDeployService.getValue(this.activeDasConfig.getAutodeployPollingIntervalInSeconds(), DEFAULT_POLLING_INTERVAL_IN_SECONDS));
    }

    private void startAutoDeployer() {
        long pollingInterval = this.getPollingIntervalInSeconds() * 1000L;
        this.autoDeployerTimer.schedule(this.autoDeployerTimerTask, pollingInterval, pollingInterval);
        logger.fine("[AutoDeployer] Started, monitoring " + this.activeDasConfig.getAutodeployDir() + " every " + this.getPollingIntervalInSeconds());
    }

    private void stopAutoDeployer() {
        logger.fine("[AutoDeployer] Stopping");
        this.autoDeployer.cancel(true);
        this.autoDeployerTimerTask.cancel();
        this.autoDeployerTimer.cancel();
    }

    private void rescheduleAutoDeployer() {
        logger.fine("[AutoDeployer] Restarting...");
        this.stopAutoDeployer();
        try {
            this.autoDeployer.waitUntilIdle();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startAutoDeployer();
    }
}

