/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.deployment.autodeploy.AutoDeployedFilesManager;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoOperation;
import org.glassfish.deployment.autodeploy.AutodeployRetryManager;
import org.glassfish.deployment.common.DeploymentProperties;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class AutoUndeploymentOperation
extends AutoOperation {
    private String name;
    private static final String COMMAND_NAME = "undeploy";
    @Inject
    private AutodeployRetryManager retryManager;
    @Inject(name="undeploy")
    private AdminCommand undeployCommand;

    static AutoUndeploymentOperation newInstance(Habitat habitat, File appFile, String name, String target) {
        AutoUndeploymentOperation o = habitat.getComponent(AutoUndeploymentOperation.class);
        o.init(appFile, name, target);
        return o;
    }

    protected AutoUndeploymentOperation init(File appFile, String name, String target) {
        super.init(appFile, AutoUndeploymentOperation.prepareUndeployActionProperties(name, target), COMMAND_NAME, this.undeployCommand);
        this.name = name;
        return this;
    }

    private static Properties prepareUndeployActionProperties(String name, String target) {
        DeploymentProperties dProps = new DeploymentProperties();
        dProps.setName(name);
        return dProps;
    }

    protected String getMessageString(AutoDeployer.AutodeploymentStatus ds, File file) {
        return localStrings.getLocalString(ds.undeploymentMessageKey, ds.undeploymentDefaultMessage, file);
    }

    protected void markFiles(AutoDeployer.AutodeploymentStatus ds, File file) {
        if (this.undeployedByRequestFile(file)) {
            this.cleanupAppAndRequest(file);
        }
        if (ds.status) {
            this.markUndeployed(file);
            this.retryManager.recordSuccessfulUndeployment(file);
        } else {
            this.markUndeployFailed(file);
            this.retryManager.recordFailedUndeployment(file);
        }
    }

    private void markUndeployed(File f) {
        try {
            this.deleteAllMarks(f);
            this.getUndeployedFile(f).createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void markUndeployFailed(File f) {
        try {
            this.deleteAllMarks(f);
            this.getUndeployFailedFile(f).createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean undeployedByRequestFile(File f) {
        return f instanceof AutoDeployedFilesManager.UndeployRequestedFile;
    }

    private void cleanupAppAndRequest(File f) {
        boolean logFine = sLogger.isLoggable(Level.FINE);
        if (f.isDirectory()) {
            if (logFine) {
                sLogger.fine("Deleting autodeployed directory " + f.getAbsolutePath() + " by request");
            }
            FileUtils.liquidate(f);
        } else {
            if (logFine) {
                sLogger.fine("Deleting autodeployed file " + f.getAbsolutePath() + " by request");
            }
            FileUtils.deleteFile(f);
        }
        File requestFile = AutoDeployedFilesManager.appToUndeployRequestFile(f);
        if (logFine) {
            sLogger.fine("Deleting autodeploy request file " + requestFile.getAbsolutePath());
        }
        FileUtils.deleteFile(requestFile);
    }
}

