/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.datatree.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.glassfish.flashlight.datatree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeNode
implements TreeNode {
    protected Map<String, TreeNode> children = new ConcurrentHashMap<String, TreeNode>();
    protected String name;
    protected Object instance;
    protected String category;
    protected boolean enabled = false;
    private static String NAME_SEPARATOR = ".";
    private static String REGEX = NAME_SEPARATOR.equals(".") ? "\\." : NAME_SEPARATOR;
    private TreeNode parent = null;
    private String STAR = "*";

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new RuntimeException("Flashlight-utils: Tree Node needs a non-null name");
        }
        this.name = name;
    }

    @Override
    public Object getValue() {
        if (this.enabled) {
            return this.getChildNodes();
        }
        return null;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            throw new RuntimeException("Flashlight-utils: Tree Node needs a non-null value");
        }
        this.instance = value;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public TreeNode addChild(TreeNode newChild) {
        if (newChild == null) {
            return null;
        }
        if (newChild.getName() == null) {
            return null;
        }
        newChild.setParent(this);
        return this.children.put(newChild.getName(), newChild);
    }

    @Override
    public String getCompletePathName() {
        if (this.getParent() != null) {
            return this.getParent().getCompletePathName() + NAME_SEPARATOR + this.getName();
        }
        return this.getName();
    }

    @Override
    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public Collection<TreeNode> getChildNodes() {
        return this.children.values();
    }

    public Enumeration<TreeNode> getChildNodesImmutable() {
        return ((ConcurrentHashMap)this.children).elements();
    }

    @Override
    public boolean hasChildNodes() {
        return !this.children.isEmpty();
    }

    public void removeChild(TreeNode oldChild) {
        String child = oldChild.getName();
        if (child != null) {
            this.children.remove(child);
        }
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    public TreeNode getChild(String childName) {
        if (childName == null) {
            return null;
        }
        return this.children.get(childName);
    }

    @Override
    public TreeNode getNode(String completeName) {
        if (completeName == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(REGEX);
        String[] tokens = pattern.split(completeName);
        TreeNode n = this.findNodeInTree(tokens);
        return n;
    }

    private TreeNode findNodeInTree(String[] tokens) {
        if (tokens == null) {
            return null;
        }
        TreeNode child = this.getChild(tokens[0]);
        if (child == null) {
            return null;
        }
        if (tokens.length > 1) {
            child = ((AbstractTreeNode)child).findNodeInTree(this.dropFirstStringToken(tokens));
        }
        return child;
    }

    private String[] dropFirstStringToken(String[] token) {
        if (token.length == 0) {
            return null;
        }
        if (token.length == 1) {
            return null;
        }
        String[] newToken = new String[token.length - 1];
        for (int i = 0; i < newToken.length; ++i) {
            newToken[i] = token[i + 1];
        }
        return newToken;
    }

    @Override
    public List<TreeNode> traverse() {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        list.add(this);
        if (!this.hasChildNodes()) {
            return list;
        }
        Collection<TreeNode> childList = this.children.values();
        for (TreeNode node : childList) {
            list.addAll(node.traverse());
        }
        return list;
    }

    @Override
    public List<TreeNode> getNodes(String regex) {
        ArrayList<TreeNode> regexMatchedTree = new ArrayList<TreeNode>();
        try {
            if (regex.equals(this.STAR)) {
                regex = new String(".*");
            }
            Pattern pattern = Pattern.compile(regex);
            List<TreeNode> completeTree = this.traverse();
            for (TreeNode node : completeTree) {
                Matcher matcher = pattern.matcher(node.getCompletePathName());
                if (!matcher.matches()) continue;
                regexMatchedTree.add(node);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return regexMatchedTree;
    }
}

