/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.statistics.impl;

import org.glassfish.flashlight.datatree.impl.AbstractTreeNode;
import org.glassfish.flashlight.statistics.TimeStats;

public abstract class TimeStatsAbstractImpl
extends AbstractTreeNode
implements TimeStats {
    protected long entryTime = 0L;
    protected long exitTime = 0L;
    private long totalTime = 0L;
    private long lastSampleTime = 0L;
    protected long startTime = 0L;
    long time = 0L;
    long low = -1L;
    long high = -1L;
    long sum = 0L;
    int count = 0;
    protected static final String NEWLINE = System.getProperty("line.separator");

    public long getTime() {
        return this.time;
    }

    public abstract void entry();

    public abstract void exit();

    protected void postEntry() {
        if (this.startTime == 0L) {
            this.startTime = this.entryTime;
        }
        this.setLastSampleTime(this.entryTime);
    }

    public void postExit() {
        this.time = this.exitTime - this.entryTime;
        this.totalTime += this.time;
        this.setLowAndHigh(this.time);
        ++this.count;
    }

    private void setLowAndHigh(long time) {
        if (this.low == -1L && this.high == -1L) {
            this.low = this.high = time;
        }
        if (time < this.low) {
            this.low = time;
        }
        if (time > this.high) {
            this.high = time;
        }
    }

    public long getMinimumTime() {
        return this.low;
    }

    public long getMaximumTime() {
        return this.high;
    }

    public void setTime(long time) {
        this.time = time;
        this.setLowAndHigh(time);
    }

    public void setReset(boolean reset) {
        this.entryTime = 0L;
        this.time = 0L;
        this.low = 0L;
        this.high = 0L;
        this.count = 0;
    }

    public long getTimesCalled() {
        return this.count;
    }

    public long getCount() {
        return this.getTimesCalled();
    }

    public long getMaxTime() {
        return this.getMaximumTime();
    }

    public long getMinTime() {
        return this.getMinimumTime();
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public long getLastSampleTime() {
        return this.lastSampleTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    private void setLastSampleTime(long time) {
        this.lastSampleTime = time;
    }
}

