/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.deployment;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericSniffer
implements Sniffer {
    @Inject
    protected ModulesRegistry modulesRegistry;
    private final String containerName;
    private final String appStigma;
    private final String urlPattern;

    public GenericSniffer(String containerName, String appStigma, String urlPattern) {
        this.containerName = containerName;
        this.appStigma = appStigma;
        this.urlPattern = urlPattern;
    }

    @Override
    public boolean handles(ReadableArchive location, ClassLoader loader) {
        if (this.appStigma != null) {
            try {
                if (location.exists(this.appStigma)) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public Pattern getURLPattern() {
        if (this.urlPattern != null) {
            return Pattern.compile(this.urlPattern);
        }
        return null;
    }

    @Override
    public String getModuleType() {
        return this.containerName;
    }

    @Override
    public Module[] setup(String containerHome, Logger logger) throws IOException {
        return null;
    }

    @Override
    public void tearDown() {
    }

    @Override
    public Class<? extends Annotation>[] getAnnotationTypes() {
        return new Class[0];
    }

    @Override
    public boolean isUserVisible() {
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof Sniffer) {
            Sniffer otherSniffer = (Sniffer)other;
            return this.getModuleType().equals(otherSniffer.getModuleType());
        }
        return false;
    }
}

