/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationFactory;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.DescriptorArchivist;
import com.sun.enterprise.deployment.backend.ClientJarMakerThread;
import com.sun.enterprise.deployment.deploy.shared.DeploymentPlanArchive;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ModuleInfo;
import org.jvnet.hk2.annotations.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaEEDeployer<T extends Container, U extends ApplicationContainer>
implements Deployer<T, U> {
    @Inject
    protected ServerEnvironment env;
    @Inject
    protected ArchiveFactory archiveFactory;
    @Inject
    protected ArchivistFactory archivistFactory;
    @Inject
    protected ApplicationFactory applicationFactory;
    @Inject
    protected DescriptorArchivist descriptorArchivist;
    @Inject
    protected ApplicationArchivist applicationArchivist;
    @Inject
    protected ModulesRegistry modulesRegistry;
    @Inject
    protected ApplicationRegistry appRegistry;
    @Inject(name="application_deploy", optional=true)
    protected ApplicationVisitor deploymentVisitor = null;
    @Inject(name="application_undeploy", optional=true)
    protected ApplicationVisitor undeploymentVisitor = null;
    private static String CLIENT_JAR_MAKER_CHOICE = System.getProperty("client.jar.maker.choice");
    private static final String APPLICATION_TYPE = "Application-Type";
    private static String WRITEOUT_XML = System.getProperty("writeout.xml");

    @Override
    public MetaData getMetaData() {
        ArrayList<ModuleDefinition> apis = new ArrayList<ModuleDefinition>();
        Module module = this.modulesRegistry.makeModuleFor("org.glassfish.javax.javaee", null);
        if (module != null) {
            apis.add(module.getModuleDefinition());
        }
        return new MetaData(false, apis.toArray(new ModuleDefinition[apis.size()]), null, null);
    }

    protected String getCommonClassPath() {
        StringBuffer sb = new StringBuffer();
        File libDir = this.env.getLibPath();
        String libDirPath = libDir.getAbsolutePath();
        sb.append(libDirPath + File.separator + "classes");
        sb.append(File.pathSeparator);
        String[] files = libDir.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".jar") && !files[i].endsWith(".zip")) continue;
                sb.append(libDirPath + File.separator + files[i]);
                sb.append(File.pathSeparator);
            }
        }
        return sb.toString();
    }

    @Override
    public <V> V loadMetaData(Class<V> type, DeploymentContext dc) {
        try {
            return (V)this.parseModuleMetaData(dc);
        }
        catch (Exception e) {
            dc.getLogger().log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public boolean prepare(DeploymentContext dc) {
        try {
            this.validateApplication(dc);
            this.prepareScratchDirs(dc);
            String objectType = this.getObjectType(dc);
            if (objectType != null) {
                dc.getProps().setProperty("object-type", objectType);
            }
            this.generateArtifacts(dc);
            if (Boolean.valueOf(WRITEOUT_XML).booleanValue()) {
                this.saveAppDescriptor(dc);
            }
            this.createClientJar(dc);
            return true;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected void validateApplication(DeploymentContext dc) {
        Application app = dc.getModuleMetaData(Application.class);
        if (app != null && !app.isValidated()) {
            app.setClassLoader(dc.getClassLoader());
            app.visit(new ApplicationValidator());
        }
    }

    protected Application parseModuleMetaData(DeploymentContext dc) throws Exception {
        ReadableArchive sourceArchive = dc.getSource();
        ClassLoader cl = dc.getClassLoader();
        Properties props = dc.getCommandParameters();
        String name = props.getProperty("name");
        Archivist archivist = this.archivistFactory.getArchivist(sourceArchive, cl);
        archivist.setAnnotationProcessingRequested(true);
        archivist.setXMLValidation(false);
        archivist.setRuntimeXMLValidation(false);
        archivist.setDefaultBundleDescriptor(this.getDefaultBundleDescriptor());
        if (dc.getModuleMetaData(Application.class) == null) {
            String deploymentPlan = props.getProperty("deploymentplan");
            this.handleDeploymentPlan(deploymentPlan, archivist, sourceArchive);
        }
        Application application = this.applicationFactory.openArchive(name, archivist, sourceArchive, true);
        if (this.deploymentVisitor != null) {
            this.deploymentVisitor.accept(application);
        }
        return application;
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    protected void createClientJar(DeploymentContext dc) throws DeploymentException {
    }

    protected final void createClientJar(DeploymentContext dc, ZipItem[] clientStubs) throws DeploymentException {
        Properties props = dc.getCommandParameters();
        String name = props.getProperty("name");
        String clientJarRequested = props.getProperty("clientJarRequested");
        File appDirectory = dc.getScratchDir("xml");
        if (!FileUtils.safeIsDirectory(dc.getScratchDir("xml"))) {
            appDirectory = dc.getSourceDir();
        }
        File clientJar = new File(appDirectory, name + "Client.jar");
        if (clientJarRequested != null && Boolean.valueOf(clientJarRequested).booleanValue()) {
            ClientJarMakerThread.createClientJar(dc, clientJar, clientStubs, CLIENT_JAR_MAKER_CHOICE);
        } else {
            ClientJarMakerThread clientJarThread = new ClientJarMakerThread(dc, clientJar, clientStubs, CLIENT_JAR_MAKER_CHOICE);
            clientJarThread.start();
        }
    }

    @Override
    public void clean(DeploymentContext context) {
        String appName = context.getCommandParameters().getProperty("name");
        Application app = this.getApplicationFromApplicationInfo(appName);
        if (app != null) {
            context.addModuleMetaData(app);
            if (this.undeploymentVisitor != null) {
                this.undeploymentVisitor.accept(app);
            }
        }
    }

    protected void saveAppDescriptor(DeploymentContext context) throws IOException {
        Application application = context.getModuleMetaData(Application.class);
        ReadableArchive archive = this.archiveFactory.openArchive(context.getSourceDir());
        WritableArchive archive2 = this.archiveFactory.createArchive(context.getScratchDir("xml"));
        this.descriptorArchivist.write(application, archive, archive2);
        this.applicationArchivist.copyExtraElements(archive, archive2);
    }

    protected void prepareScratchDirs(DeploymentContext context) throws IOException {
        context.getScratchDir("ejb").mkdirs();
        context.getScratchDir("xml").mkdirs();
        context.getScratchDir("jsp").mkdirs();
    }

    protected String getObjectType(DeploymentContext context) {
        try {
            Manifest manifest = context.getSource().getManifest();
            if (manifest == null) {
                return null;
            }
            Attributes attrs = manifest.getMainAttributes();
            return attrs.getValue(APPLICATION_TYPE);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected Application getApplicationFromApplicationInfo(String appName) {
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo == null) {
            return null;
        }
        for (ModuleInfo moduleInfo : appInfo.getModuleInfos()) {
            ApplicationContainer appCtr = moduleInfo.getApplicationContainer();
            Object descriptor = appCtr.getDescriptor();
            if (!(descriptor instanceof BundleDescriptor)) continue;
            return ((BundleDescriptor)descriptor).getApplication();
        }
        return null;
    }

    protected void handleDeploymentPlan(String deploymentPlan, Archivist archivist, ReadableArchive sourceArchive) throws IOException {
        if (deploymentPlan != null) {
            DeploymentPlanArchive dpa = new DeploymentPlanArchive();
            dpa.open(new File(deploymentPlan).toURI());
            WritableArchive targetArchive = this.archiveFactory.createArchive(sourceArchive.getURI());
            archivist.copyInto((ReadableArchive)dpa, targetArchive, false);
        }
    }

    protected abstract RootDeploymentDescriptor getDefaultBundleDescriptor();

    protected abstract String getModuleType();
}

