/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.glassfish.persistence.jpa.ProviderContainerContractInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private static final String DEFAULT_PROVIDER_NAME = "org.eclipse.persistence.jpa.PersistenceProvider";
    private static final String DEFAULT_DS_NAME = "jdbc/__default";
    private static String defaultProvider;
    private static Logger logger;
    private static final StringManager localStrings;
    private PersistenceUnitDescriptor persistenceUnitDescriptor;
    private ProviderContainerContractInfo providerContainerContractInfo;
    private File absolutePuRootFile;
    private DataSource jtaDataSource;
    private DataSource nonJtaDataSource;
    private List<URL> jarFiles;

    public PersistenceUnitInfoImpl(PersistenceUnitDescriptor persistenceUnitDescriptor, ProviderContainerContractInfo providerContainerContractInfo) {
        this.persistenceUnitDescriptor = persistenceUnitDescriptor;
        this.providerContainerContractInfo = providerContainerContractInfo;
        this.jarFiles = this._getJarFiles();
        String jtaDataSourceName = this._calculateJtaDataSourceName();
        String nonJtaDataSourceName = this._calculateNonJtaDataSourceName();
        try {
            this.jtaDataSource = jtaDataSourceName == null ? null : providerContainerContractInfo.lookupDataSource(jtaDataSourceName);
            this.nonJtaDataSource = this.nonJtaDataSource == null ? null : providerContainerContractInfo.lookupNonTxDataSource(nonJtaDataSourceName);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getPersistenceUnitName() {
        return this.persistenceUnitDescriptor.getName();
    }

    @Override
    public String getPersistenceProviderClassName() {
        return PersistenceUnitInfoImpl.getPersistenceProviderClassNameForPuDesc(this.persistenceUnitDescriptor);
    }

    @Override
    public PersistenceUnitTransactionType getTransactionType() {
        return PersistenceUnitTransactionType.valueOf(this.persistenceUnitDescriptor.getTransactionType());
    }

    @Override
    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    @Override
    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    @Override
    public URL getPersistenceUnitRootUrl() {
        try {
            return this.getAbsolutePuRootFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getMappingFileNames() {
        return this.persistenceUnitDescriptor.getMappingFiles();
    }

    @Override
    public List<URL> getJarFileUrls() {
        return this.jarFiles;
    }

    @Override
    public List<String> getManagedClassNames() {
        return this.persistenceUnitDescriptor.getClasses();
    }

    @Override
    public boolean excludeUnlistedClasses() {
        return this.persistenceUnitDescriptor.isExcludeUnlistedClasses();
    }

    @Override
    public Properties getProperties() {
        return this.persistenceUnitDescriptor.getProperties();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.providerContainerContractInfo.getClassLoader();
    }

    @Override
    public void addTransformer(ClassTransformer transformer) {
        this.providerContainerContractInfo.addTransformer(transformer);
    }

    @Override
    public ClassLoader getNewTempClassLoader() {
        return this.providerContainerContractInfo.getTempClassloader();
    }

    public String toString() {
        StringBuilder result = new StringBuilder("<persistence-unit>");
        result.append("\n\t<PURoot>").append(this.getPersistenceUnitRootUrl()).append("</PURoot>");
        result.append("\n\t<name>").append(this.getPersistenceUnitName()).append("</name>");
        result.append("\n\t<provider>").append(this.getPersistenceProviderClassName()).append("</provider>");
        result.append("\n\t<transaction-type>").append((Object)this.getTransactionType()).append("</transaction-type>");
        result.append("\n\t<jta-data-source>").append(this.getJtaDataSource()).append("</jta-data-source>");
        result.append("\n\t<non-jta-data-source>").append(this.getNonJtaDataSource()).append("</non-jta-data-source>");
        for (URL jar : this.getJarFileUrls()) {
            result.append("\n\t<jar-file>").append(jar).append("</jar-file>");
        }
        for (String mappingFile : this.getMappingFileNames()) {
            result.append("\n\t<mapping-file>").append(mappingFile).append("</mapping-file>");
        }
        for (String clsName : this.getManagedClassNames()) {
            result.append("\n\t<class-name>").append(clsName).append("</class-name>");
        }
        result.append("\n\t<exclude-unlisted-classes>").append(this.excludeUnlistedClasses()).append("</exclude-unlisted-classes>");
        result.append("\n\t<properties>").append(this.getProperties()).append("</properties>");
        result.append("\n\t<class-loader>").append(this.getClassLoader()).append("</class-loader>");
        result.append("\n</persistence-unit>\n");
        return result.toString();
    }

    protected String _calculateJtaDataSourceName() {
        String DSName;
        if (this.getTransactionType() != PersistenceUnitTransactionType.JTA) {
            logger.logp(Level.FINE, "PersistenceUnitInfoImpl", "_getJtaDataSource", "This PU is configured as non-jta, so jta-data-source is null");
            return null;
        }
        String userSuppliedJTADSName = this.persistenceUnitDescriptor.getJtaDataSource();
        if (!PersistenceUnitInfoImpl.isNullOrEmpty(userSuppliedJTADSName)) {
            DSName = userSuppliedJTADSName;
        } else if (PersistenceUnitInfoImpl.isNullOrEmpty(this.persistenceUnitDescriptor.getNonJtaDataSource())) {
            DSName = DEFAULT_DS_NAME;
        } else {
            String msg = localStrings.getString("puinfo.jta-ds-not-configured", new Object[]{this.persistenceUnitDescriptor.getName()});
            throw new RuntimeException(msg);
        }
        logger.logp(Level.FINE, "PersistenceUnitLoaderImpl", "_getJtaDataSource", "JTADSName = {0}", DSName);
        return DSName;
    }

    protected String _calculateNonJtaDataSourceName() {
        String userSuppliedJTADSName;
        String userSuppliedNonJTADSName = this.persistenceUnitDescriptor.getNonJtaDataSource();
        String DSName = !PersistenceUnitInfoImpl.isNullOrEmpty(userSuppliedNonJTADSName) ? userSuppliedNonJTADSName : (!PersistenceUnitInfoImpl.isNullOrEmpty(userSuppliedJTADSName = this.persistenceUnitDescriptor.getJtaDataSource()) ? userSuppliedJTADSName : DEFAULT_DS_NAME);
        logger.logp(Level.FINE, "PersistenceUnitInfoImpl", "_getNonJtaDataSource", "nonJTADSName = {0}", DSName);
        return DSName;
    }

    private List<URL> _getJarFiles() {
        ArrayList<String> jarFileNames = new ArrayList<String>(this.persistenceUnitDescriptor.getJarFiles());
        ArrayList<URL> jarFiles = new ArrayList<URL>(jarFileNames.size() + 1);
        String absolutePuRoot = this.getAbsolutePuRootFile().getAbsolutePath();
        for (String jarFileName : jarFileNames) {
            String nativeJarFileName = jarFileName.replace('/', File.separatorChar);
            File parentFile = new File(absolutePuRoot).getParentFile();
            File jarFile = new File(parentFile, nativeJarFileName);
            if (!jarFile.exists()) {
                String pathComponent = "";
                String nameComponent = jarFileName;
                if (jarFileName.lastIndexOf("../") != -1) {
                    int separatorIndex = jarFileName.lastIndexOf("../") + 3;
                    pathComponent = jarFileName.substring(0, separatorIndex);
                    nameComponent = jarFileName.substring(separatorIndex);
                }
                logger.fine("For jar-file=" + jarFileName + ", " + "pathComponent=" + pathComponent + ", nameComponent=" + nameComponent);
                File parentPath = new File(parentFile, pathComponent);
            }
            if (jarFile.exists()) {
                try {
                    jarFiles.add(jarFile.toURI().toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            String msg = localStrings.getString("puinfo.referenced_jar_not_found", new Object[]{absolutePuRoot, jarFileName, jarFile});
            logger.log(Level.WARNING, msg);
        }
        return jarFiles;
    }

    private File getAbsolutePuRootFile() {
        if (this.absolutePuRootFile == null) {
            this.absolutePuRootFile = new File(this.providerContainerContractInfo.getApplicationLocation(), this.getAbsolutePuRoot().replace('/', File.separatorChar));
            if (!this.absolutePuRootFile.exists()) {
                throw new RuntimeException(this.absolutePuRootFile.getAbsolutePath() + " does not exist!");
            }
        }
        return this.absolutePuRootFile;
    }

    private String getAbsolutePuRoot() {
        RootDeploymentDescriptor rootDD = this.persistenceUnitDescriptor.getParent().getParent();
        String puRoot = this.persistenceUnitDescriptor.getPuRoot();
        if (rootDD.isApplication()) {
            return puRoot;
        }
        ModuleDescriptor module = ((BundleDescriptor)BundleDescriptor.class.cast(rootDD)).getModuleDescriptor();
        if (module.isStandalone()) {
            return puRoot;
        }
        return null;
    }

    private static String getDefaultprovider() {
        String DEFAULT_PERSISTENCE_PROVIDER_PROPERTY = "com.sun.persistence.defaultProvider";
        if (defaultProvider == null) {
            defaultProvider = System.getProperty("com.sun.persistence.defaultProvider", DEFAULT_PROVIDER_NAME);
        }
        return defaultProvider;
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String getPersistenceProviderClassNameForPuDesc(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        String provider = persistenceUnitDescriptor.getProvider();
        if (PersistenceUnitInfoImpl.isNullOrEmpty(provider)) {
            provider = PersistenceUnitInfoImpl.getDefaultprovider();
        }
        return provider;
    }

    static {
        logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
        localStrings = StringManager.getManager(PersistenceUnitInfoImpl.class);
    }
}

