/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-virtual-server")
@Scoped(value=PerLookup.class)
@I18n(value="create.virtual.server")
public class CreateVirtualServer
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateVirtualServer.class);
    @Param(name="hosts")
    String hosts;
    @Param(name="httplisteners", optional=true)
    String httpListeners;
    @Param(name="defaultwebmodule", optional=true)
    String defaultWebModule;
    @Param(name="state", acceptableValues="on, off", optional=true)
    String state;
    @Param(name="logfile", optional=true)
    String logFile;
    @Param(name="property", optional=true)
    Properties properties;
    @Param(name="virtual_server_id", primary=true)
    String virtualServerId;
    @Inject
    Configs configs;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List<Config> configList = this.configs.getConfig();
        Config config = configList.get(0);
        HttpService httpService = config.getHttpService();
        for (VirtualServer virtualServer : httpService.getVirtualServer()) {
            if (!virtualServer.getId().equals(this.virtualServerId)) continue;
            report.setMessage(localStrings.getLocalString("create.virtual.server.duplicate", "Virtual Server named {0} already exists.", this.virtualServerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<HttpService>(){

                @Override
                public Object run(HttpService param) throws PropertyVetoException, TransactionFailure {
                    boolean docrootAdded = false;
                    VirtualServer newVirtualServer = ConfigSupport.createChildOf(param, VirtualServer.class);
                    newVirtualServer.setId(CreateVirtualServer.this.virtualServerId);
                    newVirtualServer.setHosts(CreateVirtualServer.this.hosts);
                    newVirtualServer.setHttpListeners(CreateVirtualServer.this.httpListeners);
                    newVirtualServer.setDefaultWebModule(CreateVirtualServer.this.defaultWebModule);
                    newVirtualServer.setState(CreateVirtualServer.this.state);
                    newVirtualServer.setLogFile(CreateVirtualServer.this.logFile);
                    if (CreateVirtualServer.this.properties != null) {
                        for (Map.Entry<Object, Object> entry : CreateVirtualServer.this.properties.entrySet()) {
                            Property property = ConfigSupport.createChildOf(newVirtualServer, Property.class);
                            String pn = (String)entry.getKey();
                            property.setName(pn);
                            property.setValue((String)entry.getValue());
                            newVirtualServer.getProperty().add(property);
                            if (!"docroot".equals(pn)) continue;
                            docrootAdded = true;
                        }
                    }
                    if (!docrootAdded) {
                        Property drp = ConfigSupport.createChildOf(newVirtualServer, Property.class);
                        drp.setName("docroot");
                        drp.setValue("${com.sun.aas.instanceRoot}/docroot");
                        newVirtualServer.getProperty().add(drp);
                    }
                    param.getVirtualServer().add(newVirtualServer);
                    return newVirtualServer;
                }
            }, httpService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.virutal.server.fail", "{0} create failed ", this.virtualServerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

