/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.jsp;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.runtime.web.ClassLoader;
import com.sun.enterprise.deployment.runtime.web.JspConfig;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.jasper.JspC;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.web.loader.util.ASClassLoaderUtil;

public final class JSPCompiler {
    private ServerContext serverContext;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JSPCompiler.class);
    private static final String startMessage = localStrings.getLocalString("org.glassfish.web.start_jspc", "Beginning JSP Precompile...");
    private static final String finishMessage = localStrings.getLocalString("org.glassfish.web.finish_jspc", "Finished JSP Precompile");
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");

    public static void compile(File inWebDir, File outWebDir, WebBundleDescriptor wbd, ServerContext serverContext) throws DeploymentException {
        String amb = null;
        JSPCompiler.compile(inWebDir, outWebDir, wbd, amb, serverContext);
    }

    public static void compile(File inWebDir, File outWebDir, WebBundleDescriptor wbd, List classpathList, ServerContext serverContext) throws DeploymentException {
        String classpath = null;
        if (classpathList != null) {
            classpath = JSPCompiler.getClasspath(classpathList);
        }
        JSPCompiler.compile(inWebDir, outWebDir, wbd, classpath, serverContext);
    }

    public static void compile(File inWebDir, File outWebDir, WebBundleDescriptor wbd, String classpath, ServerContext serverContext) throws DeploymentException {
        JspC jspc = new JspC();
        if (classpath != null && classpath.length() > 0) {
            jspc.setClassPath(classpath);
        }
        String appName = wbd.getApplication().getName();
        boolean delegate = true;
        ClassLoader clBean = wbd.getSunDescriptor().getClassLoader();
        if (clBean != null) {
            String value = clBean.getAttributeValue("Delegate");
            delegate = ConfigBeansUtilities.toBoolean(value);
        }
        String sysClassPath = ASClassLoaderUtil.getWebModuleClassPath(serverContext.getDefaultHabitat(), appName, delegate);
        jspc.setSystemClassPath(sysClassPath);
        JSPCompiler.verify(inWebDir, outWebDir);
        JSPCompiler.configureJspc(jspc, wbd);
        jspc.setOutputDir(outWebDir.getAbsolutePath());
        jspc.setUriroot(inWebDir.getAbsolutePath());
        jspc.setCompile(true);
        logger.info(startMessage);
        try {
            jspc.execute();
        }
        catch (Exception je) {
            throw new DeploymentException("JSP Compilation Error: " + je, je);
        }
        finally {
            String[] files = outWebDir.list();
            if (files == null || files.length <= 0) {
                outWebDir.delete();
            }
            logger.info(finishMessage);
        }
    }

    private static void verify(File inWebDir, File outWebDir) throws DeploymentException {
        if (!FileUtils.safeIsDirectory(inWebDir)) {
            throw new DeploymentException("inWebDir is not a directory: " + inWebDir);
        }
        if (!FileUtils.safeIsDirectory(outWebDir)) {
            outWebDir.mkdirs();
            if (!FileUtils.safeIsDirectory(outWebDir)) {
                throw new DeploymentException("outWebDir is not a directory, and it can't be created: " + outWebDir);
            }
        }
    }

    private static String getClasspath(List paths) {
        if (paths == null) {
            return null;
        }
        String classpath = null;
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String path : paths) {
            if (first) {
                first = false;
            } else {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(path);
        }
        if (sb.length() > 0) {
            classpath = sb.toString();
        }
        return classpath;
    }

    private static void configureJspc(JspC jspc, WebBundleDescriptor wbd) {
        JspConfig jspConfig;
        Set<WebComponentDescriptor> set;
        SunWebApp sunWebApp = wbd.getSunDescriptor();
        if (sunWebApp == null) {
            return;
        }
        if (sunWebApp.sizeWebProperty() > 0) {
            WebProperty[] props = sunWebApp.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String pName = props[i].getAttributeValue("name");
                String pValue = props[i].getAttributeValue("value");
                if (pName == null || pValue == null) {
                    throw new IllegalArgumentException("Missing sun-web-app property name or value");
                }
                if (!"enableTldValidation".equals(pName)) continue;
                jspc.setIsValidationEnabled(Boolean.valueOf(pValue));
            }
        }
        if (!(set = wbd.getWebComponentDescriptors()).isEmpty()) {
            for (WebComponentDescriptor webComponentDesc : set) {
                if (!"jsp".equals(webComponentDesc.getCanonicalName())) continue;
                Enumeration<InitializationParameter> en = webComponentDesc.getInitializationParameters();
                if (en == null) break;
                while (en.hasMoreElements()) {
                    InitializationParameter initP = en.nextElement();
                    JSPCompiler.configureJspc(jspc, initP.getName(), initP.getValue());
                }
                break block1;
            }
        }
        if ((jspConfig = sunWebApp.getJspConfig()) == null) {
            return;
        }
        WebProperty[] props = jspConfig.getWebProperty();
        for (int i = 0; props != null && i < props.length; ++i) {
            JSPCompiler.configureJspc(jspc, props[i].getAttributeValue("name"), props[i].getAttributeValue("value"));
        }
    }

    private static void configureJspc(JspC jspc, String pName, String pValue) {
        if (pName == null || pValue == null) {
            throw new IllegalArgumentException("Null property name or value");
        }
        if ("xpoweredBy".equals(pName)) {
            jspc.setXpoweredBy(Boolean.valueOf(pValue));
        } else if ("classdebuginfo".equals(pName)) {
            jspc.setClassDebugInfo(Boolean.valueOf(pValue));
        } else if ("enablePooling".equals(pName)) {
            jspc.setPoolingEnabled(Boolean.valueOf(pValue));
        } else if ("ieClassId".equals(pName)) {
            jspc.setIeClassId(pValue);
        } else if ("trimSpaces".equals(pName)) {
            jspc.setTrimSpaces(Boolean.valueOf(pValue));
        } else if ("genStrAsCharArray".equals(pName)) {
            jspc.setGenStringAsCharArray(Boolean.valueOf(pValue));
        } else if ("errorOnUseBeanInvalidClassAttribute".equals(pName)) {
            jspc.setErrorOnUseBeanInvalidClassAttribute(Boolean.valueOf(pValue));
        } else if ("ignoreJspFragmentErrors".equals(pName)) {
            jspc.setIgnoreJspFragmentErrors(Boolean.valueOf(pValue));
        }
    }
}

