/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import org.jvnet.hk2.config.DataType;
import org.jvnet.hk2.config.ValidationException;
import org.jvnet.hk2.config.WriteableView;

public final class PrimitiveDataType
extends DataType {
    private final String realType;

    PrimitiveDataType(String realType) {
        assert (WriteableView.PRIMS.contains(realType)) : "This class can't validate: " + realType;
        this.realType = realType;
    }

    public void validate(String value) throws ValidationException {
        if (value.startsWith("${") && value.endsWith("}")) {
            return;
        }
        boolean match = false;
        if ("int".equals(this.realType) || "java.lang.Integer".equals(this.realType)) {
            match = PrimitiveDataType.representsInteger(value);
        } else if ("boolean".equals(this.realType) || "java.lang.Boolean".endsWith(this.realType)) {
            match = PrimitiveDataType.representsBoolean(value);
        } else if ("char".equals(this.realType) || "java.lang.Character".equals(this.realType)) {
            PrimitiveDataType.representsChar(value);
        }
        if (!match) {
            String msg = "This value: " + value + " is not of type: " + this.realType + ", validation failed";
            throw new ValidationException(msg);
        }
    }

    private static boolean representsBoolean(String value) {
        boolean isBoolean = "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
        return isBoolean;
    }

    private static boolean representsChar(String value) {
        return value.length() == 1;
    }

    private static boolean representsInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException ne) {
            return false;
        }
    }
}

