/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanInterceptor;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.DataType;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.PrimitiveDataType;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.Transactor;
import org.jvnet.hk2.config.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteableView
implements InvocationHandler,
Transactor,
ConfigView {
    private final ConfigBean bean;
    private final ConfigBeanProxy defaultView;
    private final Map<String, PropertyChangeEvent> changedAttributes;
    private final Map<String, ProtectedList> changedCollections;
    Transaction currentTx;
    Map<String, DataType> validators = new HashMap<String, DataType>();
    static final List<String> PRIMS = Collections.unmodifiableList(Arrays.asList("boolean", "char", "int", "java.lang.Boolean", "java.lang.Character", "java.lang.Integer"));

    public WriteableView(ConfigBeanProxy readView) {
        this.bean = (ConfigBean)((ConfigView)Proxy.getInvocationHandler(readView)).getMasterView();
        this.defaultView = this.bean.createProxy();
        this.changedAttributes = new HashMap<String, PropertyChangeEvent>();
        this.changedCollections = new HashMap<String, ProtectedList>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ConfigModel.Property property = this.bean.toProperty(method);
        if (property == null) {
            throw new IllegalArgumentException("No corresponding property found for method: " + method);
        }
        if (args == null || args.length == 0) {
            if (this.changedAttributes.containsKey(property.xmlName())) {
                return this.changedAttributes.get(property.xmlName()).getNewValue();
            }
            return this.getter(property, method.getGenericReturnType());
        }
        this.setter(property, args[0], method.getGenericParameterTypes()[0]);
        return null;
    }

    public Object getter(ConfigModel.Property property, Type t) {
        Object value = this.bean._getter(property, t);
        if (value instanceof List) {
            if (!this.changedCollections.containsKey(property.xmlName())) {
                this.changedCollections.put(property.xmlName(), new ProtectedList((List)value, this.defaultView, property.xmlName()));
            }
            return this.changedCollections.get(property.xmlName());
        }
        return value;
    }

    public void setter(ConfigModel.Property property, Object newValue, Type t) {
        if (this.currentTx == null) {
            throw new IllegalStateException("Not part of a transation");
        }
        try {
            this.handleValidation(property, newValue);
        }
        catch (Exception v) {
            this.bean.getLock().unlock();
            throw new RuntimeException(v);
        }
        Object oldValue = this.bean.getter(property, t);
        if (newValue instanceof ConfigBeanProxy) {
            ConfigView bean = (ConfigView)Proxy.getInvocationHandler((ConfigBeanProxy)newValue);
            newValue = bean.getMasterView();
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.defaultView, property.xmlName(), oldValue, newValue);
        this.changedAttributes.put(property.xmlName(), evt);
    }

    public ConfigModel.Property getProperty(String xmlName) {
        return this.bean.model.findIgnoreCase(xmlName);
    }

    @Override
    public synchronized boolean join(Transaction t) {
        if (this.currentTx == null) {
            this.currentTx = t;
            t.addParticipant(this);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean canCommit(Transaction t) {
        return this.currentTx == t;
    }

    @Override
    public synchronized List<PropertyChangeEvent> commit(Transaction t) throws TransactionFailure {
        if (this.currentTx == t) {
            this.currentTx = null;
        }
        try {
            ArrayList<PropertyChangeEvent> appliedChanges = new ArrayList<PropertyChangeEvent>();
            for (PropertyChangeEvent event : this.changedAttributes.values()) {
                ConfigModel.Property property = this.bean.model.findIgnoreCase(event.getPropertyName());
                ConfigBeanInterceptor interceptor = this.bean.getOptionalFeature(ConfigBeanInterceptor.class);
                try {
                    if (interceptor != null) {
                        interceptor.beforeChange(event);
                    }
                }
                catch (PropertyVetoException e) {
                    throw new TransactionFailure(e.getMessage(), e);
                }
                property.set(this.bean, event.getNewValue());
                if (interceptor != null) {
                    interceptor.afterChange(event, System.currentTimeMillis());
                }
                appliedChanges.add(event);
            }
            for (ProtectedList entry : this.changedCollections.values()) {
                List originalList = entry.readOnly;
                for (PropertyChangeEvent event : entry.changeEvents) {
                    if (event.getOldValue() == null) {
                        originalList.add(event.getNewValue());
                    } else {
                        int index;
                        Object toBeRemoved;
                        Object toBeRemovedObj = event.getOldValue();
                        if (toBeRemovedObj instanceof ConfigBeanProxy) {
                            toBeRemoved = Dom.unwrap((ConfigBeanProxy)toBeRemovedObj);
                            for (index = 0; index < originalList.size(); ++index) {
                                Object element = originalList.get(index);
                                Dom dom = Dom.unwrap((ConfigBeanProxy)element);
                                if (dom != toBeRemoved) continue;
                                originalList.remove(index);
                            }
                        } else if (toBeRemovedObj instanceof String) {
                            toBeRemoved = (String)toBeRemovedObj;
                            for (index = 0; index < originalList.size(); ++index) {
                                String item = (String)originalList.get(index);
                                if (!item.equals(toBeRemoved)) continue;
                                originalList.remove(index);
                            }
                        } else {
                            throw new IllegalArgumentException();
                        }
                    }
                    appliedChanges.add(event);
                }
            }
            this.changedAttributes.clear();
            ArrayList<PropertyChangeEvent> arrayList = appliedChanges;
            return arrayList;
        }
        catch (TransactionFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransactionFailure(e.getMessage(), e);
        }
        finally {
            this.bean.getLock().unlock();
        }
    }

    @Override
    public synchronized void abort(Transaction t) {
        this.currentTx = null;
        this.bean.getLock().unlock();
        this.changedAttributes.clear();
    }

    public <T extends ConfigBeanProxy> T allocateProxy(Class<T> type) throws TransactionFailure {
        if (this.currentTx == null) {
            throw new TransactionFailure("Not part of a transaction", null);
        }
        ConfigBean newBean = this.bean.allocate(type);
        WriteableView writeableView = ConfigSupport.getWriteableView(newBean.getProxy(type), newBean);
        writeableView.join(this.currentTx);
        return writeableView.getProxy(type);
    }

    @Override
    public ConfigBean getMasterView() {
        return this.bean;
    }

    @Override
    public void setMasterView(ConfigView view) {
    }

    @Override
    public <T extends ConfigBeanProxy> Class<T> getProxyType() {
        return this.bean.getProxyType();
    }

    @Override
    public <T extends ConfigBeanProxy> T getProxy(Class<T> type) {
        ConfigBean sourceBean = this.getMasterView();
        if (!type.getName().equals(sourceBean.model.targetTypeName)) {
            throw new IllegalArgumentException("This config bean interface is " + sourceBean.model.targetTypeName + " not " + type.getName());
        }
        Class[] interfacesClasses = new Class[]{type};
        return (T)((ConfigBeanProxy)Proxy.newProxyInstance(type.getClassLoader(), interfacesClasses, (InvocationHandler)this));
    }

    private void handleValidation(ConfigModel.Property property, Object value) throws ValidationException {
        if (property instanceof ConfigModel.AttributeLeaf) {
            ConfigModel.AttributeLeaf al = (ConfigModel.AttributeLeaf)property;
            DataType validator = this.getValidatorFor(al.dataType);
            if (validator != null) {
                validator.validate(value.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataType getValidatorFor(String dataType) {
        Map<String, DataType> map = this.validators;
        synchronized (map) {
            DataType validator = this.validators.get(dataType);
            if (validator != null) {
                return validator;
            }
            if (PRIMS.contains(dataType)) {
                this.validators.put(dataType, new PrimitiveDataType(dataType));
            } else {
                try {
                    Class<?> c = Class.forName(dataType);
                    DataType d = (DataType)c.newInstance();
                    this.validators.put(dataType, d);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return this.validators.get(dataType);
        }
    }

    private class ProtectedList
    extends AbstractList {
        final ConfigBeanProxy readView;
        final List readOnly;
        final String id;
        final List<PropertyChangeEvent> changeEvents = new ArrayList<PropertyChangeEvent>();
        final List proxied;

        ProtectedList(List readOnly, ConfigBeanProxy parent, String id) {
            this.proxied = Collections.synchronizedList(new ArrayList(readOnly));
            this.readView = parent;
            this.readOnly = readOnly;
            this.id = id;
        }

        public int size() {
            return this.proxied.size();
        }

        public Object get(int index) {
            return this.proxied.get(index);
        }

        public synchronized boolean add(Object object) {
            Object param = object;
            try {
                InvocationHandler handler = Proxy.getInvocationHandler(object);
                if (handler instanceof WriteableView) {
                    ConfigBean master = ((WriteableView)handler).getMasterView();
                    param = ((WriteableView)handler).getMasterView().createProxy(master.type());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.changeEvents.add(new PropertyChangeEvent(WriteableView.this.defaultView, this.id, null, param));
            return this.proxied.add(object);
        }

        public synchronized void clear() {
            ArrayList allItems = new ArrayList(this.proxied);
            for (Object item : allItems) {
                this.remove(item);
            }
        }

        public synchronized boolean retainAll(Collection keepers) {
            ArrayList toRemoveList = new ArrayList();
            for (Object iffy : this.proxied) {
                if (keepers.contains(iffy)) continue;
                toRemoveList.add(iffy);
            }
            boolean changed = this.removeAll((Collection)toRemoveList);
            return changed;
        }

        public synchronized boolean removeAll(Collection goners) {
            boolean listChanged = false;
            for (Object goner : goners) {
                if (!this.remove(goner)) continue;
                listChanged = true;
            }
            return listChanged;
        }

        public synchronized boolean remove(Object object) {
            this.changeEvents.add(new PropertyChangeEvent(WriteableView.this.defaultView, this.id, object, null));
            try {
                ConfigView handler = ((ConfigView)Proxy.getInvocationHandler(object)).getMasterView();
                for (int index = 0; index < this.proxied.size(); ++index) {
                    Object target = this.proxied.get(index);
                    try {
                        ConfigView targetHandler = ((ConfigView)Proxy.getInvocationHandler(target)).getMasterView();
                        if (targetHandler != handler) continue;
                        return this.proxied.remove(index) != null;
                    }
                    catch (IllegalArgumentException ex) {
                        // empty catch block
                    }
                }
            }
            catch (IllegalArgumentException e) {
                return this.proxied.remove(object);
            }
            return false;
        }
    }
}

