/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleChangeListener;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.common_impl.AbstractModulesRegistryImpl;
import com.sun.enterprise.module.common_impl.CompositeEnumeration;
import com.sun.hk2.component.InhabitantsParser;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiModuleImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiModulesRegistryImpl
extends AbstractModulesRegistryImpl {
    BundleContext bctx;
    private PackageAdmin pa;
    private Map<ModuleChangeListener, BundleListener> moduleChangeListeners = new HashMap<ModuleChangeListener, BundleListener>();
    private Map<ModuleLifecycleListener, BundleListener> moduleLifecycleListeners = new HashMap<ModuleLifecycleListener, BundleListener>();

    OSGiModulesRegistryImpl(BundleContext bctx) {
        super(null);
        this.bctx = bctx;
        for (Bundle b : bctx.getBundles()) {
            DummyModuleDefinition md;
            if (b.getLocation().equals("System Bundle")) continue;
            try {
                md = new DummyModuleDefinition(b);
            }
            catch (URISyntaxException e) {
                Logger.logger.logp(Level.WARNING, "OSGiModulesRegistryImpl", "OSGiModulesRegistryImpl", "Not able convert bundle [{0}] having location [{1}] to module because of exception: {2}", new Object[]{b, b.getLocation(), e});
                continue;
            }
            OSGiModuleImpl m = new OSGiModuleImpl(this, b, md);
            this.modules.put(md.getName(), m);
        }
        ServiceReference ref = bctx.getServiceReference(PackageAdmin.class.getName());
        this.pa = (PackageAdmin)PackageAdmin.class.cast(bctx.getService(ref));
    }

    @Override
    protected Module newModule(ModuleDefinition moduleDef) {
        String location = moduleDef.getLocations()[0].toString();
        try {
            File l;
            if (Logger.logger.isLoggable(Level.FINE)) {
                Logger.logger.logp(Level.FINE, "OSGiModulesRegistryImpl", "add", "location = {0}", location);
            }
            if ((l = new File(moduleDef.getLocations()[0])).isDirectory()) {
                location = "reference:" + location;
            }
            Bundle bundle = this.bctx.installBundle(location);
            return new OSGiModuleImpl(this, bundle, moduleDef);
        }
        catch (BundleException e) {
            Logger.logger.logp(Level.WARNING, "OSGiModulesRegistryImpl", "add", "Exception {0} while adding location = {1}", new Object[]{e, location});
            return null;
        }
    }

    @Override
    public void parseInhabitants(Module module, String name, InhabitantsParser inhabitantsParser) throws IOException {
        ((OSGiModuleImpl)OSGiModuleImpl.class.cast(module)).parseInhabitants(name, inhabitantsParser);
    }

    @Override
    public ModulesRegistry createChild() {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    @Override
    public synchronized void detachAll() {
        for (Module m : this.modules.values()) {
            m.detach();
        }
    }

    @Override
    public synchronized void shutdown() {
        for (Module m : this.modules.values()) {
            ((OSGiModuleImpl)OSGiModuleImpl.class.cast(m)).uninstall();
        }
        this.modules.clear();
        for (Repository repo : this.repositories.values()) {
            try {
                repo.shutdown();
            }
            catch (Exception e) {
                java.util.logging.Logger.getAnonymousLogger().log(Level.SEVERE, "Error while closing repository " + repo, e);
            }
        }
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        throw new UnsupportedOperationException("This method can't be implemented in OSGi environment");
    }

    @Override
    public ClassLoader getParentClassLoader() {
        return Bundle.class.getClassLoader();
    }

    @Override
    public ClassLoader getModulesClassLoader(final ClassLoader parent, Collection<ModuleDefinition> mds, URL[] urls) throws ResolveError {
        final ArrayList<ClassLoader> delegateCLs = new ArrayList<ClassLoader>();
        final ArrayList<Module> delegateModules = new ArrayList<Module>();
        for (ModuleDefinition md : mds) {
            Module m = this.makeModuleFor(md.getName(), md.getVersion());
            delegateModules.add(m);
            delegateCLs.add(m.getClassLoader());
        }
        return new URLClassLoader(urls != null ? urls : new URL[]{}, parent){

            @Override
            public URL[] getURLs() {
                ArrayList<URL> result = new ArrayList<URL>();
                if (parent instanceof URLClassLoader) {
                    URL[] parentURLs = ((URLClassLoader)URLClassLoader.class.cast(parent)).getURLs();
                    result.addAll(Arrays.asList(parentURLs));
                }
                for (Module m : delegateModules) {
                    ModuleDefinition md = m.getModuleDefinition();
                    URI[] uris = md.getLocations();
                    URL[] urls = new URL[uris.length];
                    for (int i = 0; i < uris.length; ++i) {
                        try {
                            urls[i] = uris[i].toURL();
                            continue;
                        }
                        catch (MalformedURLException e) {
                            Logger.logger.warning("Exception " + e + " while converting " + uris[i] + " to URL");
                        }
                    }
                    result.addAll(Arrays.asList(urls));
                }
                return result.toArray(new URL[0]);
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                for (ClassLoader delegate : delegateCLs) {
                    try {
                        return delegate.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                }
                throw new ClassNotFoundException(name);
            }

            @Override
            public URL findResource(String name) {
                URL resource = null;
                for (ClassLoader delegate : delegateCLs) {
                    resource = delegate.getResource(name);
                    if (resource == null) continue;
                    return resource;
                }
                return resource;
            }

            @Override
            public Enumeration<URL> findResources(String name) throws IOException {
                ArrayList<Enumeration<URL>> enumerators = new ArrayList<Enumeration<URL>>();
                for (ClassLoader delegate : delegateCLs) {
                    Enumeration<URL> enumerator = delegate.getResources(name);
                    enumerators.add(enumerator);
                }
                return new CompositeEnumeration(enumerators);
            }
        };
    }

    @Override
    public ClassLoader getModulesClassLoader(ClassLoader parent, Collection<ModuleDefinition> defs) throws ResolveError {
        return this.getModulesClassLoader(parent, defs, null);
    }

    @Override
    public Module find(Class clazz) {
        Bundle b = this.pa.getBundle(clazz);
        if (b != null) {
            return (Module)this.modules.get(b.getSymbolicName());
        }
        return null;
    }

    public PackageAdmin getPackageAdmin() {
        return this.pa;
    }

    public void addModuleChangeListener(final ModuleChangeListener listener, final OSGiModuleImpl module) {
        SynchronousBundleListener bundleListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() == module.getBundle() && (event.getType() & 8) == 8) {
                    listener.changed(module);
                }
            }
        };
        this.bctx.addBundleListener((BundleListener)bundleListener);
        this.moduleChangeListeners.put(listener, (BundleListener)bundleListener);
    }

    public boolean removeModuleChangeListener(ModuleChangeListener listener) {
        BundleListener bundleListener = this.moduleChangeListeners.remove(listener);
        if (bundleListener != null) {
            this.bctx.removeBundleListener(bundleListener);
            return true;
        }
        return false;
    }

    @Override
    public void register(final ModuleLifecycleListener listener) {
        SynchronousBundleListener bundleListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if ((event.getType() & 2) == 2) {
                    listener.moduleStarted(OSGiModulesRegistryImpl.this.getModule(event.getBundle()));
                }
            }
        };
        this.bctx.addBundleListener((BundleListener)bundleListener);
        this.moduleLifecycleListeners.put(listener, (BundleListener)bundleListener);
    }

    @Override
    public void unregister(ModuleLifecycleListener listener) {
        BundleListener bundleListener = this.moduleLifecycleListeners.remove(listener);
        if (bundleListener != null) {
            this.bctx.removeBundleListener(bundleListener);
        }
    }

    Map<String, Module> getExistingModules() {
        return Collections.unmodifiableMap(this.modules);
    }

    Module getModule(Bundle bundle) {
        return (Module)this.modules.get(bundle.getHeaders().get("HK2-Bundle-Name"));
    }

    private static class DummyModuleDefinition
    implements ModuleDefinition {
        private final Bundle b;
        private URI location;

        public DummyModuleDefinition(Bundle b) throws URISyntaxException {
            this.b = b;
            this.location = new URI(b.getLocation());
        }

        public String getName() {
            return this.b.getSymbolicName();
        }

        public String[] getPublicInterfaces() {
            return new String[0];
        }

        public ModuleDependency[] getDependencies() {
            return new ModuleDependency[0];
        }

        public URI[] getLocations() {
            return new URI[]{this.location};
        }

        public String getVersion() {
            return (String)String.class.cast(this.b.getHeaders().get("Bundle-Version"));
        }

        public String getImportPolicyClassName() {
            return null;
        }

        public String getLifecyclePolicyClassName() {
            return null;
        }

        public Manifest getManifest() {
            return null;
        }

        public ModuleMetadata getMetadata() {
            return new ModuleMetadata();
        }
    }
}

