/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.AbstractCommand;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.cli.framework.CLIDescriptorsReader;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ValidCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

public class ListCommandsCommand
extends AbstractCommand {
    String[] remoteCommands;
    String[] localCommands;
    String port;
    String host;
    String user;
    String passwordFile;
    boolean localOnly;
    boolean remoteOnly;
    private static final LocalStringsImpl strings = new LocalStringsImpl(ListCommandsCommand.class);
    private static final CLILogger logger = CLILogger.getInstance();
    private static final String SPACES = "                                                            ";
    private static final String EOL = System.getProperty("line.separator");

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        if (!this.remoteOnly) {
            this.getLocalCommands();
            this.printLocalCommands();
        }
        if (!this.localOnly) {
            this.getRemoteCommands();
            this.printRemoteCommands();
        }
        logger.printMessage("");
    }

    public boolean validateOptions() throws CommandValidationException {
        super.validateOptions();
        this.port = this.getOption("port");
        this.host = this.getOption("host");
        this.user = this.getOption("user");
        this.passwordFile = this.getOption("passwordfile");
        this.localOnly = this.getBooleanOption("localonly");
        this.remoteOnly = this.getBooleanOption("remoteonly");
        if (this.localOnly && this.remoteOnly) {
            throw new CommandValidationException(strings.get("listCommands.notBoth"));
        }
        return true;
    }

    String[] getLocalCommands() throws CommandValidationException {
        CLIDescriptorsReader r = CLIDescriptorsReader.getInstance();
        Iterator it = r.getCommandsList().getCommands();
        ArrayList<String> names = new ArrayList<String>();
        while (it.hasNext()) {
            names.add(((ValidCommand)it.next()).getName());
        }
        this.localCommands = names.toArray(new String[names.size()]);
        Arrays.sort(this.localCommands);
        return this.localCommands;
    }

    String[] getRemoteCommands() throws CommandException {
        try {
            CLILogger.getInstance().pushAndLockLevel(Level.WARNING);
            CLIRemoteCommand rc = new CLIRemoteCommand(this.getRemoteArgs());
            rc.runCommand();
            Map<String, String> mainAtts = rc.getMainAtts();
            String cmds = mainAtts.get("children");
            this.remoteCommands = cmds.split(";");
            String[] stringArray = this.remoteCommands;
            return stringArray;
        }
        catch (Exception e) {
            throw new CommandException(strings.get("listCommands.errorRemote", e.getMessage()));
        }
        finally {
            CLILogger.getInstance().popAndUnlockLevel();
        }
    }

    private String[] getRemoteArgs() {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add("list-commands");
        if (ListCommandsCommand.ok(this.port)) {
            list.add("--port");
            list.add(this.port);
        }
        if (ListCommandsCommand.ok(this.host)) {
            list.add("--host");
            list.add(this.host);
        }
        if (ListCommandsCommand.ok(this.user)) {
            list.add("--user");
            list.add(this.user);
        }
        if (ListCommandsCommand.ok(this.passwordFile)) {
            list.add("--passwordfile");
            list.add(this.passwordFile);
        }
        return list.toArray(new String[list.size()]);
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0 && !s.equals("null");
    }

    void printLocalCommands() {
        logger.printMessage("********** Local Commands **********");
        for (String s : this.localCommands) {
            logger.printMessage(s);
        }
    }

    void printRemoteCommands() {
        logger.printMessage("********** Remote Commands **********");
        int num = this.remoteCommands.length;
        int offset = num / 2 + num % 2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < offset; ++i) {
            sb.append(this.remoteCommands[i]);
            sb.append(this.justify(this.remoteCommands[i], 40));
            if (i + offset < num) {
                sb.append(this.remoteCommands[i + offset]);
            }
            if (i >= offset - 1) continue;
            sb.append(EOL);
        }
        logger.printMessage(sb.toString());
    }

    private String justify(String s, int width) {
        int numSpaces = width - s.length();
        return SPACES.substring(0, numSpaces);
    }
}

