/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.appserv.management.client.prefs.StoreException;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommandParser;
import com.sun.enterprise.admin.cli.remote.Log;
import com.sun.enterprise.admin.cli.remote.RemoteException;
import com.sun.enterprise.admin.cli.remote.RemoteResponseManager;
import com.sun.enterprise.admin.cli.remote.RemoteSuccessException;
import com.sun.enterprise.admin.cli.util.AuthenticationInfo;
import com.sun.enterprise.admin.cli.util.CLIUtil;
import com.sun.enterprise.admin.cli.util.HttpConnectorAddress;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.universal.BASE64Encoder;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.FileUtils;
import com.sun.enterprise.universal.io.SmartFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLIRemoteCommand {
    private boolean verbose = false;
    private boolean terse = false;
    private boolean echo = false;
    private Map<String, String> mainAtts;
    private LoginInfoStore store;
    private Map<String, String> params;
    private List<String> operands;
    private String commandName;
    private String responseFormatType = "hk2-cli";
    private OutputStream userOut;
    private boolean doUpload = false;
    private File fileParameter;
    private File deploymentPlanParameter;
    private Map<String, String> encodedPasswords;
    private String hostName;
    private int hostPort;
    private boolean secure;
    private String user;
    private String password;
    private static final LocalStringsImpl strings = new LocalStringsImpl(CLIRemoteCommand.class);
    private static final CLILogger logger = CLILogger.getInstance();
    private static final String SUCCESS = "SUCCESS";
    private static final String FAILURE = "FAILURE";
    private static final String MAGIC = "PlainTextActionReporter";
    private static final String[] LOCAL_PARAMS = new String[]{"host", "port", "upload", "user", "passwordfile", "secure", "terse", "echo", "interactive"};
    private static final String QUERY_STRING_INTRODUCER = "?";
    private static final String QUERY_STRING_SEPARATOR = "&";
    private static final String ADMIN_URI_PATH = "/__asadmin/";

    public CLIRemoteCommand(String ... args) throws CommandException {
        this.initialize(args);
    }

    public CLIRemoteCommand(String[] args, String responseFormatType, OutputStream userOut) throws CommandException {
        this.initialize(args);
        this.responseFormatType = responseFormatType;
        this.userOut = userOut;
    }

    public void runCommand() throws CommandException {
        try {
            String msg;
            StringBuilder uriString = new StringBuilder(ADMIN_URI_PATH + this.commandName);
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                String paramName = entry.getKey();
                if (this.isLocalParam(paramName)) continue;
                try {
                    String paramValue = entry.getValue();
                    this.addOption(uriString, paramName + "=" + URLEncoder.encode(paramValue, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    logger.printError("Error encoding " + paramName + ", parameter value will be ignored");
                }
            }
            this.addFileOption(uriString, "path", this.doUpload, this.fileParameter);
            this.addFileOption(uriString, "deploymentplan", this.doUpload, this.deploymentPlanParameter);
            if (this.encodedPasswords != null) {
                for (Map.Entry entry : this.encodedPasswords.entrySet()) {
                    this.addOption(uriString, (String)entry.getKey() + "=" + (String)entry.getValue());
                }
            }
            for (String string : this.operands) {
                this.addOption(uriString, "DEFAULT=" + URLEncoder.encode(string, "UTF-8"));
            }
            HttpURLConnection urlConnection = null;
            try {
                HttpConnectorAddress httpConnectorAddress = new HttpConnectorAddress(this.hostName, this.hostPort, this.secure);
                logger.printDebugMessage("URI: " + uriString.toString());
                logger.printDebugMessage("URL: " + httpConnectorAddress.toString());
                logger.printDebugMessage("URL: " + httpConnectorAddress.toURL(uriString.toString()).toString());
                httpConnectorAddress.setAuthenticationInfo(new AuthenticationInfo(this.user, this.password));
                urlConnection = (HttpURLConnection)httpConnectorAddress.openConnection(uriString.toString());
                urlConnection.setRequestProperty("User-Agent", this.responseFormatType);
                urlConnection.setRequestProperty("Authorization", httpConnectorAddress.getBasicAuthString());
                urlConnection.setRequestMethod(this.chooseRequestMethod());
                urlConnection.connect();
                if (this.doUpload) {
                    this.upload(urlConnection);
                }
                InputStream in = urlConnection.getInputStream();
                this.handleResponse(this.params, in, urlConnection.getResponseCode(), this.userOut);
            }
            catch (ConnectException connectException) {
                msg = strings.get("ConnectException", this.hostName, this.hostPort);
                throw new CommandException(msg, connectException);
            }
            catch (IOException iOException) {
                int rc;
                msg = null;
                msg = urlConnection != null ? (401 == (rc = urlConnection.getResponseCode()) ? strings.get("InvalidCredentials", this.user) : "Status: " + rc) : "Unknown Error";
                throw new CommandException(msg, iOException);
            }
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            logger.printExceptionStackTrace(e);
            throw new CommandException(e);
        }
    }

    private StringBuilder addOption(StringBuilder uriString, String option) {
        String nextChar = uriString.indexOf(QUERY_STRING_INTRODUCER) == -1 ? QUERY_STRING_INTRODUCER : QUERY_STRING_SEPARATOR;
        uriString.append(nextChar).append(option);
        return uriString;
    }

    private StringBuilder addFileOption(StringBuilder uriString, String optionName, boolean isUpload, File parameter) throws UnsupportedEncodingException {
        if (parameter != null) {
            String pathToPass = isUpload ? parameter.getName() : parameter.getPath();
            this.addOption(uriString, optionName + "=" + URLEncoder.encode(pathToPass, "UTF-8"));
        }
        return uriString;
    }

    private String chooseRequestMethod() {
        if (this.doUpload) {
            return "POST";
        }
        return "GET";
    }

    private void upload(HttpURLConnection conn) throws CommandException, IOException {
        ZipOutputStream zos = new ZipOutputStream(conn.getOutputStream());
        if (this.fileParameter != null) {
            this.upload(zos, this.fileParameter);
        }
        if (this.deploymentPlanParameter != null) {
            this.upload(zos, this.deploymentPlanParameter);
        }
        zos.flush();
    }

    private void upload(ZipOutputStream out, File uploadFile) throws CommandException {
        ZipEntry entry = new ZipEntry(uploadFile.getName());
        entry.setTime(uploadFile.lastModified());
        try {
            out.putNextEntry(entry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(uploadFile));
            byte[] buffer = new byte[65536];
            int i = bis.read(buffer);
            while (i > 0) {
                out.write(buffer, 0, i);
                i = bis.read(buffer);
            }
            out.closeEntry();
            bis.close();
        }
        catch (IOException ex) {
            throw new CommandException(ex.getMessage());
        }
    }

    private void handleResponse(Map<String, String> params, InputStream in, int code, OutputStream userOut) throws IOException, CommandException {
        if (userOut == null) {
            this.handleResponse(params, in, code);
        } else {
            FileUtils.copyStream(in, userOut);
        }
    }

    private void handleResponse(Map<String, String> params, InputStream in, int code) throws IOException, CommandException {
        RemoteResponseManager rrm = null;
        try {
            rrm = new RemoteResponseManager(in, code);
            rrm.process();
        }
        catch (RemoteSuccessException rse) {
            if (rrm != null) {
                this.mainAtts = rrm.getMainAtts();
            }
            Log.info(rse.getMessage(), new Object[0]);
            return;
        }
        catch (RemoteException rfe) {
            throw new CommandException("remote failure: " + rfe.getMessage());
        }
    }

    private void setBooleans() {
        String value;
        if (this.params.containsKey("verbose")) {
            value = this.params.get("verbose");
            this.verbose = this.ok(value) ? Boolean.parseBoolean(this.params.get("verbose")) : true;
        }
        if (this.params.containsKey("echo")) {
            value = this.params.get("echo");
            this.echo = this.ok(value) ? Boolean.parseBoolean(this.params.get("echo")) : true;
        }
        if (this.params.containsKey("terse")) {
            value = this.params.get("terse");
            this.terse = this.ok(value) ? Boolean.parseBoolean(this.params.get("terse")) : true;
        }
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0 && !s.equals("null");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.commandName).append(' ');
        sb.append("--echo=").append(Boolean.toString(this.echo)).append(' ');
        sb.append("--terse=").append(Boolean.toString(this.terse)).append(' ');
        Set<String> paramKeys = this.params.keySet();
        for (String key : paramKeys) {
            if (key.equals("terse") || key.equals("echo")) continue;
            String value = this.params.get(key);
            sb.append("--").append(key);
            if (this.ok(value)) {
                sb.append('=').append(value);
            }
            sb.append(' ');
        }
        for (String o : this.operands) {
            sb.append((Object)o).append(' ');
        }
        return sb.toString();
    }

    public Map<String, String> getMainAtts() {
        return this.mainAtts;
    }

    public static boolean pingDAS(int port) {
        try {
            CLIRemoteCommand rcmd = new CLIRemoteCommand("version", "--port", Integer.toString(port));
            rcmd.runCommand();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pingDASQuietly(int port) {
        try {
            CLILogger.getInstance().pushAndLockLevel(Level.WARNING);
            boolean bl = CLIRemoteCommand.pingDAS(port);
            return bl;
        }
        finally {
            CLILogger.getInstance().popAndUnlockLevel();
        }
    }

    private void initialize(String[] args) throws CommandException {
        try {
            CLIRemoteCommandParser rcp = new CLIRemoteCommandParser(args);
            this.commandName = rcp.getCommandName();
            this.params = rcp.getOptions();
            this.operands = rcp.getOperands();
            this.initializeStandardParams();
            this.initializeDeploy();
            this.initializeLogger();
            logger.printDebugMessage("CLIRemoteCommandParser: " + rcp);
            this.initializeAuth();
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage());
        }
    }

    private void initializeStandardParams() throws CommandException {
        ASenvPropertyReader pr = new ASenvPropertyReader();
        this.setBooleans();
        this.hostName = this.params.get("host");
        if (!this.ok(this.hostName)) {
            this.hostName = pr.getProps().get("com.sun.aas.hostName");
        }
        if (!this.ok(this.hostName)) {
            this.hostName = "localhost";
        }
        this.initializePort();
        String s = this.params.get("secure");
        this.secure = this.ok(s) ? Boolean.parseBoolean(s) : false;
    }

    private void initializePort() throws CommandException {
        String port = this.params.get("port");
        if (this.ok(port)) {
            try {
                this.hostPort = Integer.parseInt(port);
                if (this.hostPort < 1 || this.hostPort > 65535) {
                    throw new CommandException(strings.get("badport", this.hostPort));
                }
            }
            catch (NumberFormatException e) {
                port = null;
            }
        }
        if (!this.ok(port)) {
            this.hostPort = 8080;
        }
    }

    private void initializeLogger() {
        if (this.terse) {
            logger.setOutputLevel(Level.INFO);
        } else {
            logger.setOutputLevel(Level.FINE);
        }
        if (this.echo) {
            logger.printMessage(this.toString());
        } else if (logger.isDebug()) {
            logger.printDebugMessage(this.toString());
        }
    }

    private void initializeDeploy() throws CommandException {
        String filename;
        if (!this.isDeployment()) {
            return;
        }
        if (this.operands.size() > 0) {
            filename = this.operands.get(0);
            this.operands.clear();
        } else {
            filename = this.params.get("path");
            this.params.remove("path");
        }
        if (!this.ok(filename)) {
            throw new CommandException(strings.get("noDeployFile", this.commandName));
        }
        this.fileParameter = SmartFile.sanitize(new File(filename));
        if (!this.fileParameter.exists()) {
            throw new CommandException(strings.get("badDeployFile", this.commandName, this.fileParameter));
        }
        String deploymentPlan = this.params.get("deploymentplan");
        if (deploymentPlan != null) {
            this.deploymentPlanParameter = SmartFile.sanitize(new File(deploymentPlan));
            if (!this.deploymentPlanParameter.exists()) {
                throw new CommandException(strings.get("badDeploymentPlan", this.commandName, this.deploymentPlanParameter));
            }
        }
        if (!this.isDirDeployment()) {
            String upString = this.params.get("upload");
            this.doUpload = !this.ok(upString) ? true : Boolean.parseBoolean(upString);
        }
    }

    private void initializeAuth() throws CommandException {
        LoginInfo li = null;
        try {
            this.store = LoginInfoStoreFactory.getDefaultStore();
            li = this.store.read(this.hostName, this.hostPort);
        }
        catch (StoreException se) {
            throw new CommandException(se.getMessage());
        }
        this.initializeUser(li);
        this.initializePassword(li);
    }

    private void initializeUser(LoginInfo li) {
        this.user = this.params.get("user");
        if (this.user == null && li != null) {
            this.user = li.getUser();
        }
    }

    private void initializePassword(LoginInfo li) throws CommandException {
        String pwfile = this.params.get("passwordfile");
        if (this.ok(pwfile)) {
            this.encodedPasswords = CLIUtil.readPasswordFileOptions(pwfile, true);
            this.password = this.encodedPasswords.get("AS_ADMIN_PASSWORD");
            CLIRemoteCommand.base64encode(this.encodedPasswords);
        }
        if (!this.ok(this.password) && li != null) {
            this.password = li.getPassword();
        }
    }

    private static void base64encode(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        BASE64Encoder encoder = new BASE64Encoder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String val = entry.getValue();
            if (val == null) continue;
            entry.setValue(encoder.encode(val.getBytes()));
        }
    }

    private boolean isDeployment() {
        return this.commandName.equals("deploy") || this.commandName.equals("redeploy");
    }

    private boolean isDirDeployment() {
        return this.isDeployment() && this.fileParameter != null && this.fileParameter.isDirectory();
    }

    private boolean isLocalParam(String param) {
        return Arrays.asList(LOCAL_PARAMS).contains(param);
    }
}

