/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.universal.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JvmOptions {
    Map<String, String> sysProps = new HashMap<String, String>();
    Map<String, String> xxProps = new HashMap<String, String>();
    Map<String, String> xProps = new HashMap<String, String>();
    Map<String, String> plainProps = new HashMap<String, String>();

    JvmOptions(List<String> options) throws GFLauncherException {
        for (String s : options) {
            if ((s = StringUtils.removeEnclosingQuotes(s)).startsWith("-D")) {
                this.addSysProp(s);
                continue;
            }
            if (s.startsWith("-XX")) {
                this.addXxProp(s);
                continue;
            }
            if (s.startsWith("-X")) {
                this.addXProp(s);
                continue;
            }
            if (s.startsWith("-")) {
                this.addPlainProp(s);
                continue;
            }
            throw new GFLauncherException("UnknownJvmOptionFormat", s);
        }
    }

    public String toString() {
        List<String> ss = this.toStringArray();
        StringBuilder sb = new StringBuilder();
        for (String s : ss) {
            sb.append(s).append('\n');
        }
        return sb.toString();
    }

    List<String> toStringArray() {
        String value;
        ArrayList<String> ss = new ArrayList<String>();
        Set<String> keys = this.xxProps.keySet();
        for (String name : keys) {
            value = this.xxProps.get(name);
            if (value != null) {
                ss.add("-XX" + name + "=" + value);
                continue;
            }
            ss.add("-XX" + name);
        }
        keys = this.xProps.keySet();
        for (String name : keys) {
            value = this.xProps.get(name);
            if (value != null) {
                ss.add("-X" + name + "=" + value);
                continue;
            }
            ss.add("-X" + name);
        }
        keys = this.plainProps.keySet();
        for (String name : keys) {
            value = this.plainProps.get(name);
            if (value != null) {
                ss.add("-" + name + "=" + value);
                continue;
            }
            ss.add("-" + name);
        }
        keys = this.sysProps.keySet();
        for (String name : keys) {
            value = this.sysProps.get(name);
            if (value != null) {
                ss.add("-D" + name + "=" + value);
                continue;
            }
            ss.add("-D" + name);
        }
        this.postProcessOrdering(ss);
        return ss;
    }

    Map<String, String> getCombinedMap() {
        HashMap<String, String> all = new HashMap<String, String>(this.plainProps);
        all.putAll(this.xProps);
        all.putAll(this.xxProps);
        all.putAll(this.sysProps);
        return all;
    }

    private void addPlainProp(String s) {
        s = s.substring(1);
        NameValue nv = new NameValue(s);
        this.plainProps.put(nv.name, nv.value);
    }

    private void addSysProp(String s) {
        s = s.substring(2);
        NameValue nv = new NameValue(s);
        this.sysProps.put(nv.name, nv.value);
    }

    private void addXProp(String s) {
        s = s.substring(2);
        NameValue nv = new NameValue(s);
        this.xProps.put(nv.name, nv.value);
    }

    private void addXxProp(String s) {
        s = s.substring(3);
        NameValue nv = new NameValue(s);
        this.xxProps.put(nv.name, nv.value);
    }

    @Deprecated
    void addJvmLogging() {
        this.xxProps.put(":+UnlockDiagnosticVMOptions", null);
        this.xxProps.put(":+LogVMOutput", null);
        this.xxProps.put(":LogFile", "${com.sun.aas.instanceRoot}/logs/jvm.log");
    }

    @Deprecated
    void removeJvmLogging() {
        this.xxProps.remove(":+UnlockDiagnosticVMOptions");
        this.xxProps.remove(":+LogVMOutput");
        this.xxProps.remove(":LogFile");
    }

    private void postProcessOrdering(List<String> ss) {
        String arg = "-XX:+UnlockDiagnosticVMOptions";
        int index = ss.indexOf(arg);
        if (index > 0) {
            ss.remove(index);
            ss.add(0, arg);
        }
    }

    private static class NameValue {
        private String name;
        private String value;

        NameValue(String s) {
            int index = s.indexOf("=");
            if (index < 0) {
                this.name = s;
            } else {
                this.name = s.substring(0, index);
                if (index + 1 < s.length()) {
                    this.value = s.substring(index + 1);
                }
            }
        }
    }
}

