/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.DeferredResourceConfig;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.server.ResourceDeployerFactory;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.config.ConfigBeanProxy;

public class ConnectorService
implements ConnectorConstants {
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    protected static final ConnectorRegistry _registry = ConnectorRegistry.getInstance();
    private boolean debug = true;
    protected static int environment = 1;
    protected ConnectorRuntime _runtime;
    protected ResourceDeployerFactory factory = new ResourceDeployerFactory();

    public ConnectorService() {
        this._runtime = ConnectorRuntime.getRuntime();
    }

    public static void initialize(int environ) {
        environment = environ;
    }

    public static int getEnviron() {
        return environment;
    }

    public String getDefaultPoolName(String moduleName, String connectionDefName) {
        return moduleName + "#" + connectionDefName;
    }

    public String getDefaultResourceName(String moduleName, String connectionDefName) {
        String resourceJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForResource(moduleName);
        return resourceJNDIName + "#" + connectionDefName;
    }

    public static boolean isServer() {
        return ConnectorService.getEnviron() == 1;
    }

    public boolean checkAndLoadResource(Object resource, Object pool, String resourceType, String resourceName, String raName) throws ConnectorRuntimeException {
        String resname = ConnectorAdminServiceUtils.getOriginalResourceName(resourceName);
        _logger.fine("ConnectorService :: checkAndLoadResource resolved to load " + resname);
        ResourcesUtil resUtil = ResourcesUtil.createInstance();
        DeferredResourceConfig defResConfig = resUtil.getDeferredResourceConfig(resource, pool, resourceType, raName);
        return this.loadResourcesAndItsRar(defResConfig);
    }

    public boolean loadResourcesAndItsRar(DeferredResourceConfig defResConfig) {
        if (defResConfig != null) {
            try {
                this.loadDeferredResources(defResConfig.getResourceAdapterConfig());
                String rarName = defResConfig.getRarName();
                this.loadDeferredResourceAdapter(rarName);
                final ConfigBeanProxy[] resToLoad = defResConfig.getResourcesToLoad();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            ConnectorService.this.loadDeferredResources(resToLoad);
                        }
                        catch (Exception ex) {
                            _logger.log(Level.SEVERE, "failed to load resources/ResourceAdapter");
                            _logger.log(Level.SEVERE, "", ex);
                        }
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "failed to load resources/ResourceAdapter");
                _logger.log(Level.SEVERE, "", ex);
                return false;
            }
            return true;
        }
        return false;
    }

    public void loadDeferredResourceAdapter(String rarName) throws ConnectorRuntimeException {
        try {
            ConnectorRuntime cr = ConnectorRuntime.getRuntime();
            if (ConnectorsUtil.belongsToSystemRA(rarName)) {
                cr.createActiveResourceAdapter(ConnectorsUtil.getSystemModuleLocation(rarName), rarName);
            }
        }
        catch (Exception e) {
            ConnectorRuntimeException ce = new ConnectorRuntimeException(e.getMessage());
            ce.initCause(e);
            throw ce;
        }
    }

    public void loadDeferredResources(ConfigBeanProxy[] resourcesToLoad) throws Exception {
        if (resourcesToLoad == null || resourcesToLoad.length == 0) {
            return;
        }
        String resourceType = null;
        ResourceDeployer deployer = null;
        ResourcesUtil resourceUtil = ResourcesUtil.createInstance();
        for (ConfigBeanProxy resource : resourcesToLoad) {
            if (resource == null || (deployer = this.factory.getResourceDeployer(resourceType = resourceUtil.getResourceType(resource))) == null) continue;
            deployer.deployResource(resource);
        }
    }

    public ConnectorDescriptor getConnectorDescriptor(String rarName) throws ConnectorRuntimeException {
        if (rarName == null) {
            return null;
        }
        ConnectorDescriptor desc = null;
        desc = _registry.getDescriptor(rarName);
        if (desc != null) {
            return desc;
        }
        ResourcesUtil resUtil = ResourcesUtil.createInstance();
        String moduleDir = ConnectorsUtil.belongsToSystemRA(rarName) ? ConnectorsUtil.getSystemModuleLocation(rarName) : ConnectorsUtil.getLocation(rarName);
        if (moduleDir != null) {
            desc = ConnectorDDTransformUtils.getConnectorDescriptor(moduleDir);
        } else {
            _logger.log(Level.SEVERE, "rardeployment.no_module_deployed", rarName);
        }
        return desc;
    }

    public void switchOnMatching(String rarName, String poolName) {
        PoolManager poolMgr;
        boolean result;
        if ((rarName.equals("__ds_jdbc_ra") || rarName.equals("__cp_jdbc_ra") || rarName.equals("__xa_jdbc_ra")) && !(result = (poolMgr = this._runtime.getPoolManager()).switchOnMatching(poolName))) {
            try {
                this.getRuntime().switchOnMatchingInJndi(poolName);
            }
            catch (ConnectorRuntimeException cre) {
                // empty catch block
            }
        }
    }

    protected ConnectorRuntime getRuntime() {
        return ConnectorRuntime.getRuntime();
    }

    private void deleteResource(Object resource) throws ConnectorRuntimeException {
        try {
            this.factory.getResourceDeployer(resource).undeployResource(resource);
        }
        catch (Exception e) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause(e);
            throw cre;
        }
    }

    private void destroyConnectionPools(Collection pools) {
        for (Object pool : pools) {
            try {
                this.deleteResource(pool);
            }
            catch (ConnectorRuntimeException cre) {
                cre.printStackTrace();
            }
        }
    }

    private void destroyResources(Collection resources) {
        for (Object resource : resources) {
            try {
                this.deleteResource(resource);
            }
            catch (ConnectorRuntimeException cre) {
                cre.printStackTrace();
            }
        }
    }

    public void destroyResourcesAndPools(Collection resources, Collection pools) {
        this.destroyResources(resources);
        this.destroyConnectionPools(pools);
    }

    public boolean checkAndLoadJdbcPool(String poolName) {
        boolean status = false;
        try {
            ResourcesUtil resutil = ResourcesUtil.createInstance();
            JdbcConnectionPool pool = this._runtime.getJdbcConnectionPoolConfig(poolName);
            DeferredResourceConfig defResConfig = resutil.getDeferredResourceConfig(null, pool, "jdbc", null);
            status = this.loadResourcesAndItsRar(defResConfig);
        }
        catch (ConnectorRuntimeException cre) {
            _logger.log(Level.WARNING, "unable to load Jdbc Connection Pool [ " + poolName + " ]", cre);
        }
        return status;
    }
}

