/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.web;

import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.RunAsNode;
import com.sun.enterprise.deployment.node.SecurityRoleRefNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.web.InitParamNode;
import com.sun.enterprise.deployment.node.web.WebBundleNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.EnvironmentEntry;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.SecurityRoleReference;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class ServletNode
extends DisplayableComponentNode {
    private static final XMLElement tag = new XMLElement("servlet");
    private WebComponentDescriptor descriptor;

    public ServletNode() {
        this.registerElementHandler(new XMLElement("security-role-ref"), SecurityRoleRefNode.class);
        this.registerElementHandler(new XMLElement("init-param"), InitParamNode.class);
        this.registerElementHandler(new XMLElement("run-as"), RunAsNode.class, "setRunAsIdentity");
    }

    protected XMLElement getXMLRootTag() {
        return tag;
    }

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (WebComponentDescriptor)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.descriptor;
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof RoleReference) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Adding security role ref " + newDescriptor);
            }
            this.descriptor.addSecurityRoleReference((RoleReference)newDescriptor);
        } else if (newDescriptor instanceof EnvironmentEntry) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Adding init-param " + newDescriptor);
            }
            this.descriptor.addInitializationParameter((InitializationParameter)newDescriptor);
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("display-name", "setName");
        table.put("servlet-name", "setCanonicalName");
        table.put("load-on-startup", "setLoadOnStartUp");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("servlet-class".equals(element.getQName())) {
            this.descriptor.setServlet(true);
            this.descriptor.setWebComponentImplementation(value);
        } else if ("jsp-file".equals(element.getQName())) {
            this.descriptor.setServlet(false);
            this.descriptor.setWebComponentImplementation(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, WebComponentDescriptor descriptor) {
        RunAsIdentityDescriptor runAs;
        Node myNode = super.writeDescriptor(parent, descriptor);
        ServletNode.appendTextChild(myNode, "servlet-name", descriptor.getCanonicalName());
        if (descriptor.isServlet()) {
            ServletNode.appendTextChild(myNode, "servlet-class", descriptor.getWebComponentImplementation());
        } else {
            ServletNode.appendTextChild(myNode, "jsp-file", descriptor.getWebComponentImplementation());
        }
        WebBundleNode.addInitParam(myNode, "init-param", descriptor.getInitializationParameters());
        if (descriptor.getLoadOnStartUp() != -1) {
            ServletNode.appendTextChild(myNode, "load-on-startup", String.valueOf(descriptor.getLoadOnStartUp()));
        }
        if ((runAs = descriptor.getRunAsIdentity()) != null) {
            RunAsNode runAsNode = new RunAsNode();
            runAsNode.writeDescriptor(myNode, "run-as", runAs);
        }
        Enumeration<SecurityRoleReference> roleRefs = descriptor.getSecurityRoleReferences();
        SecurityRoleRefNode roleRefNode = new SecurityRoleRefNode();
        while (roleRefs.hasMoreElements()) {
            roleRefNode.writeDescriptor(myNode, "security-role-ref", (RoleReference)roleRefs.nextElement());
        }
        return myNode;
    }
}

