/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.web;

import com.sun.enterprise.deploy.shared.AbstractArchiveHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.jar.JarFile;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.naming.resources.FileDirContext;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.web.loader.WebappClassLoader;
import org.jvnet.hk2.annotations.Service;

@Service
public class WarHandler
extends AbstractArchiveHandler
implements ArchiveHandler {
    private static XMLInputFactory xmlIf = null;

    public String getArchiveType() {
        return "war";
    }

    public boolean handles(ReadableArchive archive) {
        return DeploymentUtils.isWebArchive(archive);
    }

    public ClassLoader getClassLoader(ClassLoader parent, ReadableArchive archive) {
        WebappClassLoader cloader = new WebappClassLoader(parent);
        try {
            FileDirContext r = new FileDirContext();
            File base = new File(archive.getURI());
            int baseFileLen = base.getPath().length();
            r.setDocBase(base.getAbsolutePath());
            SunWebXmlParser sunWebXmlParser = new SunWebXmlParser(base.getAbsolutePath());
            cloader.setDelegate(sunWebXmlParser.isDelegate());
            cloader.setResources(r);
            cloader.addRepository("WEB-INF/classes/", new File(base, "WEB-INF/classes/"));
            File libDir = new File(base, "WEB-INF/lib");
            if (libDir.exists()) {
                final boolean ignoreHiddenJarFiles = sunWebXmlParser.isIgnoreHiddenJarFiles();
                for (File file : libDir.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        String fileName = pathname.getName();
                        return fileName.endsWith("jar") && (!ignoreHiddenJarFiles || !fileName.startsWith("."));
                    }
                })) {
                    try {
                        cloader.addJar(file.getPath().substring(baseFileLen), new JarFile(file), file);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (XMLStreamException xse) {
            xse.printStackTrace();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        try {
            cloader.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cloader;
    }

    static {
        xmlIf = XMLInputFactory.newInstance();
        xmlIf.setProperty("javax.xml.stream.supportDTD", false);
    }

    private class SunWebXmlParser {
        private XMLStreamReader parser = null;
        private boolean delegate = true;
        private boolean ignoreHiddenJarFiles = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SunWebXmlParser(String baseStr) throws XMLStreamException, FileNotFoundException {
            FileInputStream input = null;
            File f = new File(baseStr, "WEB-INF/sun-web.xml");
            if (f.exists()) {
                input = new FileInputStream(f);
                try {
                    this.read(input);
                }
                finally {
                    if (this.parser != null) {
                        try {
                            this.parser.close();
                        }
                        catch (Exception ex) {}
                    }
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (Exception ex) {}
                    }
                }
            }
        }

        private void read(InputStream input) throws XMLStreamException {
            this.parser = xmlIf.createXMLStreamReader(input);
            int event = 0;
            boolean done = false;
            boolean inClassLoader = false;
            this.skipRoot("sun-web-app");
            while (!done && (event = this.parser.next()) != 8) {
                if (event == 1) {
                    int count;
                    String name = this.parser.getLocalName();
                    if ("class-loader".equals(name)) {
                        count = this.parser.getAttributeCount();
                        for (int i = 0; i < count; ++i) {
                            String attrName = this.parser.getAttributeName(i).getLocalPart();
                            if (!"delegate".equals(attrName)) continue;
                            this.delegate = Boolean.valueOf(this.parser.getAttributeValue(i));
                        }
                        inClassLoader = true;
                        continue;
                    }
                    if (inClassLoader && "property".equals(name)) {
                        count = this.parser.getAttributeCount();
                        String propName = null;
                        String value = null;
                        for (int i = 0; i < count; ++i) {
                            String attrName = this.parser.getAttributeName(i).getLocalPart();
                            if ("name".equals(attrName)) {
                                propName = this.parser.getAttributeValue(i);
                                continue;
                            }
                            if (!"value".equals(attrName)) continue;
                            value = this.parser.getAttributeValue(i);
                        }
                        if (!"ignoreHiddenJarFiles".equals(propName)) continue;
                        this.ignoreHiddenJarFiles = Boolean.valueOf(value);
                        continue;
                    }
                    this.skipSubTree(name);
                    continue;
                }
                if (!inClassLoader || event != 2 || !"class-loader".equals(this.parser.getLocalName())) continue;
                inClassLoader = false;
                done = true;
            }
        }

        private void skipRoot(String name) throws XMLStreamException {
            int event;
            while ((event = this.parser.next()) != 1) {
            }
            if (!name.equals(this.parser.getLocalName())) {
                throw new XMLStreamException();
            }
        }

        private void skipSubTree(String name) throws XMLStreamException {
            int event;
            do {
                if ((event = this.parser.next()) != 8) continue;
                throw new XMLStreamException();
            } while (event != 2 || !name.equals(this.parser.getLocalName()));
        }

        boolean isDelegate() {
            return this.delegate;
        }

        boolean isIgnoreHiddenJarFiles() {
            return this.ignoreHiddenJarFiles;
        }
    }
}

