/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.SecurityContainer;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.security.web.integration.WebSecurityManager;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DummyApplication;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class SecurityDeployer
extends SimpleDeployer<SecurityContainer, DummyApplication> {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    @Inject
    private ServerContext serverContext;
    @Inject
    private PolicyLoader policyLoader;

    @Override
    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        this.generatePolicy(dc);
    }

    @Override
    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
        this.removePolicy(dc);
    }

    @Override
    public DummyApplication load(SecurityContainer container, DeploymentContext context) {
        return new DummyApplication();
    }

    protected void generatePolicy(DeploymentContext dc) throws DeploymentException {
        Properties params = dc.getCommandParameters();
        String appName = params.getProperty("name");
        try {
            this.policyLoader.loadPolicy();
            Application app = dc.getModuleMetaData(Application.class);
            WebBundleDescriptor wbd = null;
            Set<WebBundleDescriptor> webDesc = app.getWebBundleDescriptors();
            Iterator<WebBundleDescriptor> iter = webDesc.iterator();
            if (iter.hasNext()) {
                wbd = iter.next();
            }
            WebSecurityManagerFactory wsmf = WebSecurityManagerFactory.getInstance();
            wsmf.newWebSecurityManager(wbd, this.serverContext);
            String name = WebSecurityManager.getContextID(wbd);
            SecurityUtil.generatePolicyFile(name);
        }
        catch (IASSecurityException se) {
            String msg = "Error in generating security policy for " + appName;
            throw new DeploymentException(msg, se);
        }
    }

    private void removePolicy(DeploymentContext dc) throws DeploymentException {
        Properties params = dc.getCommandParameters();
        String appName = params.getProperty("name");
        try {
            WebSecurityManagerFactory wsmf = WebSecurityManagerFactory.getInstance();
            String[] name = wsmf.getAndRemoveContextIdForWebAppName(appName);
            if (name != null && name[0] != null) {
                SecurityUtil.removePolicy(name[0]);
                wsmf.removeWebSecurityManager(name[0]);
            }
        }
        catch (IASSecurityException ex) {
            String msg = "Error in removing security policy for " + appName;
            _logger.log(Level.WARNING, msg, ex);
            throw new DeploymentException(msg, ex);
        }
    }

    @Override
    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    @Override
    public MetaData getMetaData() {
        ArrayList<ModuleDefinition> apis = new ArrayList<ModuleDefinition>();
        Module module = this.modulesRegistry.makeModuleFor("org.glassfish.javax.javaee", null);
        if (module != null) {
            apis.add(module.getModuleDefinition());
        }
        if ((module = this.modulesRegistry.makeModuleFor("org.glassfish.core.security", null)) != null) {
            apis.add(module.getModuleDefinition());
        }
        return new MetaData(false, apis.toArray(new ModuleDefinition[apis.size()]), null, new Class[]{Application.class});
    }
}

