/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.security.auth.realm.AuthenticationHandler;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.component.Habitat;

@Contract
public abstract class Realm
implements Comparable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Realm.class);
    private String myName;
    static final String RI_DEFAULT = "default";
    private Properties ctxProps = new Properties();
    private static final String PARAM_GROUPS = "assign-groups";
    private static final String GROUPS_SEP = ",";
    private List<String> assignGroups = null;

    public final String getName() {
        return this.myName;
    }

    protected final void setName(String name) {
        if (this.myName != null) {
            return;
        }
        this.myName = name;
    }

    public String toString() {
        return this.myName;
    }

    public int compareTo(Object realm) {
        if (!(realm instanceof Realm)) {
            return 1;
        }
        Realm r = (Realm)realm;
        String str = r.getAuthType();
        int temp = this.getAuthType().compareTo(str);
        if (temp != 0) {
            return temp;
        }
        str = r.getName();
        return this.getName().compareTo(str);
    }

    public static Realm instantiate(String name, String className, Properties props) throws BadRealmException {
        return Realm.doInstantiate(name, className, props);
    }

    public static Realm instantiate(String realmName, File f) throws NoSuchRealmException, BadRealmException, FileNotFoundException {
        if (!f.exists() || !f.isFile()) {
            throw new FileNotFoundException();
        }
        if (Realm._getInstance(realmName) != null) {
            throw new BadRealmException(localStrings.getLocalString("realm.already_exists", "This Realm already exists."));
        }
        FileInputStream in = null;
        Properties props = new Properties();
        try {
            in = new FileInputStream(f);
            props.load(in);
            String classname = props.getProperty("classname");
            assert (classname != null);
            Realm realm = Realm.doInstantiate(realmName, classname, props);
            return realm;
        }
        catch (IOException e) {
            throw new BadRealmException(e.toString());
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private static Realm doInstantiate(String name, String className, Properties props) throws BadRealmException {
        Habitat habitat = Globals.getDefaultHabitat();
        RealmsManager mgr = null;
        try {
            mgr = habitat.getComponent(RealmsManager.class);
            Class<?> realmClass = null;
            Realm r = habitat.getComponent(Realm.class, name);
            if (r == null) {
                try {
                    ClassLoaderHierarchy hierarchy = habitat.getComponent(ClassLoaderHierarchy.class);
                    realmClass = hierarchy.getCommonClassLoader().loadClass(className);
                    Object obj = realmClass.newInstance();
                    r = (Realm)obj;
                }
                catch (ClassNotFoundException ex) {
                    realmClass = Class.forName(className);
                    Object obj = realmClass.newInstance();
                    r = (Realm)obj;
                }
            }
            if (r != null) {
                r.setName(name);
                r.init(props);
                if (mgr == null) {
                    throw new BadRealmException("Unable to locate RealmsManager Service");
                }
                mgr.putIntoLoadedRealms(name, r);
                return r;
            }
            throw new BadRealmException("Unable to locate Realm class " + className);
        }
        catch (NoSuchRealmException ex) {
            throw new BadRealmException(ex);
        }
        catch (InstantiationException ex) {
            throw new BadRealmException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new BadRealmException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new BadRealmException(ex);
        }
    }

    protected static void updateInstance(Realm realm, String name) {
        Habitat habitat = Globals.getDefaultHabitat();
        RealmsManager mgr = habitat.getComponent(RealmsManager.class);
        if (mgr == null) {
            throw new RuntimeException("Unable to locate RealmsManager Service");
        }
        Realm oldRealm = mgr.getFromLoadedRealms(name);
        if (!oldRealm.getClass().equals(realm.getClass())) {
            throw new Error("Incompatible class " + realm.getClass() + " in replacement realm " + name);
        }
        realm.setName(oldRealm.getName());
        mgr.putIntoLoadedRealms(name, realm);
    }

    public static Realm getDefaultInstance() throws NoSuchRealmException {
        return Realm.getInstance(Realm.getDefaultRealm());
    }

    public static String getDefaultRealm() {
        Habitat habitat = Globals.getDefaultHabitat();
        RealmsManager mgr = habitat.getComponent(RealmsManager.class);
        if (mgr != null) {
            return mgr.getDefaultRealmName();
        }
        throw new RuntimeException("Unable to locate RealmsManager Service");
    }

    public static void setDefaultRealm(String realmName) {
        Habitat habitat = Globals.getDefaultHabitat();
        RealmsManager mgr = habitat.getComponent(RealmsManager.class);
        if (mgr == null) {
            throw new RuntimeException("Unable to locate RealmsManager Service");
        }
        mgr.setDefaultRealmName(realmName);
    }

    public static void unloadInstance(String realmName) throws NoSuchRealmException {
        Realm.getInstance(realmName);
        Habitat habitat = Globals.getDefaultHabitat();
        RealmsManager mgr = habitat.getComponent(RealmsManager.class);
        if (mgr == null) {
            throw new RuntimeException("Unable to locate RealmsManager Service");
        }
        mgr.removeFromLoadedRealms(realmName);
    }

    public void setProperty(String name, String value) {
        this.ctxProps.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this.ctxProps.getProperty(name);
    }

    protected Properties getProperties() {
        return this.ctxProps;
    }

    public String getJAASContext() {
        return this.ctxProps.getProperty("jaas-context");
    }

    public static Realm getInstance(String name) throws NoSuchRealmException {
        Realm retval = Realm._getInstance(name);
        if (retval == null) {
            throw new NoSuchRealmException(localStrings.getLocalString("realm.no_such_realm", name + " realm does not exist.", name));
        }
        return retval;
    }

    private static Realm _getInstance(String name) {
        Habitat habitat = Globals.getDefaultHabitat();
        RealmsManager mgr = habitat.getComponent(RealmsManager.class);
        if (mgr != null) {
            return mgr._getInstance(name);
        }
        throw new RuntimeException("Unable to locate RealmsManager Service");
    }

    public static Enumeration getRealmNames() {
        Habitat habitat = Globals.getDefaultHabitat();
        RealmsManager mgr = habitat.getComponent(RealmsManager.class);
        if (mgr != null) {
            return mgr.getRealmNames();
        }
        throw new RuntimeException("Unable to locate RealmsManager Service");
    }

    protected Realm() {
    }

    protected void init(Properties props) throws BadRealmException, NoSuchRealmException {
        String groupList = props.getProperty(PARAM_GROUPS);
        if (groupList != null && groupList.length() > 0) {
            this.setProperty(PARAM_GROUPS, groupList);
            this.assignGroups = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(groupList, GROUPS_SEP);
            while (st.hasMoreTokens()) {
                String grp = st.nextToken();
                if (this.assignGroups.contains(grp)) continue;
                this.assignGroups.add(grp);
            }
        }
    }

    public static boolean isValidRealm(String name) {
        Habitat habitat = Globals.getDefaultHabitat();
        RealmsManager mgr = habitat.getComponent(RealmsManager.class);
        if (mgr != null) {
            return mgr.isValidRealm(name);
        }
        throw new RuntimeException("Unable to locate RealmsManager Service");
    }

    protected String[] addAssignGroups(String[] grps) {
        String[] resultGroups = grps;
        if (this.assignGroups != null && this.assignGroups.size() > 0) {
            ArrayList<String> groupList = new ArrayList<String>();
            if (grps != null && grps.length > 0) {
                for (String grp : grps) {
                    groupList.add(grp);
                }
            }
            for (String agrp : this.assignGroups) {
                if (groupList.contains(agrp)) continue;
                groupList.add(agrp);
            }
            resultGroups = groupList.toArray(new String[groupList.size()]);
        }
        return resultGroups;
    }

    public abstract String getAuthType();

    public abstract AuthenticationHandler getAuthenticationHandler();

    public abstract Enumeration getUserNames() throws BadRealmException;

    public abstract User getUser(String var1) throws NoSuchUserException, BadRealmException;

    public abstract Enumeration getGroupNames() throws BadRealmException;

    public abstract Enumeration getGroupNames(String var1) throws InvalidOperationException, NoSuchUserException;

    public abstract void refresh() throws BadRealmException;

    public abstract void addUser(String var1, String var2, String[] var3) throws BadRealmException, IASSecurityException;

    public abstract void removeUser(String var1) throws NoSuchUserException, BadRealmException;

    public abstract void updateUser(String var1, String var2, String var3, String[] var4) throws NoSuchUserException, BadRealmException, IASSecurityException;

    public abstract boolean supportsUserManagement();

    public abstract void persist() throws BadRealmException;
}

