/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.authorize.PolicyContextHandlerImpl;
import com.sun.enterprise.security.web.integration.WebSecurityManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.glassfish.internal.api.ServerContext;

public class WebSecurityManagerFactory {
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private Map securityManagerPool = new HashMap();
    private Map CONTEXT_ID = new HashMap();
    private static WebSecurityManagerFactory factory = null;

    private WebSecurityManagerFactory() {
    }

    public static synchronized WebSecurityManagerFactory getInstance() {
        if (factory == null) {
            factory = new WebSecurityManagerFactory();
            WebSecurityManagerFactory.registerPolicyHandlers();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSecurityManager newWebSecurityManager(WebBundleDescriptor wbd) {
        WebSecurityManager wsManager;
        String contextId = WebSecurityManager.getContextID(wbd);
        String appname = wbd.getApplication().getRegistrationName();
        Map map = this.CONTEXT_ID;
        synchronized (map) {
            ArrayList<String> lst = (ArrayList<String>)this.CONTEXT_ID.get(appname);
            if (lst == null) {
                lst = new ArrayList<String>();
                this.CONTEXT_ID.put(appname, lst);
            }
            if (!lst.contains(contextId)) {
                lst.add(contextId);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] Web Security:Creating WebSecurityManager for contextId = " + contextId);
        }
        if ((wsManager = this.getWebSecurityManager(contextId)) == null) {
            try {
                wsManager = new WebSecurityManager(wbd);
            }
            catch (PolicyContextException e) {
                logger.log(Level.FINE, "[Web-Security] FATAl Exception. Unable to create WebSecurityManager: " + e.getMessage());
                throw new RuntimeException(e);
            }
            Map map2 = this.securityManagerPool;
            synchronized (map2) {
                WebSecurityManager other = (WebSecurityManager)this.securityManagerPool.get(contextId);
                if (other == null) {
                    this.securityManagerPool.put(contextId, wsManager);
                } else {
                    wsManager = other;
                }
            }
        }
        return wsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSecurityManager newWebSecurityManager(WebBundleDescriptor wbd, ServerContext context) {
        WebSecurityManager wsManager;
        String contextId = WebSecurityManager.getContextID(wbd);
        String appname = wbd.getApplication().getRegistrationName();
        Map map = this.CONTEXT_ID;
        synchronized (map) {
            ArrayList<String> lst = (ArrayList<String>)this.CONTEXT_ID.get(appname);
            if (lst == null) {
                lst = new ArrayList<String>();
                this.CONTEXT_ID.put(appname, lst);
            }
            if (!lst.contains(contextId)) {
                lst.add(contextId);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] Web Security:Creating WebSecurityManager for contextId = " + contextId);
        }
        if ((wsManager = this.getWebSecurityManager(contextId)) == null) {
            try {
                wsManager = new WebSecurityManager(wbd, context);
            }
            catch (PolicyContextException e) {
                logger.log(Level.FINE, "[Web-Security] FATAl Exception. Unable to create WebSecurityManager: " + e.getMessage());
                throw new RuntimeException(e);
            }
            Map map2 = this.securityManagerPool;
            synchronized (map2) {
                WebSecurityManager other = (WebSecurityManager)this.securityManagerPool.get(contextId);
                if (other == null) {
                    this.securityManagerPool.put(contextId, wsManager);
                } else {
                    wsManager = other;
                }
            }
        }
        return wsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSecurityManager getWebSecurityManager(String contextId) {
        Map map = this.securityManagerPool;
        synchronized (map) {
            return (WebSecurityManager)this.securityManagerPool.get(contextId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWebSecurityManager(String contextId) {
        Map map = this.securityManagerPool;
        synchronized (map) {
            this.securityManagerPool.remove(contextId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getContextIdsOfApp(String appName) {
        Map map = this.CONTEXT_ID;
        synchronized (map) {
            List contextId = (List)this.CONTEXT_ID.get(appName);
            if (contextId == null) {
                return null;
            }
            String[] arrayContext = new String[contextId.size()];
            arrayContext = contextId.toArray(arrayContext);
            return arrayContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAndRemoveContextIdForWebAppName(String appName) {
        Map map = this.CONTEXT_ID;
        synchronized (map) {
            String[] rvalue = this.getContextIdsOfApp(appName);
            this.CONTEXT_ID.remove(appName);
            return rvalue;
        }
    }

    private static void registerPolicyHandlers() {
        try {
            PolicyContextHandler pch = PolicyContextHandlerImpl.getInstance();
            PolicyContext.registerHandler("javax.ejb.EnterpriseBean", pch, true);
            PolicyContext.registerHandler("javax.security.auth.Subject.container", pch, true);
            PolicyContext.registerHandler("javax.ejb.arguments", pch, true);
            PolicyContext.registerHandler("javax.servlet.http.HttpServletRequest", pch, true);
            PolicyContext.registerHandler("java.security.Policy.supportsReuse", pch, true);
        }
        catch (PolicyContextException ex) {
            Logger.getLogger(WebSecurityManagerFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

