/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.spi.TransactionInternal;
import com.sun.enterprise.transaction.spi.TransactionalResource;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaEETransactionImpl
extends TimerTask
implements JavaEETransaction {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    private static StringManager sm = StringManager.getManager(JavaEETransactionImpl.class);
    static JavaEETransactionManager javaEETM;
    private static long txIdCounter;
    private long txId;
    private JavaEEXid xid;
    private TransactionInternal jtsTx;
    private TransactionalResource nonXAResource;
    private TransactionalResource laoResource;
    private int localTxStatus = 0;
    private Vector syncs = new Vector();
    private Vector interposedSyncs = new Vector();
    private boolean commitStarted = false;
    private long startTime;
    private boolean isTimedOut = false;
    private boolean isTimerTask = false;
    private int timeout = 0;
    private boolean imported = false;
    private HashMap resourceTable;
    private HashMap<Object, Object> userResourceMap;
    private Object activeTxCache;
    private Map<EntityManagerFactory, EntityManager> txEntityManagerMap;
    private Map<EntityManagerFactory, EntityManager> extendedEntityManagerMap;
    private String componentName = null;
    private ArrayList<String> resourceNames = null;
    private Object containerData = null;
    private static boolean isTimerInitialized;
    private static Timer timer;
    private static final byte[] bqual;

    private static synchronized void initializeTimer() {
        if (isTimerInitialized) {
            return;
        }
        timer = new Timer(true);
        isTimerInitialized = true;
    }

    JavaEETransactionImpl() {
        this.txId = JavaEETransactionImpl.getNewTxId();
        this.xid = new JavaEEXid(this.txId);
        this.resourceTable = new HashMap();
        this.startTime = System.currentTimeMillis();
        if (_logger != null && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "--Created new JavaEETransactionImpl, txId = " + this.txId);
        }
    }

    JavaEETransactionImpl(int timeout) {
        this();
        if (!isTimerInitialized) {
            JavaEETransactionImpl.initializeTimer();
        }
        timer.schedule((TimerTask)this, timeout * 1000);
        this.isTimerTask = true;
        this.timeout = timeout;
    }

    JavaEETransactionImpl(TransactionInternal jtsTx) {
        this();
        this.jtsTx = jtsTx;
    }

    @Override
    public void run() {
        this.isTimedOut = true;
        try {
            this.setRollbackOnly();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getContainerData() {
        return this.containerData;
    }

    public void setContainerData(Object data) {
        this.containerData = data;
    }

    boolean isAssociatedTimeout() {
        return this.isTimerTask;
    }

    public int cancelTimerTask() {
        this.cancel();
        return this.timeout;
    }

    @Override
    public boolean isTimedout() {
        return this.isTimedOut;
    }

    private static synchronized long getNewTxId() {
        long newTxId = txIdCounter++;
        return newTxId;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof JavaEETransactionImpl) {
            JavaEETransactionImpl othertx = (JavaEETransactionImpl)other;
            return this.txId == othertx.txId;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.txId;
    }

    Xid getLocalXid() {
        return this.xid;
    }

    @Override
    public TransactionalResource getNonXAResource() {
        return this.nonXAResource;
    }

    void setNonXAResource(TransactionalResource h) {
        this.nonXAResource = h;
    }

    public TransactionalResource getLAOResource() {
        return this.laoResource;
    }

    public void setLAOResource(TransactionalResource h) {
        this.laoResource = h;
    }

    void setImportedTransaction() {
        this.imported = true;
    }

    boolean isImportedTransaction() {
        return this.imported;
    }

    synchronized void putUserResource(Object key, Object value) {
        if (this.userResourceMap == null) {
            this.userResourceMap = new HashMap();
        }
        this.userResourceMap.put(key, value);
    }

    synchronized Object getUserResource(Object key) {
        if (this.userResourceMap == null) {
            return null;
        }
        return this.userResourceMap.get(key);
    }

    void registerInterposedSynchronization(Synchronization sync) throws RollbackException, SystemException {
        this.interposedSyncs.add(sync);
        if (this.jtsTx != null) {
            this.jtsTx.registerInterposedSynchronization(sync);
        }
    }

    void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    String getComponentName() {
        return this.componentName;
    }

    synchronized void addResourceName(String resourceName) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList();
        }
        this.resourceNames.add(resourceName);
    }

    synchronized ArrayList<String> getResourceNames() {
        return this.resourceNames;
    }

    @Override
    public void addTxEntityManagerMapping(EntityManagerFactory emf, EntityManager em) {
        this.getTxEntityManagerMap().put(emf, em);
    }

    @Override
    public EntityManager getTxEntityManager(EntityManagerFactory emf) {
        return this.getTxEntityManagerMap().get(emf);
    }

    private Map<EntityManagerFactory, EntityManager> getTxEntityManagerMap() {
        if (this.txEntityManagerMap == null) {
            this.txEntityManagerMap = new HashMap<EntityManagerFactory, EntityManager>();
        }
        return this.txEntityManagerMap;
    }

    private void onTxCompletion(boolean status) {
        for (Map.Entry<EntityManagerFactory, EntityManager> entry : this.getTxEntityManagerMap().entrySet()) {
            EntityManager em = entry.getValue();
            if (!em.isOpen()) continue;
            try {
                em.close();
            }
            catch (Throwable th) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Exception while closing em.", th);
            }
        }
    }

    @Override
    public void addExtendedEntityManagerMapping(EntityManagerFactory emf, EntityManager em) {
        this.getExtendedEntityManagerMap().put(emf, em);
    }

    @Override
    public void removeExtendedEntityManagerMapping(EntityManagerFactory emf) {
        this.getExtendedEntityManagerMap().remove(emf);
    }

    @Override
    public EntityManager getExtendedEntityManager(EntityManagerFactory emf) {
        return this.getExtendedEntityManagerMap().get(emf);
    }

    private Map<EntityManagerFactory, EntityManager> getExtendedEntityManagerMap() {
        if (this.extendedEntityManagerMap == null) {
            this.extendedEntityManagerMap = new HashMap<EntityManagerFactory, EntityManager>();
        }
        return this.extendedEntityManagerMap;
    }

    @Override
    public boolean isLocalTx() {
        return this.jtsTx == null;
    }

    void setJTSTx(TransactionInternal jtsTx) throws RollbackException, SystemException {
        this.jtsTx = jtsTx;
        if (!this.commitStarted) {
            int i;
            for (i = 0; i < this.syncs.size(); ++i) {
                jtsTx.registerSynchronization((Synchronization)this.syncs.elementAt(i));
            }
            for (i = 0; i < this.interposedSyncs.size(); ++i) {
                jtsTx.registerInterposedSynchronization((Synchronization)this.interposedSyncs.elementAt(i));
            }
        }
    }

    TransactionInternal getJTSTx() {
        return this.jtsTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        block40: {
            Exception ex62;
            Synchronization sync3;
            int i3;
            if (this.isTimerTask) {
                this.cancel();
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "--In JavaEETransactionImpl.commit, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
            }
            this.commitStarted = true;
            if (this.jtsTx != null) {
                try {
                    this.jtsTx.commit();
                }
                finally {
                    ((JavaEETransactionManagerSimplified)javaEETM).clearThreadTx();
                    this.onTxCompletion(true);
                }
            }
            try {
                block39: {
                    Synchronization sync2;
                    int i2;
                    if (this.isTimedOut) {
                        if (this.nonXAResource != null) {
                            this.nonXAResource.getXAResource().rollback(this.xid);
                        }
                        this.localTxStatus = 4;
                        throw new RollbackException(sm.getString("enterprise_distributedtx.rollback_timeout"));
                    }
                    if (this.isRollbackOnly()) {
                        if (this.nonXAResource != null) {
                            this.nonXAResource.getXAResource().rollback(this.xid);
                        }
                        this.localTxStatus = 4;
                        throw new RollbackException(sm.getString("enterprise_distributedtx.mark_rollback"));
                    }
                    for (i2 = 0; i2 < this.syncs.size(); ++i2) {
                        try {
                            sync2 = (Synchronization)this.syncs.elementAt(i2);
                            sync2.beforeCompletion();
                            continue;
                        }
                        catch (RuntimeException ex2) {
                            this.setRollbackOnly();
                            continue;
                        }
                        catch (Exception ex3) {
                            // empty catch block
                        }
                    }
                    for (i2 = 0; i2 < this.interposedSyncs.size(); ++i2) {
                        try {
                            sync2 = (Synchronization)this.interposedSyncs.elementAt(i2);
                            sync2.beforeCompletion();
                            continue;
                        }
                        catch (RuntimeException ex4) {
                            this.setRollbackOnly();
                            continue;
                        }
                        catch (Exception ex5) {
                            // empty catch block
                        }
                    }
                    if (this.isRollbackOnly()) {
                        if (this.jtsTx == null) {
                            if (this.nonXAResource != null) {
                                this.nonXAResource.getXAResource().rollback(this.xid);
                            }
                            this.localTxStatus = 4;
                            throw new RollbackException(sm.getString("enterprise_distributedtx.mark_rollback"));
                        }
                        this.jtsTx.rollback();
                        this.localTxStatus = 4;
                        throw new RollbackException(sm.getString("enterprise_distributedtx.mark_rollback"));
                    }
                    if (this.jtsTx != null) {
                        this.jtsTx.commit();
                        this.localTxStatus = 3;
                        break block39;
                    }
                    if (this.nonXAResource != null) {
                        this.nonXAResource.getXAResource().commit(this.xid, true);
                    }
                    this.localTxStatus = 3;
                }
                Object var4_12 = null;
                ((JavaEETransactionManagerSimplified)javaEETM).clearThreadTx();
            }
            catch (Throwable throwable) {
                Exception ex62;
                Synchronization sync3;
                int i3;
                Object var4_13 = null;
                ((JavaEETransactionManagerSimplified)javaEETM).clearThreadTx();
                for (i3 = 0; i3 < this.interposedSyncs.size(); ++i3) {
                    try {
                        sync3 = (Synchronization)this.interposedSyncs.elementAt(i3);
                        sync3.afterCompletion(this.localTxStatus);
                        continue;
                    }
                    catch (Exception ex62) {
                        // empty catch block
                    }
                }
                for (i3 = 0; i3 < this.syncs.size(); ++i3) {
                    try {
                        sync3 = (Synchronization)this.syncs.elementAt(i3);
                        sync3.afterCompletion(this.localTxStatus);
                        continue;
                    }
                    catch (Exception ex62) {
                        // empty catch block
                    }
                }
                this.onTxCompletion(true);
                throw throwable;
            }
            for (i3 = 0; i3 < this.interposedSyncs.size(); ++i3) {
                try {
                    sync3 = (Synchronization)this.interposedSyncs.elementAt(i3);
                    sync3.afterCompletion(this.localTxStatus);
                    continue;
                }
                catch (Exception ex62) {
                    // empty catch block
                }
            }
            for (i3 = 0; i3 < this.syncs.size(); ++i3) {
                try {
                    sync3 = (Synchronization)this.syncs.elementAt(i3);
                    sync3.afterCompletion(this.localTxStatus);
                    continue;
                }
                catch (Exception ex62) {
                    // empty catch block
                }
            }
            this.onTxCompletion(true);
            {
                break block40;
                catch (RollbackException ex7) {
                    this.localTxStatus = 4;
                    throw ex7;
                }
                catch (SystemException ex8) {
                    this.localTxStatus = 8;
                    throw ex8;
                }
                catch (Exception ex9) {
                    this.localTxStatus = 4;
                    SystemException exc = new SystemException();
                    exc.initCause(ex9);
                    throw exc;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void rollback() throws IllegalStateException, SystemException {
        block26: {
            block25: {
                Exception ex222;
                Synchronization sync2;
                int i2;
                if (this.isTimerTask) {
                    this.cancel();
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "--In JavaEETransactionImpl.rollback, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
                }
                try {
                    block24: {
                        if (this.jtsTx != null) {
                            this.jtsTx.rollback();
                            break block24;
                        }
                        if (this.nonXAResource != null) {
                            this.nonXAResource.getXAResource().rollback(this.xid);
                        }
                        this.localTxStatus = 4;
                    }
                    Object var3_1 = null;
                    ((JavaEETransactionManagerSimplified)javaEETM).clearThreadTx();
                    if (this.jtsTx != null) break block25;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    ((JavaEETransactionManagerSimplified)javaEETM).clearThreadTx();
                    if (this.jtsTx == null) {
                        Exception ex222;
                        Synchronization sync2;
                        int i2;
                        for (i2 = 0; i2 < this.interposedSyncs.size(); ++i2) {
                            try {
                                sync2 = (Synchronization)this.interposedSyncs.elementAt(i2);
                                sync2.afterCompletion(4);
                                continue;
                            }
                            catch (Exception ex222) {
                                // empty catch block
                            }
                        }
                        for (i2 = 0; i2 < this.syncs.size(); ++i2) {
                            try {
                                sync2 = (Synchronization)this.syncs.elementAt(i2);
                                sync2.afterCompletion(4);
                                continue;
                            }
                            catch (Exception ex222) {
                                // empty catch block
                            }
                        }
                    }
                    this.onTxCompletion(false);
                    throw throwable;
                }
                for (i2 = 0; i2 < this.interposedSyncs.size(); ++i2) {
                    try {
                        sync2 = (Synchronization)this.interposedSyncs.elementAt(i2);
                        sync2.afterCompletion(4);
                        continue;
                    }
                    catch (Exception ex222) {
                        // empty catch block
                    }
                }
                for (i2 = 0; i2 < this.syncs.size(); ++i2) {
                    try {
                        sync2 = (Synchronization)this.syncs.elementAt(i2);
                        sync2.afterCompletion(4);
                        continue;
                    }
                    catch (Exception ex222) {
                        // empty catch block
                    }
                }
            }
            this.onTxCompletion(false);
            {
                break block26;
                catch (Exception ex) {
                    this.localTxStatus = 4;
                    Object var3_2 = null;
                    ((JavaEETransactionManagerSimplified)javaEETM).clearThreadTx();
                    if (this.jtsTx == null) {
                        Exception ex222;
                        Synchronization sync2;
                        int i2;
                        for (i2 = 0; i2 < this.interposedSyncs.size(); ++i2) {
                            try {
                                sync2 = (Synchronization)this.interposedSyncs.elementAt(i2);
                                sync2.afterCompletion(4);
                                continue;
                            }
                            catch (Exception ex222) {
                                // empty catch block
                            }
                        }
                        for (i2 = 0; i2 < this.syncs.size(); ++i2) {
                            try {
                                sync2 = (Synchronization)this.syncs.elementAt(i2);
                                sync2.afterCompletion(4);
                                continue;
                            }
                            catch (Exception ex222) {
                                // empty catch block
                            }
                        }
                    }
                    this.onTxCompletion(false);
                }
            }
        }
    }

    @Override
    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "--In JavaEETransactionImpl.delistResource, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
        }
        if (this.jtsTx != null) {
            return this.jtsTx.delistResource(xaRes, flag);
        }
        throw new IllegalStateException(sm.getString("enterprise_distributedtx.deleteresource_for_localtx"));
    }

    @Override
    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "--In JavaEETransactionImpl.enlistResource, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
        }
        if (this.jtsTx != null) {
            return this.jtsTx.enlistResource(xaRes);
        }
        if (this.nonXAResource != null) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.already_has_nonxa"));
        }
        ((JavaEETransactionManagerSimplified)javaEETM).startJTSTx(this);
        return this.jtsTx.enlistResource(xaRes);
    }

    @Override
    public int getStatus() throws SystemException {
        if (this.jtsTx != null) {
            return this.jtsTx.getStatus();
        }
        return this.localTxStatus;
    }

    @Override
    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "--In JavaEETransactionImpl.registerSynchronization, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
        }
        if (this.jtsTx != null) {
            this.jtsTx.registerSynchronization(sync);
        } else {
            this.syncs.add(sync);
        }
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            this.jtsTx.setRollbackOnly();
        } else {
            this.localTxStatus = 1;
        }
    }

    private boolean isRollbackOnly() throws IllegalStateException, SystemException {
        int status = this.jtsTx != null ? this.jtsTx.getStatus() : this.localTxStatus;
        return status == 1;
    }

    public String toString() {
        return "JavaEETransactionImpl: txId=" + this.txId + " nonXAResource=" + this.nonXAResource + " jtsTx=" + this.jtsTx + " localTxStatus=" + this.localTxStatus + " syncs=" + this.syncs;
    }

    public String getTransactionId() {
        return this.xid.toString();
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void setResources(Set resources, String poolName) {
        this.resourceTable.put(poolName, resources);
    }

    @Override
    public Set getResources(String poolName) {
        return (Set)this.resourceTable.get(poolName);
    }

    @Override
    public Set getAllParticipatingPools() {
        return this.resourceTable.keySet();
    }

    public void setActiveTxCache(Object cache) {
        this.activeTxCache = cache;
    }

    public Object getActiveTxCache() {
        return this.activeTxCache;
    }

    public int getRemainingTimeout() {
        if (this.timeout == 0) {
            return this.timeout;
        }
        if (this.isTimedOut) {
            return -1;
        }
        return this.timeout - (int)((System.currentTimeMillis() - this.startTime) / 1000L);
    }

    static {
        txIdCounter = 1L;
        isTimerInitialized = false;
        timer = null;
        bqual = new byte[]{0};
    }

    private class JavaEEXid
    implements Xid {
        private static final int formatId = 987654321;
        private byte[] gtrId = new byte[8];
        private String stringForm = null;

        JavaEEXid(long txId) {
            Utility.longToBytes(txId, this.gtrId, 0);
        }

        public int getFormatId() {
            return 987654321;
        }

        public byte[] getGlobalTransactionId() {
            return this.gtrId;
        }

        public byte[] getBranchQualifier() {
            return bqual;
        }

        public String toString() {
            if (this.stringForm != null) {
                return this.stringForm;
            }
            char[] buff = new char[this.gtrId.length * 2 + 3];
            int pos = 0;
            int globalLen = this.gtrId.length;
            for (int i = 0; i < globalLen; ++i) {
                int currCharHigh = (this.gtrId[i] & 0xF0) >> 4;
                int currCharLow = this.gtrId[i] & 0xF;
                buff[pos++] = (char)(currCharHigh + (currCharHigh > 9 ? 55 : 48));
                buff[pos++] = (char)(currCharLow + (currCharLow > 9 ? 55 : 48));
            }
            buff[pos++] = 95;
            int currCharHigh = 0;
            int currCharLow = 0;
            buff[pos++] = (char)(currCharHigh + (currCharHigh > 9 ? 55 : 48));
            buff[pos++] = (char)(currCharLow + (currCharLow > 9 ? 55 : 48));
            this.stringForm = new String(buff);
            return this.stringForm;
        }
    }
}

