/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

public class TransactionServiceConfigListener
implements ConfigListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    @Inject
    private JavaEETransactionManager tm;
    @Inject
    private TransactionService ts;

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        for (PropertyChangeEvent event : events) {
            System.err.println("XXX event ======== " + event.getSource() + " " + event.getPropertyName() + " " + event.getOldValue() + " " + event.getNewValue());
            if (event.getPropertyName().equals("timeout-in-seconds")) {
                _logger.log(Level.FINE, " Transaction Timeout interval event occurred");
                String oldTimeout = (String)event.getOldValue();
                String newTimeout = (String)event.getNewValue();
                if (oldTimeout.equals(newTimeout)) continue;
                try {
                    this.tm.setDefaultTransactionTimeout(Integer.parseInt(newTimeout, 10));
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "transaction.reconfig_txn_timeout_failed", ex);
                }
                continue;
            }
            if (event.getPropertyName().equals("keypoint-interval")) {
                _logger.log(Level.FINE, "Keypoint interval event occurred");
                Object oldKeyPoint = event.getOldValue();
                Object newKeyPoint = event.getNewValue();
                if (oldKeyPoint.equals(newKeyPoint)) continue;
                this.tm.handlePropertyUpdate("keypoint-interval", newKeyPoint);
                continue;
            }
            if (!event.getPropertyName().equals("retry-timeout-in-seconds")) continue;
            Object oldRetryTiemout = event.getOldValue();
            Object newRetryTiemout = event.getNewValue();
            _logger.log(Level.FINE, "retry_timeout_in_seconds reconfig event occurred " + newRetryTiemout);
            if (oldRetryTiemout.equals(newRetryTiemout)) continue;
            this.tm.handlePropertyUpdate("retry-timeout-in-seconds", newRetryTiemout);
        }
        return null;
    }

    public void setTM(JavaEETransactionManager tm) {
        this.tm = tm;
    }
}

