/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.spi.TransactionOperationsManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class UserTransactionImpl
implements UserTransaction,
Serializable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    private static StringManager sm = StringManager.getManager(UserTransactionImpl.class);
    @Inject
    private transient JavaEETransactionManager transactionManager;
    @Inject
    private transient InvocationManager invocationManager;
    private static final boolean debug = false;
    private transient boolean initialized;
    private transient UserTransaction userTx;
    private boolean checkEjbAccess;

    public UserTransactionImpl() {
        this(true);
    }

    public UserTransactionImpl(boolean doEjbAccessChecks) {
        this.init();
        this.checkEjbAccess = doEjbAccessChecks;
    }

    private void init() {
        this.initialized = true;
    }

    private void checkUserTransactionMethodAccess(ComponentInvocation inv) throws IllegalStateException, SystemException {
        if (inv.getInvocationType() == ComponentInvocation.ComponentInvocationType.EJB_INVOCATION && this.checkEjbAccess && !((TransactionOperationsManager)((Object)inv)).userTransactionMethodsAllowed()) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.operation_not_allowed"));
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.begin();
            return;
        }
        Transaction inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess((ComponentInvocation)((Object)inv));
        }
        this.transactionManager.begin();
        try {
            if (inv != null) {
                if (((ComponentInvocation)((Object)inv)).getInvocationType() == ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
                    ((TransactionOperationsManager)((Object)inv)).doAfterBegin();
                }
                ((ComponentInvocation)((Object)inv)).setTransaction((Transaction)this.transactionManager.getTransaction());
                this.transactionManager.enlistComponentResources();
            }
        }
        catch (RemoteException ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_begin", ex);
            SystemException sysEx = new SystemException(ex.getMessage());
            sysEx.initCause(ex);
            throw sysEx;
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.commit();
            return;
        }
        Object inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess((ComponentInvocation)inv);
        }
        try {
            this.transactionManager.delistComponentResources(false);
            this.transactionManager.commit();
        }
        catch (RemoteException ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_commit", ex);
            throw new SystemException();
        }
        finally {
            if (inv != null) {
                ((ComponentInvocation)inv).setTransaction(null);
            }
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.rollback();
            return;
        }
        Object inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess((ComponentInvocation)inv);
        }
        try {
            this.transactionManager.delistComponentResources(false);
            this.transactionManager.rollback();
        }
        catch (RemoteException ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_rollback", ex);
            throw new SystemException();
        }
        finally {
            if (inv != null) {
                ((ComponentInvocation)inv).setTransaction(null);
            }
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.setRollbackOnly();
            return;
        }
        Object inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess((ComponentInvocation)inv);
        }
        this.transactionManager.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            return this.userTx.getStatus();
        }
        Object inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess((ComponentInvocation)inv);
        }
        return this.transactionManager.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.setTransactionTimeout(seconds);
            return;
        }
        Object inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess((ComponentInvocation)inv);
        }
        if (seconds < 0) {
            seconds = 0;
        }
        this.transactionManager.setTransactionTimeout(seconds);
    }

    public void setForTesting(TransactionManager tm, InvocationManager im) {
        this.transactionManager = (JavaEETransactionManager)tm;
        this.invocationManager = im;
        ((JavaEETransactionManagerSimplified)this.transactionManager).invMgr = im;
    }
}

