/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.glassfish;

import com.sun.enterprise.universal.NameValue;
import com.sun.enterprise.universal.collections.ManifestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminCommandResponse {
    public static final String GENERATED_HELP = "GeneratedHelp";
    public static final String MANPAGE = "MANPAGE";
    public static final String SYNOPSIS = "SYNOPSIS";
    public static final String MESSAGE = "message";
    public static final String CHILDREN_TYPE = "children-type";
    public static final String EXITCODE = "exit-code";
    public static final String SUCCESS = "Success";
    private Map<String, Map<String, String>> allRaw;
    private Map<String, String> mainRaw;
    private List<NameValue<String, String>> mainKeys;
    private String mainMessage;
    private String mainChildrenType;
    private String signature;
    private String cause;
    private int exitCode = 0;
    private boolean isGeneratedHelp;

    public AdminCommandResponse(InputStream inStream) throws IOException {
        Manifest m = new Manifest(inStream);
        m.read(inStream);
        this.allRaw = ManifestUtils.normalize(m);
        this.mainRaw = ManifestUtils.getMain(this.allRaw);
        this.makeMain();
    }

    public boolean isGeneratedHelp() {
        return this.isGeneratedHelp;
    }

    public String getMainMessage() {
        return this.mainMessage;
    }

    public boolean wasSuccess() {
        return this.exitCode == 0;
    }

    public String getCause() {
        return this.cause;
    }

    public Map<String, String> getMainAtts() {
        return this.mainRaw;
    }

    public List<NameValue<String, String>> getMainKeys() {
        return this.mainKeys;
    }

    public String getValue(String key) {
        for (NameValue<String, String> nv : this.mainKeys) {
            if (!nv.getName().equals(key)) continue;
            return nv.getValue();
        }
        return null;
    }

    public List<NameValue<String, String>> getKeys(Map<String, String> map) {
        LinkedList<NameValue<String, String>> list = new LinkedList<NameValue<String, String>>();
        String keysString = map.get("keys");
        if (this.ok(keysString)) {
            String[] keys;
            for (String key : keys = keysString.split(";")) {
                String name = map.get(key + "_name");
                String value = map.get(key + "_value");
                if (!this.ok(name)) continue;
                list.add(new NameValue<String, String>(name, value));
            }
        }
        return list;
    }

    public Map<String, Map<String, String>> getChildren(Map<String, String> map) {
        HashMap<String, Map<String, String>> children = new HashMap<String, Map<String, String>>();
        String kidsString = map.get("children");
        if (this.ok(kidsString)) {
            String[] kids;
            for (String kid : kids = kidsString.split(";")) {
                Map<String, String> kidMap = this.allRaw.get(kid);
                if (kidMap == null) continue;
                children.put(kid, kidMap);
            }
        }
        if (children.isEmpty()) {
            return null;
        }
        return children;
    }

    private void makeMain() {
        this.mainMessage = this.mainRaw.get(MESSAGE);
        this.mainChildrenType = this.mainRaw.get(CHILDREN_TYPE);
        this.exitCode = SUCCESS.equalsIgnoreCase(this.mainRaw.get(EXITCODE)) ? 0 : 1;
        this.signature = this.mainRaw.get("Signature-Version");
        this.cause = this.mainRaw.get("cause");
        this.makeMainKeys();
    }

    private void makeMainKeys() {
        this.mainKeys = this.getKeys(this.mainRaw);
        for (NameValue<String, String> nv : this.mainKeys) {
            if (!nv.getName().equals(GENERATED_HELP)) continue;
            this.isGeneratedHelp = Boolean.parseBoolean(nv.getValue());
            this.mainKeys.remove(nv);
            break;
        }
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0 && !s.equals("null");
    }
}

