/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.zip;

import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipFile {
    private static final int BUFFER_SIZE = 65536;
    private File explodeDir = null;
    private ArrayList files = null;
    private static final String specialDir = "META-INF/";
    private byte[] buffer = new byte[65536];
    private ZipInputStream zipStream = null;
    private Logger _utillogger = LogDomains.getLogger("javax.enterprise.system.util");
    private File zipFile = null;

    public ZipFile(String zipFilename, String explodeDirName) throws ZipFileException {
        this(new File(zipFilename), new File(explodeDirName));
    }

    public ZipFile(InputStream inStream, String anExplodeDirName) throws ZipFileException {
        this((InputStream)new BufferedInputStream(inStream, 65536), new File(anExplodeDirName));
    }

    public ZipFile(File zipFile, File anExplodeDir) throws ZipFileException {
        this.checkZipFile(zipFile);
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(zipFile), 65536);
            this.ctor(bis, anExplodeDir);
            this.zipFile = zipFile;
        }
        catch (Throwable e) {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Throwable thr) {
                    throw new ZipFileException(thr);
                }
            }
            throw new ZipFileException(e);
        }
    }

    public ZipFile(InputStream inStream, File anExplodeDir) throws ZipFileException {
        this.ctor(inStream, anExplodeDir);
    }

    public ArrayList explode() throws ZipFileException {
        this.files = new ArrayList();
        ZipInputStream zin = null;
        try {
            ZipEntry ze;
            zin = this.zipStream;
            while ((ze = zin.getNextEntry()) != null) {
                BufferedOutputStream os;
                String filename = ze.getName();
                File fullpath = null;
                if (this.isDirectory(filename)) {
                    fullpath = new File(this.explodeDir, filename.substring(0, filename.length() - 1));
                    fullpath.mkdir();
                    continue;
                }
                fullpath = new File(this.explodeDir, filename);
                File newDir = fullpath.getParentFile();
                newDir.mkdirs();
                if (fullpath.delete() && this._utillogger.isLoggable(Level.FINE)) {
                    this._utillogger.log(Level.FINE, "File " + fullpath.getAbsolutePath() + " is being overwritten during expansion of " + (this.zipFile != null ? "file " + this.zipFile.getAbsolutePath() : "stream"));
                }
                if ((os = new BufferedOutputStream(this.getOutputStream(filename), 65536)) == null) continue;
                int totalBytes = 0;
                int numBytes = zin.read(this.buffer);
                while (numBytes > 0) {
                    os.write(this.buffer, 0, numBytes);
                    totalBytes += numBytes;
                    numBytes = zin.read(this.buffer);
                }
                os.close();
                this.files.add(filename);
            }
        }
        catch (IOException e) {
            throw new ZipFileException(e);
        }
        finally {
            try {
                zin.close();
            }
            catch (IOException e) {
                throw new ZipFileException("Got an exception while trying to close Jar input stream: " + e);
            }
        }
        return this.files;
    }

    public static void extractJar(String jarEntryName, JarFile earFile, File jarFile) throws ZipFileException {
        try {
            File parent = jarFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            ZipEntry jarEntry = earFile.getEntry(jarEntryName);
            if (jarEntryName == null) {
                throw new ZipFileException(jarEntryName + " not found in " + earFile.getName());
            }
            InputStream is = earFile.getInputStream(jarEntry);
            FileOutputStream fos = new FileOutputStream(jarFile);
            FileUtils.copy(is, fos, jarEntry.getSize());
        }
        catch (IOException e) {
            throw new ZipFileException(e);
        }
    }

    public ArrayList getFileList() {
        return this.files;
    }

    private static ArrayList doExplode(ZipFile zf) throws ZipFileException {
        ArrayList<String> finalList = new ArrayList<String>(50);
        ArrayList<ZipFile> zipFileList = new ArrayList<ZipFile>();
        ArrayList tmpList = null;
        ZipFile tmpZf = null;
        Iterator itr = null;
        String fileName2 = null;
        zipFileList.add(zf);
        while (zipFileList.size() > 0) {
            tmpZf = (ZipFile)zipFileList.remove(zipFileList.size() - 1);
            tmpList = tmpZf.explode();
            for (String fileName2 : tmpList) {
                if (!fileName2.endsWith(".jar")) {
                    finalList.add(fileName2);
                } else {
                    File f = new File(tmpZf.explodeDir, fileName2);
                    ZipFile newZf = new ZipFile(f, tmpZf.explodeDir);
                    zipFileList.add(newZf);
                }
                if (tmpZf == zf) continue;
                tmpZf.explodeDir.delete();
            }
        }
        return finalList;
    }

    private void ctor(InputStream inStream, File anExplodeDir) throws ZipFileException {
        ZipFile.insist(anExplodeDir != null);
        this.explodeDir = anExplodeDir;
        try {
            this.zipStream = new ZipInputStream(inStream);
            this.checkExplodeDir();
        }
        catch (Throwable t) {
            if (this.zipStream != null) {
                try {
                    this.zipStream.close();
                }
                catch (Throwable thr) {
                    // empty catch block
                }
            }
            throw new ZipFileException(t.toString());
        }
    }

    private boolean isDirectory(String s) {
        char c = s.charAt(s.length() - 1);
        return c == '/' || c == '\\';
    }

    private void checkZipFile(File zipFile) throws ZipFileException {
        ZipFile.insist(zipFile != null);
        String zipFileName = zipFile.getPath();
        ZipFile.insist(zipFile.exists(), "zipFile (" + zipFileName + ") doesn't exist");
        ZipFile.insist(!zipFile.isDirectory(), "zipFile (" + zipFileName + ") is actually a directory!");
    }

    private void checkExplodeDir() throws ZipFileException {
        String explodeDirName = this.explodeDir.getPath();
        this.explodeDir.mkdirs();
        ZipFile.insist(this.explodeDir.exists(), "Target Directory doesn't exist: " + explodeDirName);
        ZipFile.insist(this.explodeDir.isDirectory(), "Target Directory isn't a directory: " + explodeDirName);
        ZipFile.insist(this.explodeDir.canWrite(), "Can't write to Target Directory: " + explodeDirName);
    }

    private static boolean isSpecial(String filename) {
        return filename.toUpperCase().startsWith(specialDir.toUpperCase());
    }

    private FileOutputStream getOutputStream(String filename) throws ZipFileException {
        File f = new File(this.explodeDir, filename);
        if (f.isDirectory()) {
            return null;
        }
        try {
            return new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new ZipFileException("filename: " + f.getPath() + "  " + e);
        }
        catch (IOException e) {
            throw new ZipFileException(e);
        }
    }

    private boolean isManifest(String filename) {
        if (filename.toLowerCase().endsWith("manifest.mf")) {
            return false;
        }
        return false;
    }

    private static void pr(String s) {
        System.out.println(s);
    }

    private static void insist(String s) throws ZipFileException {
        if (s == null || s.length() < 0) {
            throw new ZipFileException();
        }
    }

    private static void insist(String s, String mesg) throws ZipFileException {
        if (s == null || s.length() < 0) {
            throw new ZipFileException(mesg);
        }
    }

    private static void insist(boolean b) throws ZipFileException {
        if (!b) {
            throw new ZipFileException();
        }
    }

    private static void insist(boolean b, String mesg) throws ZipFileException {
        if (!b) {
            throw new ZipFileException(mesg);
        }
    }
}

