/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Dom;

@Service(name="list")
public class ListCommand
extends V2DottedNameSupport
implements AdminCommand {
    @Inject
    Domain domain;
    @Param(optional=true, defaultValue="false")
    Boolean monitor;
    @Param(primary=true)
    String pattern = "";
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.monitor.booleanValue()) {
            this.listMonitorElements(report);
            return;
        }
        V2DottedNameSupport.TreeNode[] parentNodes = this.getAliasedParent(this.domain, this.pattern);
        HashMap<Dom, String> dottedNames = new HashMap<Dom, String>();
        for (V2DottedNameSupport.TreeNode parentNode : parentNodes) {
            dottedNames.putAll(this.getAllDottedNodes(parentNode.node));
        }
        this.pattern = parentNodes[0].relativeName;
        Map<Dom, String> matchingNodes = this.getMatchingNodes(dottedNames, this.pattern);
        if (matchingNodes.isEmpty() && this.pattern.lastIndexOf(46) != -1) {
            matchingNodes = this.getMatchingNodes(dottedNames, this.pattern.substring(0, this.pattern.lastIndexOf(".")));
        }
        for (Map.Entry<Dom, String> node : matchingNodes.entrySet()) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setChildrenType("DottedName");
            part.setMessage(node.getValue());
        }
    }

    private void listMonitorElements(ActionReport report) {
        if (this.pattern == null || this.pattern.equals("")) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("match pattern is invalid or null");
        }
        TreeNode tn = this.mrdr.get("server");
        List<TreeNode> ltn = tn.getNodes(this.pattern);
        for (TreeNode tn1 : ltn) {
            if (!tn1.hasChildNodes()) continue;
            System.out.println(tn1.getCompletePathName());
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(tn1.getCompletePathName());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

