/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V2DottedNameSupport {
    public Map<Dom, String> getAllDottedNodes(ConfigBeanProxy proxy) {
        return this.getAllDottedNodes(Dom.unwrap(proxy));
    }

    public Map<Dom, String> getAllDottedNodes(Dom root) {
        HashMap<Dom, String> result = new HashMap<Dom, String>();
        this.getAllSubDottedNames(null, root, result);
        return result;
    }

    protected void getAllSubDottedNames(String prefix, Dom parent, Map<Dom, String> result) {
        Set<String> elementNames = parent.getLeafElementNames();
        for (String childName : elementNames) {
            boolean collection = true;
            if (parent.model.findIgnoreCase(childName) != null) {
                if (parent.isLeaf(childName)) continue;
                collection = parent.isCollection(childName);
            }
            for (Dom child : parent.nodeElements(childName)) {
                String newPrefix;
                String string = newPrefix = prefix == null ? childName : prefix + "." + childName;
                if (collection) {
                    String name = child.getKey();
                    if (name == null) {
                        name = child.attribute("name");
                    }
                    newPrefix = name == null ? newPrefix : newPrefix + "." + name;
                    this.getAllSubDottedNames(newPrefix, child, result);
                    continue;
                }
                this.getAllSubDottedNames(newPrefix, child, result);
            }
        }
        if (prefix != null) {
            result.put(parent, prefix);
        }
    }

    public Map<String, String> getNodeAttributes(Dom node, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String attrName : node.getAttributeNames()) {
            String value = node.attribute(attrName);
            if (value == null) continue;
            result.put(attrName, value);
        }
        for (String leafName : node.getLeafElementNames()) {
            String value;
            ConfigModel.Property property = node.model.findIgnoreCase(leafName);
            if (property == null) {
                property = node.model.findIgnoreCase("*");
            }
            if (!property.isLeaf() || (value = node.leafElement(leafName)) == null) continue;
            result.put(leafName, value);
        }
        return result;
    }

    public Map<Dom, String> getMatchingNodes(Map<Dom, String> nodes, String pattern) {
        HashMap<Dom, String> result = new HashMap<Dom, String>();
        for (Map.Entry<Dom, String> entry : nodes.entrySet()) {
            String dottedName = entry.getValue();
            if (!this.matches(dottedName, pattern)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public boolean matches(String dottedName, String pattern) {
        StringTokenizer patternToken = new StringTokenizer(pattern, ".");
        if (patternToken.hasMoreElements()) {
            String token = (String)patternToken.nextElement();
            if (token.startsWith("*")) {
                if (token.length() > 1) {
                    String delim = token.substring(1);
                    if (dottedName.indexOf(delim) != -1) {
                        String remaining = dottedName.substring(dottedName.indexOf(delim) + delim.length());
                        if (remaining.length() == 0) {
                            return !patternToken.hasMoreElements();
                        }
                        remaining = remaining.substring(1);
                        if (patternToken.hasMoreElements()) {
                            return this.matches(remaining, pattern.substring(token.length() + 1));
                        }
                        return true;
                    }
                    return false;
                }
                if (patternToken.hasMoreElements()) {
                    String delim = (String)patternToken.nextElement();
                    if (dottedName.lastIndexOf(46) == -1) {
                        return delim.equals("*");
                    }
                    if (dottedName.contains(delim)) {
                        String remaining = dottedName.substring(dottedName.lastIndexOf(delim));
                        return this.matches(remaining, pattern.substring(token.length() + 1));
                    }
                    return false;
                }
                return true;
            }
            String delim = token.lastIndexOf("*") != -1 ? token.substring(0, token.lastIndexOf("*")) : token;
            if (dottedName.startsWith(delim)) {
                if (patternToken.hasMoreElements()) {
                    if (dottedName.length() <= delim.length() + 1) {
                        return pattern.substring(token.length() + 1).equals("*");
                    }
                    String remaining = dottedName.substring(delim.length() + 1);
                    return this.matches(remaining, pattern.substring(token.length() + 1));
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public TreeNode[] getAliasedParent(Domain domain, String prefix) throws ComponentException {
        String newPrefix;
        String name;
        if (prefix.indexOf(46) != -1) {
            name = prefix.substring(0, prefix.indexOf(46));
            newPrefix = prefix.substring(name.length() + 1);
        } else {
            name = prefix;
            newPrefix = "";
        }
        for (Config config : domain.getConfigs().getConfig()) {
            if (!config.getName().equals(name)) continue;
            return new TreeNode[]{new TreeNode(Dom.unwrap(config), newPrefix)};
        }
        Named[] nodes = this.getNamedNodes(domain.getServers().getServer(), domain.getConfigs().getConfig(), name);
        if (nodes == null && domain.getClusters() != null) {
            nodes = this.getNamedNodes(domain.getClusters().getCluster(), domain.getConfigs().getConfig(), name);
        }
        if (nodes != null) {
            TreeNode[] result = new TreeNode[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                result[i] = new TreeNode(Dom.unwrap((ConfigBeanProxy)((Object)nodes[i])), newPrefix);
            }
            return result;
        }
        return new TreeNode[]{new TreeNode(Dom.unwrap(domain), prefix)};
    }

    public Named[] getNamedNodes(List<? extends Named> target, List<? extends Named> references, String name) {
        for (Named named : target) {
            if (!named.getName().equals(name)) continue;
            if (named instanceof ReferenceContainer) {
                for (Named named2 : references) {
                    if (!named2.getName().equals(((ReferenceContainer)((Object)named)).getReference())) continue;
                    return new Named[]{named, named2};
                }
                continue;
            }
            return new Named[]{named};
        }
        return null;
    }

    static final class TreeNode {
        final Dom node;
        final String relativeName;

        public TreeNode(Dom node, String name) {
            this.node = node;
            this.relativeName = name;
        }
    }
}

