/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.deployment;

import com.sun.enterprise.config.serverbeans.ApplicationConfig;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.admin.CommandRunner;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="deploy")
@I18n(value="deploy.command")
@Scoped(value=PerLookup.class)
public class DeployCommand
extends ApplicationLifecycle
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeployCommand.class);
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    CommandRunner commandRunner;
    @Param(name="name", optional=true)
    String name = null;
    @Param(name="contextroot", optional=true)
    String contextRoot = null;
    @Param(name="virtualservers", optional=true)
    @I18n(value="virtualservers")
    String virtualservers = null;
    @Param(name="libraries", optional=true)
    String libraries = null;
    @Param(optional=true, defaultValue="false")
    Boolean force;
    @Param(name="precompilejsp", optional=true, defaultValue="false")
    Boolean precompilejsp;
    @Param(optional=true, defaultValue="false")
    Boolean verify;
    @Param(optional=true)
    String retrieve = null;
    @Param(optional=true)
    String dbvendorname = null;
    @Param(optional=true)
    Boolean createtables;
    @Param(optional=true)
    Boolean dropandcreatetables;
    @Param(optional=true)
    Boolean uniquetablenames;
    @Param(name="deploymentplan", optional=true)
    File deploymentplan = null;
    @Param(name="enabled", optional=true, defaultValue="true")
    Boolean enabled;
    @Param(optional=true, defaultValue="false")
    Boolean generatermistubs;
    @Param(optional=true, defaultValue="false")
    Boolean availabilityenabled;
    @Param(optional=true)
    String target = "server";
    @Param(optional=true, defaultValue="false")
    Boolean keepreposdir;
    @Inject
    Domain domain;
    @Param(primary=true)
    File path;
    private List<ApplicationConfig> appConfigList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(AdminCommandContext context) {
        block54: {
            block46: {
                block53: {
                    block45: {
                        block52: {
                            block43: {
                                block51: {
                                    block42: {
                                        operationStartTime = Calendar.getInstance().getTimeInMillis();
                                        parameters = context.getCommandParameters();
                                        report = context.getActionReport();
                                        file = this.choosePathFile(context);
                                        if (!file.exists()) {
                                            report.setMessage(DeployCommand.localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
                                            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                            return;
                                        }
                                        this.deploymentplan = this.chooseDeploymentPlanFile(context);
                                        if (this.snifferManager.hasNoSniffers()) {
                                            msg = DeployCommand.localStrings.getLocalString("nocontainer", "No container services registered, done...");
                                            report.failure(this.logger, msg);
                                            return;
                                        }
                                        try {
                                            archive = this.archiveFactory.openArchive(file);
                                        }
                                        catch (IOException e) {
                                            report.failure(this.logger, "Error opening deployable artifact : " + file.getAbsolutePath(), e);
                                            return;
                                        }
                                        expansionDir = null;
                                        try {
                                            try {
                                                block47: {
                                                    archiveHandler = this.getArchiveHandler(archive);
                                                    if (archiveHandler == null) {
                                                        report.failure(this.logger, DeployCommand.localStrings.getLocalString("deploy.unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{file.getName()}));
                                                        var20_12 = null;
                                                        break block42;
                                                    }
                                                    if (this.name == null) {
                                                        this.name = archiveHandler.getDefaultApplicationName(archive);
                                                        parameters.put("name", this.name);
                                                    }
                                                    if (parameters.containsKey("deploymentplan")) {
                                                        parameters.put("deploymentplan", this.deploymentplan.getAbsolutePath());
                                                    }
                                                    this.handleRedeploy(this.name, report, parameters);
                                                    if (!this.keepreposdir.booleanValue()) {
                                                        FileUtils.whack(new File(this.env.getApplicationRepositoryPath(), this.name));
                                                    }
                                                    parameters.put("enabled", this.enabled.toString());
                                                    source = new File(archive.getURI().getSchemeSpecificPart());
                                                    isDirectoryDeployed = true;
                                                    if (source.isDirectory()) break block47;
                                                    isDirectoryDeployed = false;
                                                    expansionDir = new File(this.domain.getApplicationRoot(), this.name);
                                                    if (!expansionDir.mkdirs()) {
                                                        report.failure(this.logger, DeployCommand.localStrings.getLocalString("deploy.cannotcreateexpansiondir", "Error while creating directory for jar expansion: {0}", new Object[]{expansionDir}));
                                                        expansionDir = null;
                                                        break block43;
                                                    }
                                                    try {
                                                        archiveHandler.expand(archive, this.archiveFactory.createArchive(expansionDir));
                                                        try {
                                                            archive.close();
                                                        }
                                                        catch (IOException e) {
                                                            report.failure(this.logger, DeployCommand.localStrings.getLocalString("deploy.errorclosingarchive", "Error while closing deployable artifact {0}", new Object[]{file.getAbsolutePath()}), e);
                                                            var20_14 = null;
                                                            try {
                                                                archive.close();
                                                            }
                                                            catch (IOException e) {
                                                                this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                                                            }
                                                            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                                                this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                                                                return;
                                                            }
                                                            if (expansionDir == null) return;
                                                            FileUtils.whack(expansionDir);
                                                            return;
                                                        }
                                                    }
                                                    catch (IOException e) {
                                                        block48: {
                                                            report.failure(this.logger, DeployCommand.localStrings.getLocalString("deploy.errorexpandingjar", "Error while expanding archive file"), e);
                                                            var20_15 = null;
                                                            ** try [egrp 6[TRYBLOCK] [18 : 892->902)] { 
lbl79:
                                                            // 1 sources

                                                            archive.close();
                                                            break block48;
lbl81:
                                                            // 1 sources

                                                            catch (IOException e) {
                                                                this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                                                            }
                                                        }
                                                        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                                            this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                                                            return;
                                                        }
                                                        if (expansionDir == null) return;
                                                        FileUtils.whack(expansionDir);
                                                        return;
                                                    }
                                                    {
                                                        file = expansionDir;
                                                        archive = this.archiveFactory.openArchive(expansionDir);
                                                    }
                                                }
                                                if ((appSniffers = this.snifferManager.getSniffers(archive, cloader = archiveHandler.getClassLoader(parentCL = this.snifferManager.createSnifferParentCL(null), archive))).size() == 0) {
                                                    report.failure(this.logger, DeployCommand.localStrings.getLocalString("deploy.unknownmoduletpe", "Module type not recognized"));
                                                    break block45;
                                                }
                                                sourceArchive = archive;
                                                deploymentContext = new DeploymentContextImpl(this.logger, sourceArchive, parameters, this.env);
                                                deploymentContext.setClassLoader(cloader);
                                                this.deleteContainerMetaInfo(deploymentContext);
                                                moduleProps = deploymentContext.getProps();
                                                moduleProps.setProperty("name", this.name);
                                                moduleProps.setProperty("location", deploymentContext.getSource().getURI().toURL().toString());
                                                moduleProps.setProperty("object-type", "user");
                                                if (this.contextRoot != null) {
                                                    moduleProps.setProperty("context-root", this.contextRoot);
                                                }
                                                if (this.libraries != null) {
                                                    moduleProps.setProperty("libraries", this.libraries);
                                                }
                                                moduleProps.setProperty("enabled", this.enabled.toString());
                                                moduleProps.setProperty("directory-deployed", String.valueOf(isDirectoryDeployed));
                                                if (this.virtualservers != null) {
                                                    moduleProps.setProperty("virtual-servers", this.virtualservers);
                                                }
                                                if (this.appConfigList != null) {
                                                    this.addApplicationConfigToProps(moduleProps, this.appConfigList);
                                                }
                                                appInfo = this.deploy(appSniffers, deploymentContext, report);
                                                if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                                                    this.registerAppInDomainXML(appInfo, deploymentContext);
                                                }
                                                break block46;
                                            }
                                            catch (Exception e) {
                                                block49: {
                                                    report.failure(this.logger, "Error during deployment : " + e.getMessage(), e);
                                                    var20_18 = null;
                                                    ** try [egrp 6[TRYBLOCK] [18 : 892->902)] { 
lbl133:
                                                    // 1 sources

                                                    archive.close();
                                                    break block49;
lbl135:
                                                    // 1 sources

                                                    catch (IOException e) {
                                                        this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                                                    }
                                                }
                                                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                                    this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                                                    return;
                                                }
                                                if (expansionDir == null) return;
                                                FileUtils.whack(expansionDir);
                                                return;
                                            }
                                        }
                                        catch (Throwable var19_39) {
                                            block50: {
                                                var20_19 = null;
                                                ** try [egrp 6[TRYBLOCK] [18 : 892->902)] { 
lbl149:
                                                // 1 sources

                                                archive.close();
                                                break block50;
lbl151:
                                                // 1 sources

                                                catch (IOException e) {
                                                    this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                                                }
                                            }
                                            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                                this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                                                throw var19_39;
                                            }
                                            if (expansionDir == null) throw var19_39;
                                            FileUtils.whack(expansionDir);
                                            throw var19_39;
                                        }
                                    }
                                    ** try [egrp 6[TRYBLOCK] [18 : 892->902)] { 
lbl163:
                                    // 1 sources

                                    archive.close();
                                    break block51;
lbl165:
                                    // 1 sources

                                    catch (IOException e) {
                                        this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                                    }
                                }
                                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                    this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                                    return;
                                }
                                if (expansionDir == null) return;
                                FileUtils.whack(expansionDir);
                                return;
                            }
                            var20_13 = null;
                            ** try [egrp 6[TRYBLOCK] [18 : 892->902)] { 
lbl178:
                            // 1 sources

                            archive.close();
                            break block52;
lbl180:
                            // 1 sources

                            catch (IOException e) {
                                this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                            }
                        }
                        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                            this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                            return;
                        }
                        if (expansionDir == null) return;
                        FileUtils.whack(expansionDir);
                        return;
                    }
                    var20_16 = null;
                    ** try [egrp 6[TRYBLOCK] [18 : 892->902)] { 
lbl193:
                    // 1 sources

                    archive.close();
                    break block53;
lbl195:
                    // 1 sources

                    catch (IOException e) {
                        this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                    }
                }
                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                    this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                    return;
                }
                if (expansionDir == null) return;
                FileUtils.whack(expansionDir);
                return;
            }
            var20_17 = null;
            ** try [egrp 6[TRYBLOCK] [18 : 892->902)] { 
lbl208:
            // 1 sources

            archive.close();
            break block54;
lbl210:
            // 1 sources

            catch (IOException e) {
                this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
            }
        }
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
            return;
        }
        if (expansionDir == null) return;
        FileUtils.whack(expansionDir);
    }

    private File choosePathFile(AdminCommandContext context) {
        if (context.getUploadedFiles().size() >= 1) {
            return context.getUploadedFiles().get(0);
        }
        return this.path;
    }

    private File chooseDeploymentPlanFile(AdminCommandContext context) {
        if (context.getUploadedFiles().size() >= 2) {
            return context.getUploadedFiles().get(1);
        }
        return this.deploymentplan;
    }

    private void handleRedeploy(String name, ActionReport report, Properties parameters) throws Exception {
        boolean isRegistered = this.isRegistered(name);
        if (isRegistered && !this.force.booleanValue()) {
            String msg = localStrings.getLocalString("application.alreadyreg.redeploy", "Application {0} already registered, please use deploy --force=true to redeploy", name);
            throw new Exception(msg);
        }
        if (isRegistered && this.force.booleanValue()) {
            this.settingsFromDomainXML(parameters);
            Properties undeployParam = new Properties();
            undeployParam.put("name", name);
            undeployParam.put("keepreposdir", this.keepreposdir.toString());
            ActionReport subReport = report.addSubActionsReport();
            this.commandRunner.doCommand("undeploy", undeployParam, subReport);
        }
    }

    private void settingsFromDomainXML(Properties parameters) {
        if (this.name != null) {
            if (this.contextRoot == null) {
                this.contextRoot = ConfigBeansUtilities.getContextRoot(this.name);
                if (this.contextRoot != null) {
                    parameters.put("previous_contextroot", this.contextRoot);
                }
            }
            if (this.libraries == null) {
                this.libraries = ConfigBeansUtilities.getLibraries(this.name);
                if (this.libraries != null) {
                    parameters.put("libraries", this.libraries);
                }
            }
            if (this.virtualservers == null) {
                this.virtualservers = ConfigBeansUtilities.getVirtualServers(this.target, this.name);
                if (this.virtualservers != null) {
                    parameters.put("virtualservers", this.virtualservers);
                }
            }
            this.appConfigList = ConfigBeansUtilities.getApplicationConfig(this.target, this.name);
        }
    }

    private void addApplicationConfigToProps(Properties moduleProps, List<ApplicationConfig> appConfigList) {
        for (ApplicationConfig appConfig : appConfigList) {
            String appConfigName = "appConfig." + appConfig.getType();
            String appConfigValue = appConfig.getConfig();
            moduleProps.setProperty(appConfigName, appConfigValue);
        }
    }
}

