/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class APIClassLoaderServiceImpl
implements PostConstruct {
    private ClassLoader APIClassLoader;
    @Inject
    ModulesRegistry mr;
    private static final String APIExporterModuleName = "GlassFish-Application-Common-Module";
    static final Logger logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private Module APIModule;

    public void postConstruct() {
        try {
            this.createAPIClassLoader();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createAPIClassLoader() throws IOException {
        final Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        attrs.putValue("Bundle-SymbolicName", APIExporterModuleName);
        attrs.putValue("DynamicImport-Package", "*");
        attrs.putValue("Bundle-ManifestVersion", "2");
        attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        final File f = File.createTempFile(APIExporterModuleName, ".jar");
        f.deleteOnExit();
        JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(f), manifest);
        jos.close();
        ModuleDefinition md = new ModuleDefinition(){
            private ModuleMetadata metadata = new ModuleMetadata();

            public String getName() {
                return APIClassLoaderServiceImpl.APIExporterModuleName;
            }

            public String[] getPublicInterfaces() {
                return new String[0];
            }

            public ModuleDependency[] getDependencies() {
                return new ModuleDependency[0];
            }

            public URI[] getLocations() {
                return new URI[]{f.toURI()};
            }

            public String getVersion() {
                return null;
            }

            public String getImportPolicyClassName() {
                return null;
            }

            public String getLifecyclePolicyClassName() {
                return null;
            }

            public Manifest getManifest() {
                return manifest;
            }

            public ModuleMetadata getMetadata() {
                return this.metadata;
            }
        };
        this.APIModule = this.mr.add(md);
        this.APIClassLoader = this.APIModule.getClassLoader();
        logger.logp(Level.INFO, "APIClassLoaderService", "createAPIClassLoader", "APIClassLoader = {0}", new Object[]{this.APIClassLoader});
    }

    public ClassLoader getAPIClassLoader() {
        return this.APIClassLoader;
    }
}

