/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationConfig;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.common_impl.Tokenizer;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.server.ContainerStarter;
import com.sun.enterprise.v3.server.ProgressTracker;
import com.sun.enterprise.v3.server.SnifferManager;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ContainerInfo;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ApplicationLifecycle {
    @Inject
    protected SnifferManager snifferManager;
    @Inject
    Habitat habitat;
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    public ApplicationRegistry appRegistry;
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    protected GrizzlyService adapter;
    @Inject
    protected ArchiveFactory archiveFactory;
    @Inject
    protected Applications applications;
    @Inject
    protected Server server;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    ClassLoaderHierarchy clh;
    protected Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    protected <T extends Container, U extends ApplicationContainer> Deployer<T, U> getDeployer(ContainerInfo<T, U> containerInfo) {
        return containerInfo.getDeployer();
    }

    public ArchiveHandler getArchiveHandler(ReadableArchive archive) throws IOException {
        for (ArchiveHandler handler : this.habitat.getAllByContract(ArchiveHandler.class)) {
            if (!handler.handles(archive)) continue;
            return handler;
        }
        return null;
    }

    protected ClassLoader createApplicationParentCL(ClassLoader parent, DeploymentContextImpl context, Collection<Deployer> deployers) throws ResolveError {
        String requestedWiring;
        String importedBundles;
        Manifest m;
        ArrayList<ModuleDefinition> defs;
        block7: {
            ReadableArchive source = context.getSource();
            defs = new ArrayList<ModuleDefinition>();
            m = null;
            try {
                m = source.getManifest();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Cannot load application's manifest file :", e.getMessage());
                if (!this.logger.isLoggable(Level.FINE)) break block7;
                this.logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        if (m != null && (importedBundles = m.getMainAttributes().getValue("HK2-Import-Bundles")) != null) {
            for (String token : new Tokenizer(importedBundles, ",")) {
                com.sun.enterprise.module.Module module = this.modulesRegistry.makeModuleFor(token, null);
                if (module == null) continue;
                defs.add(module.getModuleDefinition());
            }
        }
        if (m != null && (requestedWiring = m.getMainAttributes().getValue("GlassFish-require-services")) != null) {
            for (String token : new Tokenizer(requestedWiring, ",")) {
                for (Inhabitant<?> impl : this.habitat.getInhabitantsByContract(token)) {
                    com.sun.enterprise.module.Module wiredBundle = this.modulesRegistry.find(impl.get().getClass());
                    if (wiredBundle == null) continue;
                    defs.add(wiredBundle.getModuleDefinition());
                }
            }
        }
        return this.modulesRegistry.getModulesClassLoader(parent, defs);
    }

    public ApplicationInfo deploy(Iterable<Sniffer> sniffers, final DeploymentContextImpl context, ActionReport report) {
        final ApplicationLifecycle myself = this;
        ProgressTracker tracker = new ProgressTracker(){

            public void actOn(Logger logger) {
                myself.stopModules(this.get("started", ModuleInfo.class), logger);
                myself.unload(this.get(ModuleInfo.class), context);
                myself.clean(this.get(Deployer.class), context);
                ApplicationLifecycle.this.stopContainers(this.get(ContainerInfo.class), logger);
            }
        };
        try {
            LinkedList<ContainerInfo> sortedContainerInfos = this.setupContainerInfos(sniffers, context, report, tracker);
            if (sortedContainerInfos == null || sortedContainerInfos.isEmpty()) {
                report.failure(this.logger, "There is no installed container capable of handling this application", null);
                tracker.actOn(this.logger);
                return null;
            }
            ApplicationInfo appInfo = this.prepare(sortedContainerInfos, context, report, tracker);
            if ((appInfo = this.load(sortedContainerInfos, appInfo, context, report, tracker)) == null) {
                report.failure(this.logger, "Exception while loading the app", null);
                tracker.actOn(this.logger);
                return null;
            }
            if (Boolean.valueOf(context.getCommandParameters().getProperty("enabled")).booleanValue()) {
                this.startModules(appInfo, context, report, tracker);
            }
            return appInfo;
        }
        catch (Exception e) {
            report.failure(this.logger, "Exception while deploying the app", e);
            tracker.actOn(this.logger);
            return null;
        }
    }

    public ApplicationInfo enable(Iterable<Sniffer> sniffers, DeploymentContextImpl context, ActionReport report) {
        final ApplicationLifecycle myself = this;
        String appName = context.getCommandParameters().getProperty("component");
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            ProgressTracker tracker = new ProgressTracker(){

                public void actOn(Logger logger) {
                    myself.stopModules(this.get("started", ModuleInfo.class), logger);
                }
            };
            try {
                ArrayList<Deployer> deployers = new ArrayList<Deployer>();
                for (Sniffer sniffer : sniffers) {
                    ContainerInfo containerInfo = this.containerRegistry.getContainer(sniffer.getContainersNames()[0]);
                    Deployer deployer = this.getDeployer(containerInfo);
                    deployers.add(deployer);
                }
                ClassLoader applibCL = this.clh.getAppLibClassLoader(appName, this.getAppLibs(context));
                ClassLoader parentCL = this.createApplicationParentCL(applibCL, context, deployers);
                ArchiveHandler handler = this.getArchiveHandler(context.getSource());
                context.setClassLoader(handler.getClassLoader(parentCL, context.getSource()));
                return this.startModules(appInfo, context, report, tracker);
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while enabling the app", e);
                tracker.actOn(this.logger);
                return null;
            }
        }
        return this.deploy(sniffers, context, report);
    }

    public void disable(String appName, ActionReport report) {
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            this.stopModules(Arrays.asList(appInfo.getModuleInfos()), this.logger);
        }
    }

    public boolean suspend(String appName, ActionReport report) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = this.suspendModules(Arrays.asList(appInfo.getModuleInfos()), this.logger);
        }
        return isSuccess;
    }

    public boolean resume(String appName, ActionReport report) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = this.resumeModules(Arrays.asList(appInfo.getModuleInfos()), this.logger);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedList<ContainerInfo> setupContainerInfos(Iterable<Sniffer> sniffers, DeploymentContextImpl context, ActionReport report, ProgressTracker tracker) throws Exception {
        for (Sniffer sniffer : sniffers) {
            if (sniffer.getContainersNames() == null || sniffer.getContainersNames().length == 0) {
                report.failure(this.logger, "no container associated with application of type : " + sniffer.getModuleType(), null);
                return null;
            }
            com.sun.enterprise.module.Module snifferModule = this.modulesRegistry.find(sniffer.getClass());
            if (snifferModule == null) {
                report.failure(this.logger, "cannot find container module from service implementation " + sniffer.getClass(), null);
                return null;
            }
            ContainerInfo containerInfo = this.containerRegistry.getContainer(sniffer.getContainersNames()[0]);
            if (containerInfo != null) continue;
            ContainerRegistry containerRegistry = this.containerRegistry;
            synchronized (containerRegistry) {
                if (this.containerRegistry.getContainer(sniffer.getContainersNames()[0]) == null) {
                    Collection<ContainerInfo> collection = this.setupContainer(sniffer, snifferModule, this.logger, report);
                    if (collection == null || collection.size() == 0) {
                        String msg = "Cannot start container(s) associated to application of type : " + sniffer.getModuleType();
                        report.failure(this.logger, msg, null);
                        throw new Exception(msg);
                    }
                    tracker.addAll(ContainerInfo.class, collection);
                }
            }
        }
        if (!this.startContainers(tracker.get(ContainerInfo.class), this.logger, report)) {
            String msg = "Failed to start containers";
            report.failure(this.logger, msg, null);
            throw new Exception(msg);
        }
        LinkedList<ContainerInfo> sortedContainerInfos = new LinkedList<ContainerInfo>();
        HashMap metaDataProvided = new HashMap();
        HashMap metaDataRequired = new HashMap();
        HashMap containerInfosByDeployers = new HashMap();
        for (Sniffer sniffer : sniffers) {
            for (String containerName : sniffer.getContainersNames()) {
                ContainerInfo containerInfo = this.containerRegistry.getContainer(containerName);
                ClassLoader original = Thread.currentThread().getContextClassLoader();
                try {
                    Class[] provides;
                    Thread.currentThread().setContextClassLoader(containerInfo.getClassLoader());
                    Deployer deployer = this.getDeployer(containerInfo);
                    containerInfosByDeployers.put(deployer, containerInfo);
                    MetaData metadata = deployer.getMetaData();
                    Class[] requires = metadata == null ? null : metadata.requires();
                    Class[] classArray = provides = metadata == null ? null : metadata.provides();
                    if (!(requires != null && requires.length != 0 || provides != null && provides.length != 0)) {
                        sortedContainerInfos.add(containerInfo);
                    } else {
                        for (Class metadataType : metadata.requires()) {
                            LinkedList requesters = (LinkedList)metaDataRequired.get(metadataType);
                            if (requesters == null) {
                                requesters = new LinkedList();
                                metaDataRequired.put(metadataType, requesters);
                            }
                            requesters.add(deployer);
                        }
                    }
                    if (metadata == null) continue;
                    for (Class metadataType : metadata.provides()) {
                        Deployer currentProvidindDeployer = (Deployer)metaDataProvided.get(metadataType);
                        if (currentProvidindDeployer != null) {
                            report.failure(this.logger, "More than one deployer [" + currentProvidindDeployer + ", " + deployer + "] provide same metadata : " + metadataType, null);
                        }
                        metaDataProvided.put(metadataType, deployer);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(original);
                }
            }
        }
        for (Map.Entry entry : metaDataRequired.entrySet()) {
            if (metaDataProvided.containsKey(entry.getKey())) {
                Deployer provider = (Deployer)metaDataProvided.get(entry.getKey());
                sortedContainerInfos.addFirst((ContainerInfo)containerInfosByDeployers.get(provider));
                for (Deployer requester : (List)entry.getValue()) {
                    sortedContainerInfos.add((ContainerInfo)containerInfosByDeployers.get(requester));
                }
                continue;
            }
            report.failure(this.logger, "Deployer " + metaDataRequired.get(entry.getKey()) + " requires " + entry.getKey() + " but no other deployer provides it", null);
            return null;
        }
        return sortedContainerInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationInfo prepare(LinkedList<ContainerInfo> sortedContainerInfos, DeploymentContextImpl context, ActionReport report, ProgressTracker tracker) throws Exception {
        MetaData metadata;
        ArrayList<Deployer> deployers = new ArrayList<Deployer>();
        for (ContainerInfo containerInfo : sortedContainerInfos) {
            Deployer deployer = containerInfo.getDeployer();
            deployers.add(deployer);
        }
        String appName = context.getCommandParameters().getProperty("name");
        ClassLoader applibCL = this.clh.getAppLibClassLoader(appName, this.getAppLibs(context));
        ClassLoader parentCL = this.createApplicationParentCL(applibCL, context, deployers);
        ArchiveHandler handler = this.getArchiveHandler(context.getSource());
        context.setClassLoader(handler.getClassLoader(parentCL, context.getSource()));
        for (ContainerInfo containerInfo : sortedContainerInfos) {
            Deployer deployer = containerInfo.getDeployer();
            ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
            metadata = deployer.getMetaData();
            try {
                Thread.currentThread().setContextClassLoader(containerInfo.getContainer().getClass().getClassLoader());
                try {
                    if (metadata == null) continue;
                    for (Class provide : metadata.provides()) {
                        context.addModuleMetaData(deployer.loadMetaData(provide, context));
                    }
                }
                catch (Exception e) {
                    report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", e);
                    throw e;
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCL);
            }
        }
        boolean invalidated = false;
        for (ContainerInfo containerInfo : sortedContainerInfos) {
            Deployer deployer = containerInfo.getDeployer();
            metadata = deployer.getMetaData();
            ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(containerInfo.getContainer().getClass().getClassLoader());
                try {
                    deployer.prepare(context);
                    if (metadata != null && metadata.invalidatesClassLoader()) {
                        invalidated = true;
                    }
                    ModuleInfo moduleInfo = new ModuleInfo(containerInfo, null);
                    tracker.add(ModuleInfo.class, moduleInfo);
                    tracker.add(Deployer.class, deployer);
                }
                catch (Exception e) {
                    report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", e);
                    throw e;
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCL);
            }
        }
        if (invalidated) {
            context.setClassLoader(handler.getClassLoader(parentCL, context.getSource()));
            try {
                InstrumentableClassLoader icl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(context.getClassLoader());
                for (ClassFileTransformer transformer : context.getTransformers()) {
                    icl.addTransformer(transformer);
                }
            }
            catch (Exception e) {
                report.failure(this.logger, "Class loader used for loading application cannot handle bytecode enhancer", e);
                throw e;
            }
        }
        for (ModuleDefinition def : context.getPublicAPIs()) {
            com.sun.enterprise.module.Module module = this.modulesRegistry.makeModuleFor(def.getName(), def.getVersion());
            if (module == null) continue;
            this.logger.severe("TODO : add dependencies on the fly");
        }
        ApplicationInfo appInfo = new ApplicationInfo(context.getSource(), appName, tracker.get(ModuleInfo.class).toArray(new ModuleInfo[tracker.get(ModuleInfo.class).size()]));
        this.appRegistry.add(appName, appInfo);
        return appInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationInfo load(LinkedList<ContainerInfo> sortedContainerInfos, ApplicationInfo appInfo, DeploymentContextImpl context, ActionReport report, ProgressTracker tracker) throws Exception {
        List<ModuleInfo> moduleInfos = tracker.get(ModuleInfo.class);
        block5: for (ContainerInfo containerInfo : sortedContainerInfos) {
            Deployer deployer = containerInfo.getDeployer();
            ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(containerInfo.getContainer().getClass().getClassLoader());
                try {
                    Object appCtr = deployer.load(containerInfo.getContainer(), context);
                    if (appCtr == null) {
                        String msg = "Cannot load application in " + containerInfo.getContainer().getName() + " container";
                        report.failure(this.logger, msg, null);
                        throw new Exception(msg);
                    }
                    if (moduleInfos.isEmpty()) {
                        ModuleInfo moduleInfo = new ModuleInfo(containerInfo, (ApplicationContainer)appCtr);
                        tracker.add(ModuleInfo.class, moduleInfo);
                        continue;
                    }
                    for (ModuleInfo moduleInfo : moduleInfos) {
                        if (!moduleInfo.getContainerInfo().getContainer().getName().equals(containerInfo.getContainer().getName())) continue;
                        moduleInfo.setApplicationContainer((ApplicationContainer)appCtr);
                        continue block5;
                    }
                }
                catch (Exception e) {
                    report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", e);
                    throw e;
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCL);
            }
        }
        if (appInfo == null) {
            String appName = context.getCommandParameters().getProperty("name");
            appInfo = new ApplicationInfo(context.getSource(), appName, tracker.get(ModuleInfo.class).toArray(new ModuleInfo[tracker.get(ModuleInfo.class).size()]));
        }
        return appInfo;
    }

    public ApplicationInfo startModules(ApplicationInfo appInfo, DeploymentContextImpl context, ActionReport report, ProgressTracker tracker) throws Exception {
        for (ModuleInfo module : appInfo.getModuleInfos()) {
            try {
                module.getApplicationContainer().start(context.getClassLoader());
                tracker.add("started", ModuleInfo.class, module);
                try {
                    Adapter appAdapter = (Adapter)Adapter.class.cast(module.getApplicationContainer());
                    this.adapter.registerEndpoint(appAdapter.getContextRoot(), null, appAdapter, module.getApplicationContainer());
                }
                catch (ClassCastException e) {}
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while invoking " + module.getApplicationContainer().getClass() + " start method", e);
                throw e;
            }
        }
        return appInfo;
    }

    protected void stopModules(Iterable<ModuleInfo> modules, Logger logger) {
        for (ModuleInfo module : modules) {
            try {
                module.getApplicationContainer().stop();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot stop module " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
    }

    protected boolean suspendModules(Iterable<ModuleInfo> modules, Logger logger) {
        boolean isSuccess = true;
        for (ModuleInfo module : modules) {
            try {
                module.getApplicationContainer().suspend();
            }
            catch (Exception e) {
                isSuccess = false;
                logger.log(Level.SEVERE, "Error suspending module " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
        return isSuccess;
    }

    protected boolean resumeModules(Iterable<ModuleInfo> modules, Logger logger) {
        boolean isSuccess = true;
        for (ModuleInfo module : modules) {
            try {
                module.getApplicationContainer().resume();
            }
            catch (Exception e) {
                isSuccess = false;
                logger.log(Level.SEVERE, "Error resuming module " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
        return isSuccess;
    }

    protected void unload(Iterable<ModuleInfo> modules, DeploymentContext context) {
        for (ModuleInfo module : modules) {
            try {
                module.getContainerInfo().getDeployer().unload(module.getApplicationContainer(), context);
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "Failed to unload from container type : " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
    }

    protected void clean(Iterable<Deployer> deployers, DeploymentContext context) {
        for (Deployer deployer : deployers) {
            try {
                deployer.clean(context);
            }
            catch (Throwable e) {
                context.getLogger().log(Level.INFO, "Deployer.clean failed for " + deployer, e);
            }
        }
    }

    protected Collection<ContainerInfo> setupContainer(Sniffer sniffer, com.sun.enterprise.module.Module snifferModule, Logger logger, ActionReport report) {
        ContainerStarter starter = this.habitat.getComponent(ContainerStarter.class);
        Collection<ContainerInfo> containersInfo = starter.startContainer(sniffer, snifferModule);
        if (containersInfo == null || containersInfo.size() == 0) {
            report.failure(logger, "Cannot start container(s) associated to application of type : " + sniffer.getModuleType(), null);
            return null;
        }
        return containersInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean startContainers(Collection<ContainerInfo> containersInfo, Logger logger, ActionReport report) {
        for (ContainerInfo containerInfo : containersInfo) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            try {
                Object container;
                Thread.currentThread().setContextClassLoader(containerInfo.getClassLoader());
                try {
                    container = containerInfo.getContainer();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Cannot start container  " + containerInfo.getSniffer().getModuleType(), e);
                    boolean bl = false;
                    Thread.currentThread().setContextClassLoader(original);
                    return bl;
                }
                Class<? extends Deployer> deployerClass = container.getDeployer();
                try {
                    Deployer deployer = this.habitat.getComponent(deployerClass);
                    containerInfo.setDeployer(deployer);
                }
                catch (ComponentException e) {
                    report.failure(logger, "Cannot instantiate or inject " + deployerClass, e);
                    this.stopContainer(logger, containerInfo);
                    boolean bl = false;
                    Thread.currentThread().setContextClassLoader(original);
                    return bl;
                }
                catch (ClassCastException e) {
                    this.stopContainer(logger, containerInfo);
                    report.failure(logger, deployerClass + " does not implement " + " the org.jvnet.glassfish.api.deployment.Deployer interface", e);
                    boolean bl = false;
                    Thread.currentThread().setContextClassLoader(original);
                    return bl;
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        return true;
    }

    protected void stopContainers(Iterable<ContainerInfo> ctrInfos, Logger logger) {
        for (ContainerInfo ctrInfo : ctrInfos) {
            try {
                this.stopContainer(logger, ctrInfo);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Cannot release container " + ctrInfo.getSniffer().getModuleType(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopContainer(Logger logger, ContainerInfo info) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Inhabitant<?> i;
            Thread.currentThread().setContextClassLoader(info.getContainer().getClass().getClassLoader());
            if (info.getDeployer() != null && (i = this.habitat.getInhabitantByType(info.getDeployer().getClass())) != null) {
                i.release();
            }
            if (info.getContainer() != null && (i = this.habitat.getInhabitantByType(info.getContainer().getClass())) != null) {
                i.release();
            }
            this.containerRegistry.removeContainer(info);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Container " + info.getContainer().getName() + " stopped");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected ApplicationInfo unload(String appName, DeploymentContext context, ActionReport report) {
        ApplicationInfo info = this.appRegistry.get(appName);
        if (info == null) {
            report.failure(context.getLogger(), "Application " + appName + " not registered", null);
            return null;
        }
        for (ModuleInfo moduleInfo : info.getModuleInfos()) {
            this.unloadModule(moduleInfo, info, context, report);
        }
        return info;
    }

    public void undeploy(String appName, DeploymentContext context, ActionReport report) {
        ApplicationInfo info = this.unload(appName, context, report);
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            for (ModuleInfo moduleInfo : info.getModuleInfos()) {
                try {
                    moduleInfo.getContainerInfo().getDeployer().clean(context);
                }
                catch (Exception e) {
                    report.failure(context.getLogger(), "Exception while cleaning application artifacts", e);
                    return;
                }
            }
        }
        this.appRegistry.remove(appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unloadModule(ModuleInfo module, ApplicationInfo info, DeploymentContext context, ActionReport report) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            if (module.getApplicationContainer().getClassLoader() != null) {
                Thread.currentThread().setContextClassLoader(module.getApplicationContainer().getClassLoader());
            } else {
                Thread.currentThread().setContextClassLoader(module.getContainerInfo().getContainer().getClass().getClassLoader());
            }
            try {
                Adapter appAdapter = (Adapter)Adapter.class.cast(module.getApplicationContainer());
                this.adapter.unregisterEndpoint(appAdapter.getContextRoot(), module.getApplicationContainer());
            }
            catch (EndpointRegistrationException e) {
                this.logger.log(Level.WARNING, "Exception during unloading module '" + module + "'", e);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            try {
                if (!module.getApplicationContainer().stop()) {
                    this.logger.severe("Cannot stop application " + info.getName() + " in container " + module.getContainerInfo().getSniffer().getModuleType());
                }
            }
            catch (Exception e) {
                report.failure(context.getLogger(), "Exception while stopping the application", e);
                boolean bl = false;
                Thread.currentThread().setContextClassLoader(original);
                return bl;
            }
            Deployer deployer = module.getContainerInfo().getDeployer();
            try {
                deployer.unload(module.getApplicationContainer(), context);
            }
            catch (Exception e) {
                report.failure(context.getLogger(), "Exception while shutting down application container", e);
                boolean bl = false;
                Thread.currentThread().setContextClassLoader(original);
                return bl;
            }
            module.getContainerInfo().remove(info);
            boolean bl = true;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected void registerAppInDomainXML(final ApplicationInfo applicationInfo, DeploymentContext context) throws TransactionFailure {
        final Properties moduleProps = context.getProps();
        ConfigSupport.apply(new ConfigCode(){

            /*
             * WARNING - void declaration
             */
            public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                void var7_10;
                Applications apps = (Applications)params[0];
                Server servr = (Server)params[1];
                Application app = ConfigSupport.createChildOf(params[0], Application.class);
                app.setName(moduleProps.getProperty("name"));
                app.setLocation(moduleProps.getProperty("location"));
                app.setObjectType(moduleProps.getProperty("object-type"));
                app.setEnabled(String.valueOf(true));
                if (moduleProps.getProperty("context-root") != null) {
                    app.setContextRoot(moduleProps.getProperty("context-root"));
                }
                if (moduleProps.getProperty("libraries") != null) {
                    app.setLibraries(moduleProps.getProperty("libraries"));
                }
                app.setDirectoryDeployed(moduleProps.getProperty("directory-deployed"));
                apps.getModules().add(app);
                ModuleInfo[] arr$ = applicationInfo.getModuleInfos();
                int n = arr$.length;
                boolean bl = false;
                while (var7_10 < n) {
                    ModuleInfo moduleInfo = arr$[var7_10];
                    Engine engine = ConfigSupport.createChildOf(app, Engine.class);
                    app.getEngine().add(engine);
                    engine.setSniffer(moduleInfo.getContainerInfo().getSniffer().getModuleType());
                    ++var7_10;
                }
                for (String string : moduleProps.keySet()) {
                    if (string.equals("name") || string.equals("location") || string.equals("enabled") || string.equals("context-root") || string.equals("libraries") || string.equals("object-type") || string.equals("virtual-servers") || string.equals("directory-deployed") || string.startsWith("appConfig")) continue;
                    Property property = ConfigSupport.createChildOf(app, Property.class);
                    app.getProperty().add(property);
                    property.setName(string);
                    property.setValue(moduleProps.getProperty(string));
                }
                ApplicationRef appRef = ConfigSupport.createChildOf(params[1], ApplicationRef.class);
                appRef.setRef(moduleProps.getProperty("name"));
                if (moduleProps.getProperty("virtual-servers") != null) {
                    appRef.setVirtualServers(moduleProps.getProperty("virtual-servers"));
                }
                appRef.setEnabled(moduleProps.getProperty("enabled"));
                for (String string : moduleProps.keySet()) {
                    if (!string.startsWith("appConfig")) continue;
                    ApplicationConfig appConfig = ConfigSupport.createChildOf(appRef, ApplicationConfig.class);
                    appRef.getApplicationConfig().add(appConfig);
                    appConfig.setType(string.substring(string.indexOf(".") + 1));
                    appConfig.setConfig(moduleProps.getProperty(string));
                }
                servr.getApplicationRef().add(appRef);
                return Boolean.TRUE;
            }
        }, this.applications, this.server);
    }

    protected void unregisterAppFromDomainXML(final String appName) throws TransactionFailure {
        ConfigSupport.apply(new ConfigCode(){

            public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                Applications apps = (Applications)params[0];
                Server servr = (Server)params[1];
                for (ApplicationRef appRef : servr.getApplicationRef()) {
                    if (!appRef.getRef().equals(appName)) continue;
                    ((Server)params[1]).getApplicationRef().remove(appRef);
                    break;
                }
                for (Module module : apps.getModules()) {
                    if (!module.getName().equals(appName)) continue;
                    ((Applications)params[0]).getModules().remove(module);
                    break;
                }
                return Boolean.TRUE;
            }
        }, this.applications, this.server);
    }

    protected void setEnableAttributeInDomainXML(String appName, final boolean newEnabledValue) throws Exception {
        ApplicationRef applicationRef = null;
        for (ApplicationRef appRef : this.server.getApplicationRef()) {
            if (!appRef.getRef().equals(appName)) continue;
            applicationRef = appRef;
            if (Boolean.valueOf(appRef.getEnabled()) != newEnabledValue) break;
            return;
        }
        if (applicationRef == null) {
            throw new Exception("Application Ref not found for " + appName + " in configuration");
        }
        ConfigSupport.apply(new SingleConfigCode<ApplicationRef>(){

            @Override
            public Object run(ApplicationRef param) throws PropertyVetoException, TransactionFailure {
                param.setEnabled(String.valueOf(newEnabledValue));
                return null;
            }
        }, applicationRef);
    }

    protected Properties populateDeployParamsFromDomainXML(Application app, ApplicationRef appRef) {
        if (app == null || appRef == null) {
            return new Properties();
        }
        Properties deploymentParams = new Properties();
        deploymentParams.setProperty("name", app.getName());
        deploymentParams.setProperty("location", app.getLocation());
        deploymentParams.setProperty("enabled", app.getEnabled());
        if (app.getContextRoot() != null) {
            deploymentParams.setProperty("contextroot", app.getContextRoot());
        }
        if (app.getLibraries() != null) {
            deploymentParams.setProperty("libraries", app.getLibraries());
        }
        deploymentParams.setProperty("directorydeployed", app.getDirectoryDeployed());
        if (appRef.getVirtualServers() != null) {
            deploymentParams.setProperty("virtualservers", appRef.getVirtualServers());
        }
        return deploymentParams;
    }

    protected Properties populateDeployPropsFromDomainXML(Application app) {
        if (app == null) {
            return new Properties();
        }
        Properties deploymentProps = new Properties();
        for (Property prop : app.getProperty()) {
            deploymentProps.put(prop.getName(), prop.getValue());
        }
        deploymentProps.setProperty("object-type", app.getObjectType());
        return deploymentProps;
    }

    protected boolean isRegistered(String appName) {
        return ConfigBeansUtilities.getModule(appName) != null;
    }

    protected void deleteContainerMetaInfo(DeploymentContext context) {
        File generatedXmlRoot = context.getScratchDir("xml");
        FileUtils.whack(generatedXmlRoot);
        File generatedEjbRoot = context.getScratchDir("ejb");
        FileUtils.whack(generatedEjbRoot);
        File generatedJspRoot = context.getScratchDir("jsp");
        FileUtils.whack(generatedJspRoot);
    }

    private List<URI> getAppLibs(DeploymentContext context) throws URISyntaxException {
        ArrayList<URI> libURIs = new ArrayList<URI>();
        String libraries = context.getCommandParameters().getProperty("libraries");
        if (libraries != null) {
            URL[] urls;
            for (URL url : urls = this.convertToURL(libraries)) {
                libURIs.add(url.toURI());
            }
        }
        return libURIs;
    }

    private URL[] convertToURL(String librariesStr) {
        if (librariesStr == null) {
            return null;
        }
        String[] librariesStrArray = librariesStr.split(",");
        if (librariesStrArray == null) {
            return null;
        }
        URL[] urls = new URL[librariesStrArray.length];
        String appLibsDir = this.env.getLibPath() + File.separator + "applibs";
        int i = 0;
        for (String libraryStr : librariesStrArray) {
            try {
                File f = new File(libraryStr);
                if (!f.isAbsolute()) {
                    f = new File(appLibsDir, libraryStr);
                }
                URL url = f.toURL();
                urls[i++] = url;
            }
            catch (MalformedURLException malEx) {
                this.logger.log(Level.WARNING, "Cannot convert classpath to URL", libraryStr);
                this.logger.log(Level.WARNING, malEx.getMessage(), malEx);
            }
        }
        return urls;
    }
}

