/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.CookieProperties;
import com.sun.enterprise.deployment.runtime.web.LocaleCharsetInfo;
import com.sun.enterprise.deployment.runtime.web.LocaleCharsetMap;
import com.sun.enterprise.deployment.runtime.web.SessionConfig;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.deployment.runtime.web.SessionProperties;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import com.sun.enterprise.security.integration.RealmInitializer;
import com.sun.enterprise.web.AdHocContextValve;
import com.sun.enterprise.web.AdHocServletInfo;
import com.sun.enterprise.web.PersistenceStrategyBuilder;
import com.sun.enterprise.web.PersistenceStrategyBuilderFactory;
import com.sun.enterprise.web.SessionManagerConfigurationHelper;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.pwc.PwcWebModule;
import com.sun.enterprise.web.session.PersistenceType;
import com.sun.enterprise.web.session.SessionCookieConfig;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.FilterMaps;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.web.admin.monitor.ServletProbeProvider;
import org.glassfish.web.admin.monitor.SessionProbeProvider;
import org.glassfish.web.admin.monitor.WebModuleProbeProvider;
import org.glassfish.web.valve.GlassFishValve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebModule
extends PwcWebModule {
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    protected static final ResourceBundle _rb = logger.getResourceBundle();
    private static final String ALTERNATE_FROM = "from=";
    private static final String ALTERNATE_DOCBASE = "dir=";
    private SunWebApp iasBean = null;
    private LocaleCharsetMap[] _lcMap = null;
    private boolean hasBeenXmlConfigured = false;
    private WebContainer webContainer;
    private final HashMap<String, AdHocServletInfo> adHocPaths;
    private boolean hasAdHocPaths;
    private final HashMap<String, AdHocServletInfo> adHocSubtrees;
    private boolean hasAdHocSubtrees;
    private StandardPipeline adHocPipeline;
    private String fileEncoding;
    protected Object[] cachedFinds;
    private com.sun.enterprise.config.serverbeans.WebModule bean;
    protected J2eeApplication appBean = null;
    private WebBundleDescriptor webBundleDescriptor;
    private boolean hasStarted = false;
    private String compEnvId = null;
    private ServerContext serverContext = null;
    private ServletProbeProvider servletProbeProvider = null;
    private SessionProbeProvider sessionProbeProvider = null;
    private WebModuleProbeProvider webModuleProbeProvider = null;
    private String vsId;

    public WebModule(WebContainer webContainer) {
        this.webContainer = webContainer;
        this.servletProbeProvider = webContainer.getServletProbeProvider();
        this.sessionProbeProvider = webContainer.getSessionProbeProvider();
        this.webModuleProbeProvider = webContainer.getWebModuleProbeProvider();
        this.adHocPaths = new HashMap();
        this.adHocSubtrees = new HashMap();
        this.adHocPipeline = new StandardPipeline(this);
        this.adHocPipeline.setBasic(new AdHocContextValve(this));
        this.notifyContainerListeners = false;
    }

    public void setIasWebAppConfigBean(SunWebApp iasBean) {
        this.iasBean = iasBean;
    }

    public SunWebApp getIasWebAppConfigBean() {
        return this.iasBean;
    }

    public WebContainer getWebContainer() {
        return this.webContainer;
    }

    public void setI18nInfo() {
        LocaleCharsetInfo lcinfo;
        if (this.iasBean == null) {
            return;
        }
        if (this.iasBean.isParameterEncoding()) {
            this.formHintField = this.iasBean.getAttributeValue("ParameterEncoding", "FormHintField");
            this.defaultCharset = this.iasBean.getAttributeValue("ParameterEncoding", "DefaultCharset");
        }
        if ((lcinfo = this.iasBean.getLocaleCharsetInfo()) != null) {
            if (lcinfo.getAttributeValue("DefaultLocale") != null) {
                logger.warning("webmodule.default_locale_deprecated");
            }
            if (lcinfo.isParameterEncoding() && !this.iasBean.isParameterEncoding()) {
                this.formHintField = lcinfo.getAttributeValue("ParameterEncoding", "FormHintField");
                this.defaultCharset = lcinfo.getAttributeValue("ParameterEncoding", "DefaultCharset");
            }
            this._lcMap = lcinfo.getLocaleCharsetMap();
        }
    }

    public LocaleCharsetMap[] getLocaleCharsetMap() {
        return this._lcMap;
    }

    @Override
    public boolean hasLocaleToCharsetMapping() {
        LocaleCharsetMap[] locCharsetMap = this.getLocaleCharsetMap();
        return locCharsetMap != null && locCharsetMap.length > 0;
    }

    @Override
    public String mapLocalesToCharset(Enumeration locales) {
        String encoding = null;
        LocaleCharsetMap[] locCharsetMap = this.getLocaleCharsetMap();
        if (locCharsetMap != null && locCharsetMap.length > 0) {
            boolean matchFound = false;
            while (locales.hasMoreElements() && !matchFound) {
                Locale reqLoc = (Locale)locales.nextElement();
                for (int i = 0; i < locCharsetMap.length && !matchFound; ++i) {
                    String language = locCharsetMap[i].getAttributeValue("Locale");
                    if (language == null || language.equals("")) continue;
                    String country = null;
                    int index = language.indexOf(95);
                    if (index != -1) {
                        country = language.substring(index + 1);
                        language = language.substring(0, index);
                    }
                    Locale mapLoc = null;
                    mapLoc = country != null ? new Locale(language, country) : new Locale(language);
                    if (!mapLoc.equals(reqLoc)) continue;
                    encoding = locCharsetMap[i].getAttributeValue("Charset");
                    matchFound = true;
                }
            }
        }
        return encoding;
    }

    public void setXmlConfigured(boolean hasBeenXmlConfigured) {
        this.hasBeenXmlConfigured = hasBeenXmlConfigured;
    }

    public boolean hasBeenXmlConfigured() {
        return this.hasBeenXmlConfigured;
    }

    public void setCachedFindOperation(Object[] cachedFinds) {
        this.cachedFinds = cachedFinds;
    }

    public Object[] getCachedFindOperation() {
        return this.cachedFinds;
    }

    @Override
    public synchronized void start() throws LifecycleException {
        super.start();
        this.configureCatalinaProperties();
        this.webContainer.enableMonitoring(this, this.vsId);
        this.webModuleStartedEvent();
        this.hasStarted = true;
    }

    @Override
    public void stop() throws LifecycleException {
        if (this.hasStarted) {
            this.webContainer.disableMonitoring(this, this.vsId);
            this.webModuleStoppedEvent();
            this.hasStarted = false;
        }
        if (this.webBundleDescriptor != null && this.webBundleDescriptor.getServiceReferenceDescriptors() != null) {
            for (ServiceReferenceDescriptor serviceReferenceDescriptor : this.webBundleDescriptor.getServiceReferenceDescriptors()) {
            }
        }
        super.stop();
    }

    @Override
    public void setParent(Container container) {
        super.setParent(container);
        this.vsId = ((VirtualServer)container).getID();
        Realm ra = this.getRealm();
        if (ra != null && ra instanceof RealmInitializer) {
            ((RealmInitializer)((Object)ra)).setVirtualServer(container);
        }
    }

    @Override
    public boolean hasAdHocPaths() {
        return this.hasAdHocPaths;
    }

    public boolean hasAdHocSubtrees() {
        return this.hasAdHocSubtrees;
    }

    void addAdHocPathAndSubtree(String path, String subtree, AdHocServletInfo servletInfo) {
        if (path == null && subtree == null) {
            return;
        }
        Wrapper adHocWrapper = (Wrapper)this.findChild(servletInfo.getServletName());
        if (adHocWrapper == null) {
            adHocWrapper = this.createAdHocWrapper(servletInfo);
            this.addChild(adHocWrapper);
        }
        if (path != null) {
            this.adHocPaths.put(path, servletInfo);
            this.hasAdHocPaths = true;
        }
        if (subtree != null) {
            this.adHocSubtrees.put(subtree, servletInfo);
            this.hasAdHocSubtrees = true;
        }
    }

    void addAdHocPaths(HashMap newPaths) {
        if (newPaths == null || newPaths.isEmpty()) {
            return;
        }
        for (String adHocPath : newPaths.keySet()) {
            AdHocServletInfo servletInfo = (AdHocServletInfo)newPaths.get(adHocPath);
            Wrapper adHocWrapper = (Wrapper)this.findChild(servletInfo.getServletName());
            if (adHocWrapper == null) {
                adHocWrapper = this.createAdHocWrapper(servletInfo);
                this.addChild(adHocWrapper);
            }
            this.adHocPaths.put(adHocPath, servletInfo);
        }
        this.hasAdHocPaths = true;
    }

    void addAdHocSubtrees(HashMap newSubtrees) {
        if (newSubtrees == null || newSubtrees.isEmpty()) {
            return;
        }
        for (String adHocSubtree : newSubtrees.keySet()) {
            AdHocServletInfo servletInfo = (AdHocServletInfo)newSubtrees.get(adHocSubtree);
            Wrapper adHocWrapper = (Wrapper)this.findChild(servletInfo.getServletName());
            if (adHocWrapper == null) {
                adHocWrapper = this.createAdHocWrapper(servletInfo);
                this.addChild(adHocWrapper);
            }
            this.adHocSubtrees.put(adHocSubtree, servletInfo);
        }
        this.hasAdHocSubtrees = true;
    }

    HashMap getAdHocPaths() {
        return this.adHocPaths;
    }

    HashMap getAdHocSubtrees() {
        return this.adHocSubtrees;
    }

    @Override
    public String getAdHocServletName(String path) {
        if (!this.hasAdHocPaths() && !this.hasAdHocSubtrees()) {
            return null;
        }
        AdHocServletInfo servletInfo = null;
        servletInfo = path == null ? this.adHocPaths.get("") : this.adHocPaths.get(path);
        if (servletInfo == null && path != null && this.hasAdHocSubtrees()) {
            for (String adHocSubtree : this.adHocSubtrees.keySet()) {
                if (!path.startsWith(adHocSubtree)) continue;
                servletInfo = this.adHocSubtrees.get(adHocSubtree);
                break;
            }
        }
        if (servletInfo != null) {
            return servletInfo.getServletName();
        }
        return null;
    }

    void removeAdHocPath(String path) {
        if (path == null) {
            return;
        }
        this.adHocPaths.remove(path);
        if (this.adHocPaths.isEmpty()) {
            this.hasAdHocPaths = false;
        }
    }

    void removeAdHocSubtree(String subtree) {
        if (subtree == null) {
            return;
        }
        this.adHocSubtrees.remove(subtree);
        if (this.adHocSubtrees.isEmpty()) {
            this.hasAdHocSubtrees = false;
        }
    }

    public void addAdHocValve(GlassFishValve valve) {
        this.adHocPipeline.addValve(valve);
    }

    public void removeAdHocValve(GlassFishValve valve) {
        this.adHocPipeline.removeValve(valve);
    }

    public Pipeline getAdHocPipeline() {
        return this.adHocPipeline;
    }

    public void setFileEncoding(String enc) {
        this.fileEncoding = enc;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setAttribute(String name, Object value) {
        this.context.setAttribute(name, value);
    }

    void addFilterMap(ServletFilterMapping sfm) {
        List<String> urlPatterns;
        List<String> servletNames;
        FilterMaps filterMaps = new FilterMaps();
        filterMaps.setFilterName(sfm.getName());
        Set dispatchers = sfm.getDispatchers();
        if (dispatchers != null) {
            Iterator iter = dispatchers.iterator();
            while (iter.hasNext()) {
                filterMaps.setDispatcher((String)iter.next());
            }
        }
        if ((servletNames = sfm.getServletNames()) != null) {
            Iterator<String> iter = servletNames.iterator();
            while (iter.hasNext()) {
                filterMaps.addServletName(iter.next());
            }
        }
        if ((urlPatterns = sfm.getURLPatterns()) != null) {
            Iterator<String> iter = urlPatterns.iterator();
            while (iter.hasNext()) {
                filterMaps.addURLPattern(iter.next());
            }
        }
        this.addFilterMaps(filterMaps);
    }

    private Wrapper createAdHocWrapper(AdHocServletInfo servletInfo) {
        StandardWrapper adHocWrapper = new StandardWrapper();
        adHocWrapper.setServletClass(servletInfo.getServletClass().getName());
        adHocWrapper.setName(servletInfo.getServletName());
        Map<String, String> initParams = servletInfo.getServletInitParams();
        if (initParams != null && !initParams.isEmpty()) {
            for (String paramName : initParams.keySet()) {
                adHocWrapper.addInitParameter(paramName, initParams.get(paramName));
            }
        }
        return adHocWrapper;
    }

    protected void configureCatalinaProperties() {
        List<Property> props;
        String propName = null;
        String propValue = null;
        if (this.bean != null && (props = this.bean.getProperty()) != null) {
            for (Property prop : props) {
                propName = prop.getName();
                propValue = prop.getValue();
                this.configureCatalinaProperties(propName, propValue);
            }
        }
        if (this.iasBean != null && this.iasBean.sizeWebProperty() > 0) {
            WebProperty[] wprops = this.iasBean.getWebProperty();
            for (int i = 0; i < wprops.length; ++i) {
                propName = wprops[i].getAttributeValue("name");
                propValue = wprops[i].getAttributeValue("value");
                this.configureCatalinaProperties(propName, propValue);
            }
        }
    }

    protected void configureCatalinaProperties(String propName, String propValue) {
        if (propName == null || propValue == null) {
            logger.log(Level.WARNING, "webcontainer.nullWebModuleProperty", this.getName());
            return;
        }
        if (propName.startsWith("valve_")) {
            this.addValve(propValue);
        } else if (propName.startsWith("listener_")) {
            this.addListener(propValue);
        }
    }

    protected void addValve(String valveName) {
        Object valve = this.loadInstance(valveName);
        if (valve instanceof Valve) {
            super.addValve((Valve)valve);
        } else if (valve instanceof GlassFishValve) {
            super.addValve((GlassFishValve)valve);
        } else {
            logger.log(Level.WARNING, "Object of type classname " + valveName + " not an instance of Valve or GlassFishValve");
        }
    }

    protected void addListener(String listenerName) {
        Object listener = this.loadInstance(listenerName);
        if (listener == null) {
            return;
        }
        if (listener instanceof ContainerListener) {
            this.addContainerListener((ContainerListener)listener);
        } else if (listener instanceof LifecycleListener) {
            this.addLifecycleListener((LifecycleListener)listener);
        } else if (listener instanceof InstanceListener) {
            this.addInstanceListener(listenerName);
        } else {
            logger.log(Level.SEVERE, "webcontainer.invalidListener" + listenerName);
        }
    }

    private Object loadInstance(String className) {
        try {
            Class<?> clazz = this.getLoader().getClassLoader().loadClass(className);
            return clazz.newInstance();
        }
        catch (Throwable ex) {
            String msg = _rb.getString("webcontainer.unableToLoadExtension");
            msg = MessageFormat.format(msg, className, this.getName());
            logger.log(Level.SEVERE, msg, ex);
            return null;
        }
    }

    public com.sun.enterprise.config.serverbeans.WebModule getBean() {
        return this.bean;
    }

    public void setBean(com.sun.enterprise.config.serverbeans.WebModule bean) {
        this.bean = bean;
    }

    void setApplicationBean(J2eeApplication appBean) {
        this.appBean = appBean;
    }

    public J2eeApplication getApplicationBean() {
        return this.appBean;
    }

    void setWebBundleDescriptor(WebBundleDescriptor wbd) {
        this.webBundleDescriptor = wbd;
    }

    public WebBundleDescriptor getWebBundleDescriptor() {
        return this.webBundleDescriptor;
    }

    public String getComponentId() {
        return this.compEnvId;
    }

    void setComponentId(String compEnvId) {
        this.compEnvId = compEnvId;
    }

    public ServerContext getServerContext() {
        return this.serverContext;
    }

    void setServerContext(ServerContext serverContext) {
        this.serverContext = serverContext;
    }

    void setAlternateDocBases(List<Property> props) {
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            this.parseAlternateDocBase(prop.getName(), prop.getValue());
        }
    }

    void parseAlternateDocBase(String propName, String propValue) {
        if (propName == null || propValue == null) {
            logger.log(Level.WARNING, "Null property name or value");
            return;
        }
        if (!propName.startsWith("alternatedocroot_")) {
            return;
        }
        String urlPattern = null;
        String docBase = null;
        int fromIndex = propValue.indexOf(ALTERNATE_FROM);
        int dirIndex = propValue.indexOf(ALTERNATE_DOCBASE);
        if (fromIndex < 0 || dirIndex < 0) {
            logger.log(Level.WARNING, "webmodule.alternateDocBase.missingPathOrUrlPattern", propValue);
            return;
        }
        if (fromIndex > dirIndex) {
            urlPattern = propValue.substring(fromIndex + ALTERNATE_FROM.length());
            docBase = propValue.substring(dirIndex + ALTERNATE_DOCBASE.length(), fromIndex);
        } else {
            urlPattern = propValue.substring(fromIndex + ALTERNATE_FROM.length(), dirIndex);
            docBase = propValue.substring(dirIndex + ALTERNATE_DOCBASE.length());
        }
        urlPattern = urlPattern.trim();
        if (!this.validateURLPattern(urlPattern)) {
            logger.log(Level.WARNING, "webmodule.alternateDocBase.illegalUrlPattern", urlPattern);
            return;
        }
        docBase = docBase.trim();
        this.addAlternateDocBase(urlPattern, docBase);
    }

    private boolean validateURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return false;
        }
        if (urlPattern.indexOf(10) >= 0 || urlPattern.indexOf(13) >= 0) {
            logger.log(Level.WARNING, "webmodule.alternateDocBase.crlfInUrlPattern", urlPattern);
            return false;
        }
        if (urlPattern.startsWith("*.")) {
            return urlPattern.indexOf(47) < 0;
        }
        return urlPattern.startsWith("/") && urlPattern.indexOf("*.") < 0;
    }

    void configureMiscSettings(SunWebApp bean, VirtualServer vs, String contextPath) {
        boolean allowLinking = vs.getAllowLinking();
        if (bean != null && bean.sizeWebProperty() > 0) {
            WebProperty[] props = bean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (name.equalsIgnoreCase("singleThreadedServletPoolSize")) {
                    int poolSize = this.getSTMPoolSize();
                    try {
                        poolSize = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        Object[] params = new Object[]{value, contextPath, Integer.toString(poolSize)};
                        logger.log(Level.WARNING, "webcontainer.invalidServletPoolSize", params);
                    }
                    if (poolSize <= 0) continue;
                    this.setSTMPoolSize(poolSize);
                    continue;
                }
                if (name.equalsIgnoreCase("tempdir")) {
                    this.setWorkDir(value);
                    continue;
                }
                if (name.equalsIgnoreCase("crossContextAllowed")) {
                    boolean crossContext = Boolean.parseBoolean(value);
                    this.setCrossContext(crossContext);
                    continue;
                }
                if (name.equalsIgnoreCase("allowLinking")) {
                    allowLinking = ConfigBeansUtilities.toBoolean(value);
                    continue;
                }
                if (name.equalsIgnoreCase("reuseSessionID")) {
                    boolean reuse = ConfigBeansUtilities.toBoolean(value);
                    this.setReuseSessionID(reuse);
                    if (!reuse) continue;
                    Object[] params = new Object[]{contextPath, vs.getID()};
                    logger.log(Level.WARNING, "webcontainer.sessionIDsReused", params);
                    continue;
                }
                if (name.equalsIgnoreCase("useResponseCTForHeaders")) {
                    if (!value.equalsIgnoreCase("true")) continue;
                    this.setResponseCTForHeaders();
                    continue;
                }
                if (name.equalsIgnoreCase("encodeCookies")) {
                    boolean flag = ConfigBeansUtilities.toBoolean(value);
                    this.setEncodeCookies(flag);
                    continue;
                }
                if (name.equalsIgnoreCase("relativeRedirectAllowed")) {
                    boolean relativeRedirect = ConfigBeansUtilities.toBoolean(value);
                    this.setAllowRelativeRedirect(relativeRedirect);
                    continue;
                }
                if (name.equalsIgnoreCase("fileEncoding")) {
                    this.setFileEncoding(value);
                    continue;
                }
                if (name.equalsIgnoreCase("enableTldValidation") && ConfigBeansUtilities.toBoolean(value)) {
                    this.setTldValidation(true);
                    continue;
                }
                if (name.equalsIgnoreCase("enableTldNamespaceAware") && ConfigBeansUtilities.toBoolean(value)) {
                    this.setTldNamespaceAware(true);
                    continue;
                }
                if (name.equalsIgnoreCase("securePagesWithPragma")) {
                    boolean securePagesWithPragma = ConfigBeansUtilities.toBoolean(value);
                    this.setSecurePagesWithPragma(securePagesWithPragma);
                    continue;
                }
                if (name.equalsIgnoreCase("useMyFaces")) {
                    this.setUseMyFaces(ConfigBeansUtilities.toBoolean(value));
                    continue;
                }
                if (name.startsWith("alternatedocroot_")) {
                    this.parseAlternateDocBase(name, value);
                    continue;
                }
                Object[] params = new Object[]{name, value};
                logger.log(Level.WARNING, "webcontainer.invalidProperty", params);
            }
        }
        this.setAllowLinking(allowLinking);
    }

    protected void configureSessionSettings(WebBundleDescriptor wbd, WebModuleConfig wmInfo) {
        SessionConfig cfg = null;
        SessionManager smBean = null;
        SessionProperties sessionPropsBean = null;
        CookieProperties cookieBean = null;
        if (this.iasBean != null && (cfg = this.iasBean.getSessionConfig()) != null) {
            smBean = cfg.getSessionManager();
            sessionPropsBean = cfg.getSessionProperties();
            cookieBean = cfg.getCookieProperties();
        }
        this.configureSessionManager(smBean, wbd, wmInfo);
        this.configureSession(sessionPropsBean, wbd);
        this.configureCookieProperties(cookieBean);
    }

    private void configureSessionManager(SessionManager smBean, WebBundleDescriptor wbd, WebModuleConfig wmInfo) {
        PersistenceType persistence = PersistenceType.MEMORY;
        String frequency = null;
        String scope = null;
        SessionManagerConfigurationHelper configHelper = new SessionManagerConfigurationHelper(this, smBean, wbd, wmInfo, this.webContainer.getServerConfigLookup());
        persistence = configHelper.getPersistenceType();
        frequency = configHelper.getPersistenceFrequency();
        scope = configHelper.getPersistenceScope();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("IN WebContainer>>ConfigureSessionManager before builder factory");
            logger.finest("FINAL_PERSISTENCE-TYPE IS = " + persistence.getType());
            logger.finest("FINAL_PERSISTENCE_FREQUENCY IS = " + frequency);
            logger.finest("FINAL_PERSISTENCE_SCOPE IS = " + scope);
        }
        PersistenceStrategyBuilderFactory factory = new PersistenceStrategyBuilderFactory(this.webContainer.getServerConfigLookup());
        PersistenceStrategyBuilder builder = factory.createPersistenceStrategyBuilder(persistence.getType(), frequency, scope, this);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("PersistenceStrategyBuilder class = " + builder.getClass().getName());
        }
        builder.initializePersistenceStrategy(this, smBean, this.webContainer.getServerConfigLookup());
    }

    private void configureSession(SessionProperties spBean, WebBundleDescriptor wbd) {
        boolean timeoutConfigured = false;
        int timeoutSeconds = 1800;
        this.setCookies(this.webContainer.instanceEnableCookies);
        if (spBean != null && spBean.sizeWebProperty() > 0) {
            WebProperty[] props = spBean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (name.equalsIgnoreCase("timeoutSeconds")) {
                    try {
                        timeoutSeconds = Integer.parseInt(value);
                        timeoutConfigured = true;
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (name.equalsIgnoreCase("enableCookies")) {
                    this.setCookies(ConfigBeansUtilities.toBoolean(value));
                    continue;
                }
                Object[] params = new Object[]{name};
                logger.log(Level.INFO, "webcontainer.notYet", params);
            }
        }
        int webXmlTimeoutSeconds = -1;
        if (wbd != null) {
            webXmlTimeoutSeconds = wbd.getSessionTimeout() * 60;
        }
        if (webXmlTimeoutSeconds != -1 && webXmlTimeoutSeconds != 1800) {
            this.getManager().setMaxInactiveIntervalSeconds(webXmlTimeoutSeconds);
        } else if (timeoutConfigured) {
            this.getManager().setMaxInactiveIntervalSeconds(timeoutSeconds);
        }
    }

    private void configureCookieProperties(CookieProperties bean) {
        WebProperty[] props;
        if (bean != null && (props = bean.getWebProperty()) != null) {
            SessionCookieConfig cookieConfig = new SessionCookieConfig();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (name.equalsIgnoreCase("cookieName")) {
                    cookieConfig.setName(value);
                    continue;
                }
                if (name.equalsIgnoreCase("cookiePath")) {
                    cookieConfig.setPath(value);
                    continue;
                }
                if (name.equalsIgnoreCase("cookieMaxAgeSeconds")) {
                    try {
                        cookieConfig.setMaxAge(Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (name.equalsIgnoreCase("cookieDomain")) {
                    cookieConfig.setDomain(value);
                    continue;
                }
                if (name.equalsIgnoreCase("cookieComment")) {
                    cookieConfig.setComment(value);
                    continue;
                }
                Object[] params = new Object[]{name, value};
                logger.log(Level.WARNING, "webcontainer.invalidProperty", params);
            }
            if (props.length > 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("WebModule[" + this.getPath() + "]: " + cookieConfig);
                }
                this.setSessionCookieConfig(cookieConfig);
            }
        }
    }

    public void servletInitializedEvent(Servlet servlet) {
        this.servletProbeProvider.servletInitializedEvent(servlet, this.name, this.vsId);
    }

    public void servletDestroyedEvent(Servlet servlet) {
        this.servletProbeProvider.servletDestroyedEvent(servlet, this.name, this.vsId);
    }

    @Override
    public void sessionCreatedEvent(HttpSession session) {
        this.sessionProbeProvider.sessionCreatedEvent(session, this.name, this.vsId);
    }

    @Override
    public void sessionDestroyedEvent(HttpSession session) {
        this.sessionProbeProvider.sessionDestroyedEvent(session, this.name, this.vsId);
    }

    @Override
    public void sessionRejectedEvent(int maxSessions) {
        this.sessionProbeProvider.sessionRejectedEvent(maxSessions, this.name, this.vsId);
    }

    @Override
    public void sessionExpiredEvent(HttpSession session) {
        this.sessionProbeProvider.sessionExpiredEvent(session, this.name, this.vsId);
    }

    @Override
    public void sessionPersistedStartEvent(HttpSession session) {
        this.sessionProbeProvider.sessionPersistedStartEvent(session, this.name, this.vsId);
    }

    @Override
    public void sessionPersistedEndEvent(HttpSession session) {
        this.sessionProbeProvider.sessionPersistedEndEvent(session, this.name, this.vsId);
    }

    @Override
    public void sessionActivatedStartEvent(HttpSession session) {
        this.sessionProbeProvider.sessionActivatedStartEvent(session, this.name, this.vsId);
    }

    @Override
    public void sessionActivatedEndEvent(HttpSession session) {
        this.sessionProbeProvider.sessionActivatedEndEvent(session, this.name, this.vsId);
    }

    @Override
    public void sessionPassivatedStartEvent(HttpSession session) {
        this.sessionProbeProvider.sessionPassivatedStartEvent(session, this.name, this.vsId);
    }

    @Override
    public void sessionPassivatedEndEvent(HttpSession session) {
        this.sessionProbeProvider.sessionPassivatedEndEvent(session, this.name, this.vsId);
    }

    public void webModuleStartedEvent() {
        this.webModuleProbeProvider.webModuleStartedEvent(this.name, this.vsId);
    }

    public void webModuleStoppedEvent() {
        this.webModuleProbeProvider.webModuleStoppedEvent(this.name, this.vsId);
    }
}

