/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.el.ELContextImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesContextImpl
extends FacesContext {
    private static Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private boolean released;
    private ResponseStream responseStream = null;
    private ResponseWriter responseWriter = null;
    private ExternalContext externalContext = null;
    private Application application = null;
    private UIViewRoot viewRoot = null;
    private ELContext elContext = null;
    private RenderKitFactory rkFactory;
    private RenderKit lastRk;
    private String lastRkId;
    private Map<String, List<FacesMessage>> componentMessageLists;
    private boolean renderResponse = false;
    private boolean responseComplete = false;

    public FacesContextImpl() {
    }

    public FacesContextImpl(ExternalContext ec, Lifecycle lifecycle) {
        Util.notNull("ec", ec);
        Util.notNull("lifecycle", lifecycle);
        this.externalContext = ec;
        FacesContextImpl.setCurrentInstance(this);
        this.rkFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
    }

    @Override
    public ExternalContext getExternalContext() {
        this.assertNotReleased();
        return this.externalContext;
    }

    @Override
    public Application getApplication() {
        this.assertNotReleased();
        if (null != this.application) {
            return this.application;
        }
        ApplicationFactory aFactory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
        this.application = aFactory.getApplication();
        assert (null != this.application);
        return this.application;
    }

    @Override
    public ELContext getELContext() {
        this.assertNotReleased();
        if (this.elContext == null) {
            this.elContext = new ELContextImpl(this.getApplication().getELResolver());
            this.elContext.putContext(FacesContext.class, this);
            UIViewRoot root = this.getViewRoot();
            if (null != root) {
                this.elContext.setLocale(root.getLocale());
            }
        }
        return this.elContext;
    }

    @Override
    public Iterator<String> getClientIdsWithMessages() {
        this.assertNotReleased();
        return this.componentMessageLists == null ? Collections.emptyList().iterator() : this.componentMessageLists.keySet().iterator();
    }

    @Override
    public FacesMessage.Severity getMaximumSeverity() {
        this.assertNotReleased();
        FacesMessage.Severity result = null;
        if (this.componentMessageLists != null && !this.componentMessageLists.isEmpty()) {
            ComponentMessagesIterator i = new ComponentMessagesIterator(this.componentMessageLists);
            while (i.hasNext()) {
                FacesMessage.Severity severity = ((FacesMessage)i.next()).getSeverity();
                if (result == null || severity.compareTo(result) > 0) {
                    result = severity;
                }
                if (result != FacesMessage.SEVERITY_FATAL) continue;
                break;
            }
        }
        return result;
    }

    @Override
    public Iterator<FacesMessage> getMessages() {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }
        if (RequestStateManager.containsKey(this, "com.sun.faces.clientIdMessagesNotDisplayed")) {
            Set pendingClientIds = (Set)RequestStateManager.get(this, "com.sun.faces.clientIdMessagesNotDisplayed");
            pendingClientIds.clear();
        }
        if (this.componentMessageLists.size() > 0) {
            return new ComponentMessagesIterator(this.componentMessageLists);
        }
        List emptyList = Collections.emptyList();
        return emptyList.iterator();
    }

    @Override
    public Iterator<FacesMessage> getMessages(String clientId) {
        this.assertNotReleased();
        Set pendingClientIds = (Set)RequestStateManager.get(this, "com.sun.faces.clientIdMessagesNotDisplayed");
        if (pendingClientIds != null && !pendingClientIds.isEmpty()) {
            pendingClientIds.remove(clientId);
        }
        if (null == this.componentMessageLists) {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }
        List<FacesMessage> list = this.componentMessageLists.get(clientId);
        if (list == null) {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }
        return list.iterator();
    }

    @Override
    public RenderKit getRenderKit() {
        this.assertNotReleased();
        UIViewRoot vr = this.getViewRoot();
        if (vr == null) {
            return null;
        }
        String renderKitId = vr.getRenderKitId();
        if (renderKitId == null) {
            return null;
        }
        if (renderKitId.equals(this.lastRkId)) {
            return this.lastRk;
        }
        this.lastRk = this.rkFactory.getRenderKit(this, renderKitId);
        this.lastRkId = renderKitId;
        return this.lastRk;
    }

    @Override
    public ResponseStream getResponseStream() {
        this.assertNotReleased();
        return this.responseStream;
    }

    @Override
    public void setResponseStream(ResponseStream responseStream) {
        this.assertNotReleased();
        Util.notNull("responseStream", responseStream);
        this.responseStream = responseStream;
    }

    @Override
    public UIViewRoot getViewRoot() {
        this.assertNotReleased();
        return this.viewRoot;
    }

    @Override
    public void setViewRoot(UIViewRoot viewRoot) {
        this.assertNotReleased();
        Util.notNull("viewRoot", viewRoot);
        this.viewRoot = viewRoot;
    }

    @Override
    public ResponseWriter getResponseWriter() {
        this.assertNotReleased();
        return this.responseWriter;
    }

    @Override
    public void setResponseWriter(ResponseWriter responseWriter) {
        this.assertNotReleased();
        Util.notNull("responseWriter", responseWriter);
        this.responseWriter = responseWriter;
    }

    @Override
    public void addMessage(String clientId, FacesMessage message) {
        List<FacesMessage> list;
        this.assertNotReleased();
        Util.notNull("message", message);
        if (this.componentMessageLists == null) {
            this.componentMessageLists = new LinkedHashMap<String, List<FacesMessage>>();
        }
        if ((list = this.componentMessageLists.get(clientId)) == null) {
            list = new ArrayList<FacesMessage>();
            this.componentMessageLists.put(clientId, list);
        }
        list.add(message);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Adding Message[sourceId=" + (clientId != null ? clientId : "<<NONE>>") + ",summary=" + message.getSummary() + ")");
        }
    }

    @Override
    public void release() {
        RequestStateManager.remove(this, "com.sun.faces.FacesContextImpl");
        RequestStateManager.remove(this, "com.sun.faces.clientIdMessagesNotDisplayed");
        this.released = true;
        this.externalContext = null;
        this.responseStream = null;
        this.responseWriter = null;
        this.componentMessageLists = null;
        this.renderResponse = false;
        this.responseComplete = false;
        this.viewRoot = null;
        FacesContextImpl.setCurrentInstance(null);
    }

    @Override
    public void renderResponse() {
        this.assertNotReleased();
        this.renderResponse = true;
    }

    @Override
    public void responseComplete() {
        this.assertNotReleased();
        this.responseComplete = true;
    }

    @Override
    public boolean getRenderResponse() {
        this.assertNotReleased();
        return this.renderResponse;
    }

    @Override
    public boolean getResponseComplete() {
        this.assertNotReleased();
        return this.responseComplete;
    }

    private void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComponentMessagesIterator
    implements Iterator<FacesMessage> {
        private Map<String, List<FacesMessage>> messages;
        private int outerIndex = -1;
        private int messagesSize;
        private Iterator<FacesMessage> inner;
        private Iterator<String> keys;

        ComponentMessagesIterator(Map<String, List<FacesMessage>> messages) {
            this.messages = messages;
            this.messagesSize = messages.size();
            this.keys = messages.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.outerIndex == -1) {
                ++this.outerIndex;
                this.inner = this.messages.get(this.keys.next()).iterator();
            }
            while (!this.inner.hasNext()) {
                ++this.outerIndex;
                if (this.outerIndex < this.messagesSize) {
                    this.inner = this.messages.get(this.keys.next()).iterator();
                    continue;
                }
                return false;
            }
            return this.inner.hasNext();
        }

        @Override
        public FacesMessage next() {
            if (this.outerIndex >= this.messagesSize) {
                throw new NoSuchElementException();
            }
            if (this.inner != null && this.inner.hasNext()) {
                return this.inner.next();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.inner.next();
        }

        @Override
        public void remove() {
            if (this.outerIndex == -1) {
                throw new IllegalStateException();
            }
            this.inner.remove();
        }
    }
}

