/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout;

import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class ViewRootUtil {
    public static final String LAYOUT_DEFINITION_KEY = "_ldKey";

    private ViewRootUtil() {
    }

    public static LayoutDefinition getLayoutDefinition(UIViewRoot root) throws LayoutDefinitionException {
        if (root == null) {
            root = FacesContext.getCurrentInstance().getViewRoot();
        }
        return root == null ? null : ViewRootUtil.getLayoutDefinition(ViewRootUtil.getLayoutDefinitionKey(root));
    }

    public static LayoutDefinition getLayoutDefinition(String key) throws LayoutDefinitionException {
        if (key == null) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Map<String, Object> requestMap = context.getExternalContext().getRequestMap();
        LayoutDefinition ld = (LayoutDefinition)requestMap.get(LAYOUT_DEFINITION_KEY + key);
        if (ld != null) {
            return ld;
        }
        ld = LayoutDefinitionManager.getLayoutDefinition(context, key);
        requestMap.put(LAYOUT_DEFINITION_KEY + key, ld);
        return ld;
    }

    public static String getLayoutDefinitionKey(UIViewRoot root) {
        return (String)root.getAttributes().get(LAYOUT_DEFINITION_KEY);
    }

    public static void setLayoutDefinitionKey(UIViewRoot root, String key) {
        root.getAttributes().put(LAYOUT_DEFINITION_KEY, key);
    }
}

