/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.descriptors;

import com.sun.jsftemplating.component.TemplateComponent;
import com.sun.jsftemplating.layout.descriptors.ComponentType;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutElementBase;
import com.sun.jsftemplating.layout.descriptors.Resource;
import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.layout.event.DecodeEvent;
import com.sun.jsftemplating.layout.event.InitPageEvent;
import com.sun.jsftemplating.util.Util;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutDefinition
extends LayoutElementBase {
    private static final long serialVersionUID = 1L;
    private static final String INIT_PAGE_PREFIX = "__ip";
    public static final String DECODE = "decode";
    public static final String INIT_PAGE = "initPage";
    public static final String STATIC_TEXT_TYPE = "staticText";
    public static final String STATIC_TEXT_FACTORY_CLASS_NAME = "com.sun.jsftemplating.component.factory.basic.StaticTextFactory";
    private List<Resource> _resources = new ArrayList<Resource>();
    private Map<String, ComponentType> _types = null;
    private Map<String, Object> _attributes = new HashMap<String, Object>();
    private static final Class _asyncResponseClass = LayoutDefinition.loadClass("com.sun.faces.extensions.avatar.lifecycle.AsyncResponse", null);
    private static final Method _asyncResponseGetInstance;
    private static final Method _asyncResponseIsAjaxRequest;
    private static final Method _asyncResponseIsRenderAll;

    public LayoutDefinition(String id) {
        super(null, id);
        this.addComponentType(new ComponentType(STATIC_TEXT_TYPE, STATIC_TEXT_FACTORY_CLASS_NAME));
    }

    protected Map<String, ComponentType> getComponentTypes() {
        if (this._types == null) {
            this._types = new HashMap<String, ComponentType>();
        }
        return this._types;
    }

    public ComponentType getComponentType(String typeID) {
        return this.getComponentTypes().get(typeID);
    }

    public void addComponentType(ComponentType type) {
        this.getComponentTypes().put(type.getId(), type);
    }

    public void addResource(Resource res) {
        this._resources.add(res);
    }

    public List<Resource> getResources() {
        return this._resources;
    }

    public void setResources(List<Resource> resources) {
        this._resources = resources;
    }

    public static LayoutElement getChildLayoutElementById(FacesContext context, String id, LayoutElement parent, UIComponent parentComponent) {
        if (parent.getId(context, parentComponent).equals(id)) {
            return parent;
        }
        Iterator<LayoutElement> it = parent.getChildLayoutElements().iterator();
        LayoutElement elt = null;
        while (it.hasNext()) {
            elt = LayoutDefinition.getChildLayoutElementById(context, id, it.next(), parentComponent);
            if (elt == null) continue;
            return elt;
        }
        return null;
    }

    public Object getAttribute(String key) {
        return this._attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this._attributes.put(key, value);
    }

    @Override
    public void encode(FacesContext context, UIComponent component) throws IOException {
        if (component instanceof UIViewRoot) {
            component.encodeBegin(context);
            if (this.isDynaFacesRequest()) {
                component.encodeChildren(context);
            } else {
                super.encode(context, component);
            }
            component.encodeEnd(context);
        } else {
            super.encode(context, component);
        }
    }

    private boolean isDynaFacesRequest() {
        if (_asyncResponseClass == null) {
            return false;
        }
        boolean result = false;
        try {
            result = (Boolean)_asyncResponseIsAjaxRequest.invoke(null, new Object[0]);
            if (result) {
                Object async = _asyncResponseGetInstance.invoke(null, Boolean.FALSE);
                result = (Boolean)_asyncResponseIsRenderAll.invoke(async, new Object[0]) == false;
            }
        }
        catch (Exception ex) {
            System.out.println("Incorrect Dynafaces Version?");
            ex.printStackTrace();
            return false;
        }
        return result;
    }

    @Override
    protected boolean encodeThis(FacesContext context, UIComponent component) throws IOException {
        return true;
    }

    @Override
    public List<Handler> getHandlers(String type, UIComponent comp) {
        List instHandlers;
        List<Handler> handlers = null;
        if (comp != null && !(comp.getParent() instanceof TemplateComponent) && (instHandlers = (List)comp.getAttributes().get(type)) != null && instHandlers.size() > 0) {
            handlers = new ArrayList<Handler>(instHandlers);
            List<Handler> defHandlers = this.getHandlers(type);
            if (defHandlers != null) {
                handlers.addAll(this.getHandlers(type));
            }
        }
        if (handlers == null) {
            handlers = this.getHandlers(type);
        }
        return handlers;
    }

    public void decode(FacesContext context, UIComponent component) {
        this.dispatchHandlers(context, DECODE, new DecodeEvent(component));
    }

    public void dispatchInitPageHandlers(FacesContext ctx, Object source) {
        if (ctx == null) {
            return;
        }
        if (this.isInitPageExecuted(ctx)) {
            return;
        }
        this.dispatchHandlers(ctx, INIT_PAGE, new InitPageEvent(source));
        this.setInitPageExecuted(ctx, Boolean.TRUE);
    }

    public boolean isInitPageExecuted(FacesContext ctx) {
        Map<String, Object> reqAtts = ctx.getExternalContext().getRequestMap();
        String key = INIT_PAGE_PREFIX + this.getId(ctx, null);
        return Boolean.TRUE.equals(reqAtts.get(key));
    }

    public void setInitPageExecuted(FacesContext ctx, boolean value) {
        String key = INIT_PAGE_PREFIX + this.getId(ctx, null);
        ctx.getExternalContext().getRequestMap().put(key, value);
    }

    private static Class loadClass(String className, Object obj) {
        Class result = null;
        try {
            result = Util.loadClass(className, obj);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }

    static {
        if (_asyncResponseClass != null) {
            _asyncResponseGetInstance = Util.getMethod(_asyncResponseClass, "getInstance", Boolean.TYPE);
            _asyncResponseIsAjaxRequest = Util.getMethod(_asyncResponseClass, "isAjaxRequest", new Class[0]);
            _asyncResponseIsRenderAll = Util.getMethod(_asyncResponseClass, "isRenderAll", new Class[0]);
        } else {
            _asyncResponseGetInstance = null;
            _asyncResponseIsAjaxRequest = null;
            _asyncResponseIsRenderAll = null;
        }
    }
}

