/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.DigesterFactory;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.WebRuleSet;
import org.apache.catalina.util.StringManager;
import org.apache.commons.digester.Digester;
import org.glassfish.internal.api.Globals;
import org.glassfish.web.valve.GlassFishValve;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class ContextConfig
implements LifecycleListener {
    private static java.util.logging.Logger log = java.util.logging.Logger.getLogger(ContextConfig.class.getName());
    protected Map customAuthenticators;
    protected static Properties authenticators = null;
    protected Context context = null;
    private int debug = 0;
    protected String defaultContextXml = null;
    protected String defaultWebXml = null;
    protected boolean ok = false;
    protected SAXParseException parseException = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected static Digester contextDigester = null;
    protected static Digester webDigester = null;
    protected static final WebRuleSet webRuleSet = new WebRuleSet();
    private static boolean xmlValidation = false;
    private static boolean xmlNamespaceAware = false;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getDefaultWebXml() {
        if (this.defaultWebXml == null) {
            this.defaultWebXml = "conf/web.xml";
        }
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String path) {
        this.defaultWebXml = path;
    }

    public String getDefaultContextXml() {
        if (this.defaultContextXml == null) {
            this.defaultContextXml = "config/context.xml";
        }
        return this.defaultContextXml;
    }

    public void setDefaultContextXml(String path) {
        this.defaultContextXml = path;
    }

    public void setCustomAuthenticators(Map customAuthenticators) {
        this.customAuthenticators = customAuthenticators;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.context = (Context)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            log.log(Level.SEVERE, sm.getString("contextConfig.cce", event.getLifecycle()), e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        } else if (event.getType().equals("init")) {
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applicationConfig() {
        String altDDName = null;
        InputStream stream = null;
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext != null) {
            altDDName = (String)servletContext.getAttribute("org.apache.catalina.deploy.alt_dd");
            if (altDDName != null) {
                try {
                    stream = new FileInputStream(altDDName);
                }
                catch (FileNotFoundException e) {
                    log.log(Level.SEVERE, sm.getString("contextConfig.altDDNotFound", altDDName));
                }
            } else {
                stream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
            }
        }
        if (stream == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(sm.getString("contextConfig.applicationMissing") + " " + this.context);
            }
            return;
        }
        long t1 = System.currentTimeMillis();
        URL url = null;
        Digester digester = webDigester;
        synchronized (digester) {
            try {
                url = altDDName != null ? new File(altDDName).toURL() : servletContext.getResource("/WEB-INF/web.xml");
                if (url != null) {
                    InputSource is = new InputSource(url.toExternalForm());
                    is.setByteStream(stream);
                    webDigester.clear();
                    webDigester.setDebug(this.getDebug());
                    if (this.context instanceof StandardContext) {
                        ((StandardContext)this.context).setReplaceWelcomeFiles(true);
                    }
                    webDigester.setUseContextClassLoader(false);
                    webDigester.push(this.context);
                    webDigester.parse(is);
                } else {
                    log.info("No web.xml, using defaults " + this.context);
                }
            }
            catch (SAXParseException e) {
                log.log(Level.SEVERE, sm.getString("contextConfig.applicationParse"), e);
                log.log(Level.SEVERE, sm.getString("contextConfig.applicationPosition", (Object)("" + e.getLineNumber()), "" + e.getColumnNumber()));
                this.ok = false;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sm.getString("contextConfig.applicationParse"), e);
                this.ok = false;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, sm.getString("contextConfig.applicationClose"), e);
                }
                webDigester.push(null);
            }
        }
        webRuleSet.recycle();
        long t2 = System.currentTimeMillis();
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setStartupTime(t2 - t1);
        }
    }

    protected synchronized void managerConfig() {
        if (this.context.getManager() == null) {
            this.context.setManager(new StandardManager());
        }
    }

    protected synchronized void authenticatorConfig() {
        Pipeline pipeline;
        String loginMethod;
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = new LoginConfig("NONE", null, null, null);
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context instanceof Authenticator) {
            return;
        }
        if (this.context instanceof ContainerBase) {
            Pipeline pipeline2 = ((ContainerBase)((Object)this.context)).getPipeline();
            if (pipeline2 != null) {
                GlassFishValve basic = pipeline2.getBasic();
                if (basic != null && basic instanceof Authenticator) {
                    return;
                }
                GlassFishValve[] valves = pipeline2.getValves();
                for (int i = 0; i < valves.length; ++i) {
                    if (!(valves[i] instanceof Authenticator)) continue;
                    return;
                }
            }
        } else {
            return;
        }
        Realm rlm = this.context.getRealm();
        if (rlm == null) {
            log.log(Level.SEVERE, sm.getString("contextConfig.missingRealm"));
            this.ok = false;
            return;
        }
        rlm.setRealmName(loginConfig.getRealmName(), loginConfig.getAuthMethod());
        SecurityConstraint[] constraints = this.context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        GlassFishValve authenticator = null;
        if (this.customAuthenticators != null && (loginMethod = loginConfig.getAuthMethod()) != null && this.customAuthenticators.containsKey(loginMethod) && (authenticator = (GlassFishValve)this.customAuthenticators.get(loginMethod)) == null) {
            log.log(Level.SEVERE, sm.getString("contextConfig.authenticatorMissing", loginMethod));
            this.ok = false;
            return;
        }
        if (authenticator == null) {
            if (authenticators == null) {
                try {
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/startup/Authenticators.properties");
                    if (is == null) {
                        log.log(Level.SEVERE, sm.getString("contextConfig.authenticatorResources"));
                        this.ok = false;
                        return;
                    }
                    authenticators = new Properties();
                    authenticators.load(is);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, sm.getString("contextConfig.authenticatorResources"), e);
                    this.ok = false;
                    return;
                }
            }
            String authenticatorName = null;
            String authMethod = loginConfig.getAuthMethod();
            if (authMethod == null) {
                authMethod = "NONE";
            }
            if ((authenticatorName = authenticators.getProperty(authMethod)) == null) {
                log.log(Level.SEVERE, sm.getString("contextConfig.authenticatorMissing", loginConfig.getAuthMethod()));
                this.ok = false;
                return;
            }
            try {
                Class<?> authenticatorClass = Class.forName(authenticatorName);
                authenticator = (GlassFishValve)authenticatorClass.newInstance();
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, sm.getString("contextConfig.authenticatorInstantiate", authenticatorName), t);
                this.ok = false;
            }
        }
        if (authenticator != null && this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
            ((ContainerBase)((Object)this.context)).addValve(authenticator);
            if (log.isLoggable(Level.FINE)) {
                log.fine(sm.getString("contextConfig.authenticatorConfigured", loginConfig.getAuthMethod()));
            }
        }
    }

    public static Digester createWebDigester() {
        Digester webDigester = ContextConfig.createWebXmlDigester(xmlNamespaceAware, xmlValidation);
        return webDigester;
    }

    public static Digester createWebXmlDigester(boolean namespaceAware, boolean validation) {
        DigesterFactory df = Globals.get(DigesterFactory.class);
        return df.newDigester(xmlValidation, xmlNamespaceAware, webRuleSet);
    }

    protected Digester createContextDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        ContextRuleSet contextRuleSet = new ContextRuleSet("", false);
        digester.addRuleSet(contextRuleSet);
        NamingRuleSet namingRuleSet = new NamingRuleSet("Context/");
        digester.addRuleSet(namingRuleSet);
        return digester;
    }

    protected String getBaseDir() {
        Container engineC = this.context.getParent().getParent();
        if (engineC instanceof StandardEngine) {
            return ((StandardEngine)engineC).getBaseDir();
        }
        return System.getProperty("catalina.base");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void defaultConfig() {
        File file;
        long t1 = System.currentTimeMillis();
        if (this.defaultWebXml == null && this.context instanceof StandardContext) {
            this.defaultWebXml = ((StandardContext)this.context).getDefaultWebXml();
        }
        if (this.defaultWebXml == null) {
            this.getDefaultWebXml();
        }
        if (!(file = new File(this.defaultWebXml)).isAbsolute()) {
            file = new File(this.getBaseDir(), this.defaultWebXml);
        }
        InputStream stream = null;
        InputSource source = null;
        try {
            if (!file.exists()) {
                stream = this.getClass().getClassLoader().getResourceAsStream(this.defaultWebXml);
                if (stream != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource(this.defaultWebXml).toString());
                }
                if (stream == null && (stream = this.getClass().getClassLoader().getResourceAsStream("web-embed.xml")) != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource("web-embed.xml").toString());
                }
                if (stream == null) {
                    log.info("No default web.xml");
                    return;
                }
            } else {
                source = new InputSource("file://" + file.getAbsolutePath());
                stream = new FileInputStream(file);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sm.getString("contextConfig.defaultMissing") + " " + this.defaultWebXml + " " + file, e);
            return;
        }
        Digester e = webDigester;
        synchronized (e) {
            try {
                source.setByteStream(stream);
                webDigester.setDebug(this.getDebug());
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setReplaceWelcomeFiles(true);
                }
                webDigester.clear();
                webDigester.setClassLoader(this.getClass().getClassLoader());
                webDigester.setUseContextClassLoader(false);
                webDigester.push(this.context);
                webDigester.parse(source);
            }
            catch (SAXParseException e2) {
                log.log(Level.SEVERE, sm.getString("contextConfig.defaultParse"), e2);
                log.log(Level.SEVERE, sm.getString("contextConfig.defaultPosition", (Object)("" + e2.getLineNumber()), "" + e2.getColumnNumber()));
                this.ok = false;
            }
            catch (Exception e3) {
                log.log(Level.SEVERE, sm.getString("contextConfig.defaultParse"), e3);
                this.ok = false;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e4) {
                    log.log(Level.SEVERE, sm.getString("contextConfig.defaultClose"), e4);
                }
            }
        }
        webRuleSet.recycle();
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 200L) {
            log.fine("Processed default web.xml " + file + " " + (t2 - t1));
        }
    }

    protected void contextConfig() {
        if (this.defaultContextXml == null) {
            this.getDefaultContextXml();
        }
        if (!this.context.getOverride()) {
            this.processContextConfig(new File(this.getBaseDir()), this.defaultContextXml);
        }
        if (this.context.getConfigFile() != null) {
            this.processContextConfig(new File(this.context.getConfigFile()), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContextConfig(File baseDir, String resourceName) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Processing context [" + this.context.getName() + "] configuration file " + baseDir + " " + resourceName);
        }
        InputSource source = null;
        InputStream stream = null;
        File file = baseDir;
        if (resourceName != null) {
            file = new File(baseDir, resourceName);
        }
        try {
            if (!file.exists()) {
                if (resourceName != null && (stream = this.getClass().getClassLoader().getResourceAsStream(resourceName)) != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource(resourceName).toString());
                }
            } else {
                source = new InputSource("file://" + file.getAbsolutePath());
                stream = new FileInputStream(file);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sm.getString("contextConfig.defaultMissing") + " " + resourceName + " " + file, e);
        }
        if (source == null) {
            return;
        }
        Digester digester = contextDigester;
        synchronized (digester) {
            try {
                source.setByteStream(stream);
                contextDigester.setClassLoader(this.getClass().getClassLoader());
                contextDigester.setUseContextClassLoader(false);
                contextDigester.push(this.context.getParent());
                contextDigester.push(this.context);
                contextDigester.setErrorHandler(new ContextErrorHandler());
                contextDigester.parse(source);
                if (this.parseException != null) {
                    this.ok = false;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Successfully processed context [" + this.context.getName() + "] configuration file " + baseDir + " " + resourceName);
                }
            }
            catch (SAXParseException e) {
                log.log(Level.SEVERE, sm.getString("contextConfig.defaultParse"), e);
                log.log(Level.SEVERE, sm.getString("contextConfig.defaultPosition", (Object)("" + e.getLineNumber()), "" + e.getColumnNumber()));
                this.ok = false;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sm.getString("contextConfig.defaultParse"), e);
                this.ok = false;
            }
            finally {
                this.parseException = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, sm.getString("contextConfig.defaultClose"), e);
                }
            }
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.context != null) {
            logger = this.context.getLogger();
        }
        if (logger != null) {
            logger.log("ContextConfig[" + this.context.getName() + "]: " + message);
        } else {
            log.info(message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.context != null) {
            logger = this.context.getLogger();
        }
        if (logger != null) {
            logger.log("ContextConfig[" + this.context.getName() + "] " + message, throwable);
        } else {
            log.log(Level.SEVERE, message, throwable);
        }
    }

    protected void init() {
        if (webDigester == null) {
            webDigester = ContextConfig.createWebDigester();
            webDigester.getParser();
        }
        if (contextDigester == null) {
            contextDigester = this.createContextDigester();
            contextDigester.getParser();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(sm.getString("contextConfig.init"));
        }
        this.context.setConfigured(false);
        this.ok = true;
        this.contextConfig();
    }

    protected synchronized void start() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(sm.getString("contextConfig.start"));
        }
        this.context.setConfigured(false);
        this.ok = true;
        Container container = this.context.getParent();
        if (!this.context.getOverride()) {
            if (container instanceof Host) {
                ((Host)container).importDefaultContext(this.context);
                xmlValidation = this.context.getXmlValidation();
                if (!xmlValidation) {
                    xmlValidation = ((Host)container).getXmlValidation();
                }
                if (!(xmlNamespaceAware = this.context.getXmlNamespaceAware())) {
                    xmlNamespaceAware = ((Host)container).getXmlNamespaceAware();
                }
                container = container.getParent();
            }
            if (container instanceof Engine) {
                ((Engine)container).importDefaultContext(this.context);
            }
        }
        this.defaultConfig();
        this.applicationConfig();
        if (this.ok) {
            this.validateSecurityRoles();
        }
        if (this.ok) {
            this.authenticatorConfig();
        }
        if (this.ok) {
            this.managerConfig();
        }
        if (log.isLoggable(Level.FINEST) && this.context instanceof ContainerBase) {
            log.finest("Pipline Configuration:");
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            GlassFishValve[] valves = null;
            if (pipeline != null) {
                valves = pipeline.getValves();
            }
            if (valves != null) {
                for (int i = 0; i < valves.length; ++i) {
                    log.finest("  " + valves[i].getInfo());
                }
            }
            log.finest("======================");
        }
        if (this.ok) {
            this.context.setConfigured(true);
        } else {
            log.severe(sm.getString("contextConfig.unavailable"));
            this.context.setConfigured(false);
        }
    }

    protected synchronized void stop() {
        int i;
        if (log.isLoggable(Level.FINEST)) {
            log.finest(sm.getString("contextConfig.stop"));
        }
        Container[] children = this.context.findChildren();
        for (i = 0; i < children.length; ++i) {
            this.context.removeChild(children[i]);
        }
        SecurityConstraint[] securityConstraints = this.context.findConstraints();
        for (i = 0; i < securityConstraints.length; ++i) {
            this.context.removeConstraint(securityConstraints[i]);
        }
        ErrorPage[] errorPages = this.context.findErrorPages();
        for (i = 0; i < errorPages.length; ++i) {
            this.context.removeErrorPage(errorPages[i]);
        }
        FilterDef[] filterDefs = this.context.findFilterDefs();
        for (i = 0; i < filterDefs.length; ++i) {
            this.context.removeFilterDef(filterDefs[i]);
        }
        FilterMap[] filterMaps = this.context.findFilterMaps();
        for (i = 0; i < filterMaps.length; ++i) {
            this.context.removeFilterMap(filterMaps[i]);
        }
        String[] mimeMappings = this.context.findMimeMappings();
        for (i = 0; i < mimeMappings.length; ++i) {
            this.context.removeMimeMapping(mimeMappings[i]);
        }
        String[] parameters = this.context.findParameters();
        for (i = 0; i < parameters.length; ++i) {
            this.context.removeParameter(parameters[i]);
        }
        String[] securityRoles = this.context.findSecurityRoles();
        for (i = 0; i < securityRoles.length; ++i) {
            this.context.removeSecurityRole(securityRoles[i]);
        }
        String[] servletMappings = this.context.findServletMappings();
        for (i = 0; i < servletMappings.length; ++i) {
            this.context.removeServletMapping(servletMappings[i]);
        }
        String[] taglibs = this.context.findTaglibs();
        for (i = 0; i < taglibs.length; ++i) {
            this.context.removeTaglib(taglibs[i]);
        }
        String[] welcomeFiles = this.context.findWelcomeFiles();
        for (i = 0; i < welcomeFiles.length; ++i) {
            this.context.removeWelcomeFile(welcomeFiles[i]);
        }
        String[] wrapperLifecycles = this.context.findWrapperLifecycles();
        for (i = 0; i < wrapperLifecycles.length; ++i) {
            this.context.removeWrapperLifecycle(wrapperLifecycles[i]);
        }
        String[] wrapperListeners = this.context.findWrapperListeners();
        for (i = 0; i < wrapperListeners.length; ++i) {
            this.context.removeWrapperListener(wrapperListeners[i]);
        }
        this.ok = true;
    }

    protected void validateSecurityRoles() {
        SecurityConstraint[] constraints = this.context.findConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            String[] roles = constraints[i].findAuthRoles();
            for (int j = 0; j < roles.length; ++j) {
                if ("*".equals(roles[j]) || this.context.findSecurityRole(roles[j])) continue;
                log.info(sm.getString("contextConfig.role.auth", (Object)roles[j], this.context.getName()));
                this.context.addSecurityRole(roles[j]);
            }
        }
        Container[] wrappers = this.context.findChildren();
        for (int i = 0; i < wrappers.length; ++i) {
            Wrapper wrapper = (Wrapper)wrappers[i];
            String runAs = wrapper.getRunAs();
            if (runAs != null && !this.context.findSecurityRole(runAs)) {
                log.info(sm.getString("contextConfig.role.runas", (Object)runAs, this.context.getName()));
                this.context.addSecurityRole(runAs);
            }
            String[] names = wrapper.findSecurityReferences();
            for (int j = 0; j < names.length; ++j) {
                String link = wrapper.findSecurityReference(names[j]);
                if (link == null || this.context.findSecurityRole(link)) continue;
                log.info(sm.getString("contextConfig.role.link", (Object)link, this.context.getName()));
                this.context.addSecurityRole(link);
            }
        }
    }

    protected class ContextErrorHandler
    implements ErrorHandler {
        protected ContextErrorHandler() {
        }

        public void error(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }

        public void fatalError(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }

        public void warning(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }
    }
}

