/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.logging.Level;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.logger.FileLogger;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.security.SecurityConfig;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.IntrospectionUtils;
import org.glassfish.web.valve.GlassFishValve;

public class Embedded
extends StandardService
implements Lifecycle {
    private static java.util.logging.Logger log = java.util.logging.Logger.getLogger(Embedded.class.getName());
    protected boolean useNaming = true;
    protected Engine[] engines = new Engine[0];
    protected HashMap authenticators;
    protected static final String info = "org.apache.catalina.startup.Embedded/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected Logger logger = null;
    protected Realm realm = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected String socketFactory = "org.apache.catalina.net.SSLSocketFactory";
    protected boolean started = false;
    protected boolean await = false;

    public Embedded() {
        this(null, null);
    }

    public Embedded(Logger logger, Realm realm) {
        this.setLogger(logger);
        this.setRealm(realm);
        this.setSecurityProtection();
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        boolean oldUseNaming = this.useNaming;
        this.useNaming = useNaming;
        this.support.firePropertyChange("useNaming", (Object)oldUseNaming, (Object)this.useNaming);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        Logger oldLogger = this.logger;
        this.logger = logger;
        this.support.firePropertyChange("logger", oldLogger, this.logger);
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        Realm oldRealm = this.realm;
        this.realm = realm;
        this.support.firePropertyChange("realm", oldRealm, this.realm);
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(String socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setAwait(boolean b) {
        this.await = b;
    }

    public boolean isAwait() {
        return this.await;
    }

    public void setCatalinaHome(String s) {
        System.setProperty("catalina.home", s);
    }

    public void setCatalinaBase(String s) {
        System.setProperty("catalina.base", s);
    }

    public String getCatalinaHome() {
        return System.getProperty("catalina.home");
    }

    public String getCatalinaBase() {
        return System.getProperty("catalina.base");
    }

    public synchronized void addConnector(Connector connector) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding connector (" + connector.getInfo() + ")");
        }
        if (this.engines.length < 1) {
            throw new IllegalStateException(sm.getString("embedded.noEngines"));
        }
        super.addConnector(connector);
    }

    public synchronized void addEngine(Engine engine) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding engine (" + engine.getInfo() + ")");
        }
        Engine[] results = new Engine[this.engines.length + 1];
        for (int i = 0; i < this.engines.length; ++i) {
            results[i] = this.engines[i];
        }
        results[this.engines.length] = engine;
        this.engines = results;
        if (this.started && engine instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)engine)).start();
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, "Engine.start", e);
            }
        }
        this.container = engine;
    }

    public Connector createConnector(InetAddress address, int port, boolean secure) {
        return this.createConnector(address != null ? address.toString() : null, port, secure);
    }

    public Connector createConnector(String address, int port, boolean secure) {
        String protocol = "http";
        if (secure) {
            protocol = "https";
        }
        return this.createConnector(address, port, protocol);
    }

    public Connector createConnector(InetAddress address, int port, String protocol) {
        return this.createConnector(address != null ? address.toString() : null, port, protocol);
    }

    public Connector createConnector(String address, int port, String protocol) {
        int index;
        Connector connector = null;
        if (address != null && (index = address.indexOf(47)) != -1) {
            address = address.substring(index + 1);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating connector for address='" + (address == null ? "ALL" : address) + "' port='" + port + "' protocol='" + protocol + "'");
        }
        try {
            Class<?> clazz = Class.forName("org.apache.catalina.connector.Connector");
            connector = (Connector)clazz.newInstance();
            if (address != null) {
                IntrospectionUtils.setProperty(connector, "address", "" + address);
            }
            IntrospectionUtils.setProperty(connector, "port", "" + port);
            if (protocol.equals("ajp")) {
                IntrospectionUtils.setProperty(connector, "protocolHandlerClassName", "org.apache.jk.server.JkCoyoteHandler");
            } else if (protocol.equals("https")) {
                connector.setScheme("https");
                connector.setSecure(true);
                try {
                    Class<?> serverSocketFactoryClass = Class.forName("org.apache.catalina.connector.CoyoteServerSocketFactory");
                    ServerSocketFactory factory = (ServerSocketFactory)serverSocketFactoryClass.newInstance();
                    connector.setFactory(factory);
                }
                catch (Exception e) {
                    log.severe("Couldn't load SSL server socket factory.");
                }
            }
        }
        catch (Exception e) {
            log.severe("Couldn't create connector.");
        }
        return connector;
    }

    public Context createContext(String path, String docBase) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating context '" + path + "' with docBase '" + docBase + "'");
        }
        StandardContext context = new StandardContext();
        context.setDebug(this.debug);
        context.setDocBase(docBase);
        context.setPath(path);
        ContextConfig config = new ContextConfig();
        config.setCustomAuthenticators(this.authenticators);
        config.setDebug(this.debug);
        context.addLifecycleListener(config);
        return context;
    }

    public Engine createEngine() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating engine");
        }
        StandardEngine engine = new StandardEngine();
        engine.setDebug(this.debug);
        engine.setLogger(this.logger);
        engine.setRealm(this.realm);
        return engine;
    }

    public Host createHost(String name, String appBase) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating host '" + name + "' with appBase '" + appBase + "'");
        }
        StandardHost host = new StandardHost();
        host.setAppBase(appBase);
        host.setDebug(this.debug);
        host.setName(name);
        return host;
    }

    public Loader createLoader(ClassLoader parent) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Creating Loader with parent class loader '" + parent + "'");
        }
        WebappLoader loader = new WebappLoader(parent);
        return loader;
    }

    public String getInfo() {
        return info;
    }

    public synchronized void removeContext(Context context) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Removing context[" + context.getPath() + "]");
        }
        boolean found = false;
        for (int i = 0; i < this.engines.length; ++i) {
            Container[] hosts = this.engines[i].findChildren();
            for (int j = 0; j < hosts.length; ++j) {
                Container[] contexts = hosts[j].findChildren();
                for (int k = 0; k < contexts.length; ++k) {
                    if (context != (Context)contexts[k]) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (found) break;
        }
        if (!found) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(" Removing this Context");
        }
        context.getParent().removeChild(context);
    }

    public synchronized void removeEngine(Engine engine) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Removing engine (" + engine.getInfo() + ")");
        }
        int j = -1;
        for (int i = 0; i < this.engines.length; ++i) {
            if (engine != this.engines[i]) continue;
            j = i;
            break;
        }
        if (j < 0) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(" Removing related Containers");
        }
        while (true) {
            int n = -1;
            for (int i = 0; i < this.connectors.length; ++i) {
                if (this.connectors[i].getContainer() != engine) continue;
                n = i;
                break;
            }
            if (n < 0) break;
            try {
                this.removeConnector(this.connectors[n]);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Connector.stop", ex);
            }
        }
        if (engine instanceof Lifecycle) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(" Stopping this Engine");
            }
            try {
                ((Lifecycle)((Object)engine)).stop();
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, "Engine.stop", e);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(" Removing this Engine");
        }
        int k = 0;
        Engine[] results = new Engine[this.engines.length - 1];
        for (int i = 0; i < this.engines.length; ++i) {
            if (i == j) continue;
            results[k++] = this.engines[i];
        }
        this.engines = results;
    }

    public synchronized void removeHost(Host host) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Removing host[" + host.getName() + "]");
        }
        boolean found = false;
        for (int i = 0; i < this.engines.length; ++i) {
            Container[] hosts = this.engines[i].findChildren();
            for (int j = 0; j < hosts.length; ++j) {
                if (host != (Host)hosts[j]) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(" Removing this Host");
        }
        host.getParent().removeChild(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthenticator(Authenticator authenticator, String loginMethod) {
        if (authenticator != null && !(authenticator instanceof GlassFishValve)) {
            throw new IllegalArgumentException(sm.getString("embedded.authenticatorNotInstanceOfValve"));
        }
        if (this.authenticators == null) {
            Embedded embedded = this;
            synchronized (embedded) {
                if (this.authenticators == null) {
                    this.authenticators = new HashMap();
                }
            }
        }
        this.authenticators.put(loginMethod, authenticator);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        int i;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Starting Servlet container component of " + ServerInfo.getServerInfo());
        }
        this.initDirs();
        this.initNaming();
        if (this.started) {
            throw new LifecycleException(sm.getString("embedded.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.initialized = true;
        for (i = 0; i < this.connectors.length; ++i) {
            this.connectors[i].initialize();
            if (!(this.connectors[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.connectors[i])).start();
        }
        for (i = 0; i < this.engines.length; ++i) {
            if (!(this.engines[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.engines[i])).start();
        }
    }

    public void stop() throws LifecycleException {
        int i;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Stopping embedded server");
        }
        if (!this.started) {
            throw new LifecycleException(sm.getString("embedded.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        for (i = 0; i < this.connectors.length; ++i) {
            if (!(this.connectors[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.connectors[i])).stop();
        }
        for (i = 0; i < this.engines.length; ++i) {
            if (!(this.engines[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.engines[i])).stop();
        }
    }

    protected void initNaming() {
        if (!this.useNaming) {
            log.fine("Catalina naming disabled");
            System.setProperty("catalina.useNaming", "false");
        } else {
            System.setProperty("catalina.useNaming", "true");
            String value = "org.apache.naming";
            String oldValue = System.getProperty("java.naming.factory.url.pkgs");
            if (oldValue != null) {
                value = value + ":" + oldValue;
            }
            System.setProperty("java.naming.factory.url.pkgs", value);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Setting naming prefix=" + value);
            }
            if ((value = System.getProperty("java.naming.factory.initial")) == null) {
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            } else {
                log.fine("INITIAL_CONTEXT_FACTORY alread set " + value);
            }
        }
    }

    protected void initDirs() {
        String catalinaHome = System.getProperty("catalina.home");
        if (catalinaHome == null) {
            String j2eeHome = System.getProperty("com.sun.enterprise.home");
            if (j2eeHome != null) {
                catalinaHome = System.getProperty("com.sun.enterprise.home");
            } else if (System.getProperty("catalina.base") != null) {
                catalinaHome = System.getProperty("catalina.base");
            } else {
                catalinaHome = IntrospectionUtils.guessInstall("catalina.home", "catalina.base", "catalina.jar");
                if (catalinaHome == null) {
                    catalinaHome = IntrospectionUtils.guessInstall("tomcat.install", "catalina.home", "tomcat.jar");
                }
            }
        }
        if (catalinaHome == null) {
            catalinaHome = System.getProperty("user.dir");
        }
        if (catalinaHome != null) {
            File home = new File(catalinaHome);
            if (!home.isAbsolute()) {
                try {
                    catalinaHome = home.getCanonicalPath();
                }
                catch (IOException e) {
                    catalinaHome = home.getAbsolutePath();
                }
            }
            System.setProperty("catalina.home", catalinaHome);
        }
        if (System.getProperty("catalina.base") == null) {
            System.setProperty("catalina.base", catalinaHome);
        } else {
            String catalinaBase = System.getProperty("catalina.base");
            File base = new File(catalinaBase);
            if (!base.isAbsolute()) {
                try {
                    catalinaBase = base.getCanonicalPath();
                }
                catch (IOException e) {
                    catalinaBase = base.getAbsolutePath();
                }
            }
            System.setProperty("catalina.base", catalinaBase);
        }
    }

    private static void customize(Context context) {
        String basename = context.getPath();
        basename = basename.length() < 1 ? "ROOT" : basename.substring(1);
        FileLogger special = new FileLogger();
        special.setPrefix(basename + "_log.");
        special.setSuffix(".txt");
        special.setTimestamp(true);
        context.setLogger(special);
    }

    protected void setSecurityProtection() {
        SecurityConfig securityConfig = SecurityConfig.newInstance();
        securityConfig.setPackageDefinition();
        securityConfig.setPackageAccess();
    }
}

